/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.common;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class Utils {
    public static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static float percentageToDB(float percentage) {
        return (float)(10.0 * Math.log(percentage));
    }

    public static short bytesToShort(byte b1, byte b2) {
        return (short)((b2 & 0xFF) << 8 | b1 & 0xFF);
    }

    public static byte[] shortToBytes(short s) {
        return new byte[]{(byte)(s & 0xFF), (byte)(s >> 8 & 0xFF)};
    }

    public static byte[] floatToBytes(float[] floats) {
        byte[] bytes = new byte[floats.length * 2];
        for (int i = 0; i < floats.length; ++i) {
            short x = Float.valueOf(floats[i]).shortValue();
            bytes[i * 2] = (byte)(x & 0xFF);
            bytes[i * 2 + 1] = (byte)((x & 0xFF00) >> 8);
        }
        return bytes;
    }

    public static float[] bytesToFloat(byte[] bytes) {
        float[] floats = new float[bytes.length / 2];
        for (int i = 0; i < bytes.length / 2; ++i) {
            floats[i] = (bytes[i * 2 + 1] & 0x80) != 0 ? (float)(Short.MIN_VALUE + ((bytes[i * 2 + 1] & 0x7F) << 8) | bytes[i * 2] & 0xFF) : (float)(bytes[i * 2 + 1] << 8 & 0xFF00 | bytes[i * 2] & 0xFF);
        }
        return floats;
    }

    public static byte[] adjustVolumeMono(byte[] audio, float volume) {
        for (int i = 0; i < audio.length; i += 2) {
            short audioSample = Utils.bytesToShort(audio[i], audio[i + 1]);
            audioSample = (short)((float)audioSample * volume);
            audio[i] = (byte)audioSample;
            audio[i + 1] = (byte)(audioSample >> 8);
        }
        return audio;
    }

    public static byte[] adjustVolumeStereo(byte[] audio, float volumeLeft, float volumeRight) {
        for (int i = 0; i < audio.length; i += 2) {
            short audioSample = Utils.bytesToShort(audio[i], audio[i + 1]);
            audioSample = (short)((float)audioSample * (i % 4 == 0 ? volumeLeft : volumeRight));
            audio[i] = (byte)audioSample;
            audio[i + 1] = (byte)(audioSample >> 8);
        }
        return audio;
    }

    public static byte[] convertToStereo(byte[] audio) {
        byte[] stereo = new byte[audio.length * 2];
        for (int i = 0; i < audio.length; i += 2) {
            stereo[i * 2] = audio[i];
            stereo[i * 2 + 1] = audio[i + 1];
            stereo[i * 2 + 2] = audio[i];
            stereo[i * 2 + 3] = audio[i + 1];
        }
        return stereo;
    }

    public static byte[] convertToStereo(byte[] audio, float volumeLeft, float volumeRight) {
        byte[] stereo = new byte[audio.length * 2];
        for (int i = 0; i < audio.length; i += 2) {
            short audioSample = Utils.bytesToShort(audio[i], audio[i + 1]);
            short left = (short)((float)audioSample * volumeLeft);
            short right = (short)((float)audioSample * volumeRight);
            stereo[i * 2] = (byte)left;
            stereo[i * 2 + 1] = (byte)(left >> 8);
            stereo[i * 2 + 2] = (byte)right;
            stereo[i * 2 + 3] = (byte)(right >> 8);
        }
        return stereo;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Pair<Float, Float> getStereoVolume(Minecraft minecraft, Vector3d soundPos, double voiceChatDistance) {
        float rot;
        ActiveRenderInfo mainCamera = minecraft.field_71460_t.func_215316_n();
        Vector3d cameraPos = mainCamera.func_216785_c();
        Vector3d d = soundPos.func_178788_d(cameraPos).func_72432_b();
        Vector2f diff = new Vector2f((float)d.field_72450_a, (float)d.field_72449_c);
        float diffAngle = Utils.angle(diff, new Vector2f(-1.0f, 0.0f));
        float angle = Utils.normalizeAngle(diffAngle - mainCamera.func_216778_f() % 360.0f);
        float dif = (float)(Math.abs(cameraPos.field_72448_b - soundPos.field_72448_b) / voiceChatDistance);
        float perc = rot = angle / 180.0f;
        if (rot < -0.5f) {
            perc = -(0.5f + (rot + 0.5f));
        } else if (rot > 0.5f) {
            perc = 0.5f - (rot - 0.5f);
        }
        float left = perc < 0.0f ? Math.abs((perc *= 1.0f - dif) * 1.4f) + 0.3f : 0.3f;
        float right = perc >= 0.0f ? perc * 1.4f + 0.3f : 0.3f;
        float fill = 1.0f - Math.max(left, right);
        return new ImmutablePair((Object)Float.valueOf(left += fill), (Object)Float.valueOf(right += fill));
    }

    private static float normalizeAngle(float angle) {
        if ((angle %= 360.0f) <= -180.0f) {
            angle += 360.0f;
        } else if (angle > 180.0f) {
            angle -= 360.0f;
        }
        return angle;
    }

    private static float angle(Vector2f vec1, Vector2f vec2) {
        return (float)Math.toDegrees(Math.atan2(vec1.field_189982_i * vec2.field_189982_i + vec1.field_189983_j * vec2.field_189983_j, vec1.field_189982_i * vec2.field_189983_j - vec1.field_189983_j * vec2.field_189982_i));
    }

    private static float magnitude(Vector2f vec1) {
        return MathHelper.func_76133_a((double)(Math.pow(vec1.field_189982_i, 2.0) + Math.pow(vec1.field_189983_j, 2.0)));
    }

    private static float multiply(Vector2f vec1, Vector2f vec2) {
        return vec1.field_189982_i * vec2.field_189982_i + vec1.field_189983_j * vec2.field_189983_j;
    }

    private static Vector2f rotate(Vector2f vec, float angle) {
        return new Vector2f(vec.field_189982_i * MathHelper.func_76134_b((float)angle) - vec.field_189983_j * MathHelper.func_76126_a((float)angle), vec.field_189982_i * MathHelper.func_76126_a((float)angle) + vec.field_189983_j * MathHelper.func_76134_b((float)angle));
    }

    public static double calculateAudioLevel(byte[] samples, int offset, int length) {
        double rms = 0.0;
        for (int i = offset; i < length; i += 2) {
            double sample = (double)Utils.bytesToShort(samples[i], samples[i + 1]) / 32767.0;
            rms += sample * sample;
        }
        int sampleCount = length / 2;
        rms = sampleCount == 0 ? 0.0 : Math.sqrt(rms / (double)sampleCount);
        double db = rms > 0.0 ? Math.min(Math.max(20.0 * Math.log10(rms), -127.0), 0.0) : -127.0;
        return db;
    }

    public static double getHighestAudioLevel(byte[] samples) {
        double highest = -127.0;
        for (int i = 0; i < samples.length; i += 100) {
            double level = Utils.calculateAudioLevel(samples, i, Math.min(i + 100, samples.length));
            if (!(level > highest)) continue;
            highest = level;
        }
        return highest;
    }

    public static int getActivationOffset(byte[] samples, double activationLevel) {
        int highestPos = -1;
        for (int i = 0; i < samples.length; i += 100) {
            double level = Utils.calculateAudioLevel(samples, i, Math.min(i + 100, samples.length));
            if (!(level >= activationLevel)) continue;
            highestPos = i;
        }
        return highestPos;
    }

    public static double dbToPerc(double db) {
        return (db + 127.0) / 127.0;
    }

    public static double percToDb(double perc) {
        return perc * 127.0 - 127.0;
    }
}

