/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Main;
import de.maxhenkel.voicechat.ServerConfig;
import de.maxhenkel.voicechat.voice.client.AudioChannelConfig;
import de.maxhenkel.voicechat.voice.client.AudioRecorder;
import de.maxhenkel.voicechat.voice.client.Client;
import de.maxhenkel.voicechat.voice.client.DataLines;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.common.Denoiser;
import de.maxhenkel.voicechat.voice.common.MicPacket;
import de.maxhenkel.voicechat.voice.common.NetworkMessage;
import de.maxhenkel.voicechat.voice.common.OpusEncoder;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import net.minecraft.client.Minecraft;

public class MicThread
extends Thread {
    private Client client;
    private TargetDataLine mic;
    private boolean running;
    private boolean microphoneLocked;
    private OpusEncoder encoder;
    @Nullable
    private Denoiser denoiser;
    private boolean activating;
    private int deactivationDelay;
    private byte[] lastBuff;
    private boolean wasPTT;
    private long sequenceNumber = 0L;

    public MicThread(Client client) throws LineUnavailableException {
        this.client = client;
        this.running = true;
        this.encoder = new OpusEncoder(AudioChannelConfig.getSampleRate(), AudioChannelConfig.getFrameSize(), (Integer)Main.SERVER_CONFIG.voiceChatMtuSize.get(), ((ServerConfig.Codec)((Object)Main.SERVER_CONFIG.voiceChatCodec.get())).getOpusValue());
        this.denoiser = Denoiser.createDenoiser();
        if (this.denoiser == null) {
            Main.LOGGER.warn("Denoiser not available");
        }
        this.setDaemon(true);
        this.setName("MicrophoneThread");
        AudioFormat af = AudioChannelConfig.getMonoFormat();
        this.mic = DataLines.getMicrophone(af);
        if (this.mic == null) {
            throw new LineUnavailableException("Could not find any microphone with the specified audio format");
        }
        this.mic.open(af);
        this.mic.start();
        this.mic.stop();
        this.mic.flush();
    }

    @Override
    public void run() {
        while (this.running && this.client.isConnected()) {
            this.client.checkTimeout();
            if (this.microphoneLocked) {
                Utils.sleep(10);
                continue;
            }
            MicrophoneActivationType type = (MicrophoneActivationType)((Object)Main.CLIENT_CONFIG.microphoneActivationType.get());
            if (type.equals((Object)MicrophoneActivationType.PTT)) {
                this.ptt();
                continue;
            }
            if (!type.equals((Object)MicrophoneActivationType.VOICE)) continue;
            this.voice();
        }
    }

    private void voice() {
        this.wasPTT = false;
        if (Main.CLIENT_VOICE_EVENTS.getPlayerStateManager().isMuted() || Main.CLIENT_VOICE_EVENTS.getPlayerStateManager().isDisabled()) {
            this.activating = false;
            if (this.mic.isActive()) {
                this.mic.stop();
                this.mic.flush();
            }
            this.flushRecording();
            Utils.sleep(10);
            return;
        }
        int dataLength = AudioChannelConfig.getFrameSize();
        this.mic.start();
        if (this.mic.available() < dataLength) {
            Utils.sleep(1);
            return;
        }
        byte[] buff = new byte[dataLength];
        this.mic.read(buff, 0, buff.length);
        Utils.adjustVolumeMono(buff, ((Double)Main.CLIENT_CONFIG.microphoneAmplification.get()).floatValue());
        buff = this.denoiseIfEnabled(buff);
        int offset = Utils.getActivationOffset(buff, (Double)Main.CLIENT_CONFIG.voiceActivationThreshold.get());
        if (this.activating) {
            if (offset < 0) {
                if (this.deactivationDelay >= (Integer)Main.CLIENT_CONFIG.deactivationDelay.get()) {
                    this.activating = false;
                    this.deactivationDelay = 0;
                    this.flushRecording();
                } else {
                    this.sendAudioPacket(buff);
                    ++this.deactivationDelay;
                }
            } else {
                this.sendAudioPacket(buff);
            }
        } else if (offset > 0) {
            if (this.lastBuff != null) {
                this.sendAudioPacket(this.lastBuff);
            }
            this.sendAudioPacket(buff);
            this.activating = true;
        }
        this.lastBuff = buff;
    }

    private void ptt() {
        this.activating = false;
        int dataLength = AudioChannelConfig.getFrameSize();
        if (!Main.CLIENT_VOICE_EVENTS.getPttKeyHandler().isPTTDown() || Main.CLIENT_VOICE_EVENTS.getPlayerStateManager().isDisabled()) {
            if (this.wasPTT) {
                this.mic.stop();
                this.mic.flush();
                this.wasPTT = false;
                this.flushRecording();
            }
            Utils.sleep(10);
            return;
        }
        this.wasPTT = true;
        this.mic.start();
        if (this.mic.available() < dataLength) {
            Utils.sleep(1);
            return;
        }
        byte[] buff = new byte[dataLength];
        this.mic.read(buff, 0, buff.length);
        Utils.adjustVolumeMono(buff, ((Double)Main.CLIENT_CONFIG.microphoneAmplification.get()).floatValue());
        buff = this.denoiseIfEnabled(buff);
        this.sendAudioPacket(buff);
    }

    private void sendAudioPacket(byte[] data) {
        try {
            byte[] encoded = this.encoder.encode(data);
            this.client.sendToServer(new NetworkMessage(new MicPacket(encoded, this.sequenceNumber++)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.client.getRecorder() != null) {
                this.client.getRecorder().appendChunk(Minecraft.func_71410_x().func_110432_I().func_148256_e(), System.currentTimeMillis(), Utils.convertToStereo(data));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public byte[] denoiseIfEnabled(byte[] audio) {
        if (this.denoiser != null && ((Boolean)Main.CLIENT_CONFIG.denoiser.get()).booleanValue()) {
            return this.denoiser.denoise(audio);
        }
        return audio;
    }

    private void flushRecording() {
        AudioRecorder recorder = this.client.getRecorder();
        if (recorder == null) {
            return;
        }
        recorder.writeChunkThreaded(Minecraft.func_71410_x().func_110432_I().func_148256_e().getId());
    }

    public TargetDataLine getMic() {
        return this.mic;
    }

    public boolean isTalking() {
        return !this.microphoneLocked && (this.activating || this.wasPTT);
    }

    public void setMicrophoneLocked(boolean microphoneLocked) {
        this.microphoneLocked = microphoneLocked;
        this.activating = false;
        this.wasPTT = false;
        this.deactivationDelay = 0;
        this.lastBuff = null;
    }

    @Nullable
    public Denoiser getDenoiser() {
        return this.denoiser;
    }

    public void close() {
        this.running = false;
        this.mic.stop();
        this.mic.flush();
        this.mic.close();
        this.encoder.close();
        if (this.denoiser != null) {
            this.denoiser.close();
        }
        this.flushRecording();
    }
}

