/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.voice.common.SoundPacket;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class AudioPacketBuffer {
    private final int packetThreshold;
    @Nullable
    private List<SoundPacket> packetBuffer;
    private long lastSequenceNumber = -1L;

    public AudioPacketBuffer(int packetThreshold) {
        this.packetThreshold = packetThreshold;
        if (packetThreshold > 0) {
            this.packetBuffer = new ArrayList<SoundPacket>();
        }
    }

    @Nullable
    public SoundPacket poll(BlockingQueue<SoundPacket> queue) throws InterruptedException {
        SoundPacket packet = queue.poll(10L, TimeUnit.MILLISECONDS);
        if (this.packetThreshold <= 0) {
            return packet;
        }
        if (packet == null) {
            return this.getNext();
        }
        if (this.lastSequenceNumber + 1L == packet.getSequenceNumber()) {
            this.lastSequenceNumber = packet.getSequenceNumber();
            return packet;
        }
        this.addSorted(packet);
        return this.getNext();
    }

    private void addSorted(SoundPacket packet) {
        this.packetBuffer.add(packet);
        this.packetBuffer.sort(Comparator.comparingLong(SoundPacket::getSequenceNumber));
    }

    @Nullable
    private SoundPacket getNext() {
        if (this.packetBuffer.size() > this.packetThreshold) {
            SoundPacket packet = this.packetBuffer.remove(0);
            this.lastSequenceNumber = packet.getSequenceNumber();
            return packet;
        }
        return null;
    }
}

