/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.resourcepacks;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import de.maxhenkel.voicechat.Main;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;

public class VoiceChatResourcePack
extends ResourcePack {
    protected String path;
    protected String name;

    public VoiceChatResourcePack(String name, String path) {
        super(null);
        this.path = path;
        this.name = name;
    }

    public String func_195762_a() {
        return this.name;
    }

    private String getPath() {
        return "/packs/" + this.path + "/";
    }

    @Nullable
    private InputStream get(String name) {
        return Main.class.getResourceAsStream(this.getPath() + name);
    }

    protected InputStream func_195766_a(String name) throws IOException {
        InputStream resourceAsStream = this.get(name);
        if (resourceAsStream == null) {
            throw new IOException("Resource " + name + " does not exist");
        }
        return resourceAsStream;
    }

    protected boolean func_195768_c(String name) {
        try {
            return this.get(name) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Collection<ResourceLocation> func_225637_a_(ResourcePackType type, String namespace, String prefix, int maxDepth, Predicate<String> pathFilter) {
        try {
            URL url = Main.class.getResource(this.getPath());
            Path resPath = Paths.get(url.toURI());
            List files = Files.walk(resPath, new FileVisitOption[0]).collect(Collectors.toList());
            ArrayList list = Lists.newArrayList();
            String absolutePath = type.func_198956_a() + "/" + namespace + "/";
            String absolutePrefixPath = absolutePath + prefix + "/";
            for (Path path : files) {
                String resourcePath;
                String[] splitPath;
                String name;
                if (Files.isDirectory(path, new LinkOption[0]) || (name = path.getFileName().toString()).endsWith(".mcmeta") || !name.startsWith(absolutePrefixPath) || (splitPath = (resourcePath = name.substring(absolutePath.length())).split("/")).length < maxDepth + 1 || !pathFilter.test(splitPath[splitPath.length - 1])) continue;
                list.add(new ResourceLocation(namespace, resourcePath));
            }
            return list;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public Set<String> func_195759_a(ResourcePackType packType) {
        if (packType == ResourcePackType.CLIENT_RESOURCES) {
            return ImmutableSet.of((Object)"voicechat");
        }
        return ImmutableSet.of();
    }

    public void close() {
    }
}

