/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.voicechat.Main;
import de.maxhenkel.voicechat.voice.client.AudioChannelConfig;
import de.maxhenkel.voicechat.voice.client.Client;
import de.maxhenkel.voicechat.voice.client.DataLines;
import de.maxhenkel.voicechat.voice.client.MicThread;
import de.maxhenkel.voicechat.voice.common.Denoiser;
import de.maxhenkel.voicechat.voice.common.Utils;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class MicTestButton
extends AbstractButton {
    private boolean micActive;
    private VoiceThread voiceThread;
    private MicListener micListener;

    public MicTestButton(int xIn, int yIn, int widthIn, int heightIn, MicListener micListener) {
        super(xIn, yIn, widthIn, heightIn, StringTextComponent.field_240750_d_);
        this.micListener = micListener;
        if (this.getMic() == null) {
            this.field_230693_o_ = false;
        }
        this.updateText();
    }

    private void updateText() {
        if (!this.field_230694_p_) {
            this.func_238482_a_((ITextComponent)new TranslationTextComponent("message.voicechat.mic_test_unavailable"));
            return;
        }
        if (this.micActive) {
            this.func_238482_a_((ITextComponent)new TranslationTextComponent("message.voicechat.mic_test_on"));
        } else {
            this.func_238482_a_((ITextComponent)new TranslationTextComponent("message.voicechat.mic_test_off"));
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float partialTicks) {
        super.func_230430_a_(matrixStack, x, y, partialTicks);
        if (this.voiceThread != null) {
            this.voiceThread.updateLastRender();
        }
    }

    public void setMicActive(boolean micActive) {
        this.micActive = micActive;
        this.updateText();
    }

    public void func_230930_b_() {
        this.setMicActive(!this.micActive);
        this.updateText();
        if (this.micActive) {
            if (this.voiceThread != null) {
                this.voiceThread.close();
            }
            try {
                this.voiceThread = new VoiceThread();
                this.voiceThread.start();
            }
            catch (LineUnavailableException e) {
                this.setMicActive(false);
                this.field_230693_o_ = false;
                e.printStackTrace();
            }
        } else if (this.voiceThread != null) {
            this.voiceThread.close();
        }
    }

    private TargetDataLine getMic() {
        Client client = Main.CLIENT_VOICE_EVENTS.getClient();
        if (client == null) {
            return null;
        }
        MicThread micThread = client.getMicThread();
        if (micThread == null) {
            return null;
        }
        return micThread.getMic();
    }

    private void setMicLocked(boolean locked) {
        Client client = Main.CLIENT_VOICE_EVENTS.getClient();
        if (client == null) {
            return;
        }
        MicThread micThread = client.getMicThread();
        if (micThread == null) {
            return;
        }
        micThread.setMicrophoneLocked(locked);
    }

    public static interface MicListener {
        public void onMicValue(double var1);
    }

    private class VoiceThread
    extends Thread {
        private final AudioFormat audioFormat;
        private final TargetDataLine mic;
        private final SourceDataLine speaker;
        private final FloatControl gainControl;
        private boolean running = true;
        private long lastRender;
        @Nullable
        private Denoiser denoiser;

        public VoiceThread() throws LineUnavailableException {
            this.setDaemon(true);
            this.audioFormat = AudioChannelConfig.getMonoFormat();
            this.mic = MicTestButton.this.getMic();
            if (this.mic == null) {
                throw new LineUnavailableException("No microphone");
            }
            this.speaker = DataLines.getSpeaker(this.audioFormat);
            if (this.speaker == null) {
                throw new LineUnavailableException("No speaker");
            }
            this.speaker.open(this.audioFormat);
            this.speaker.start();
            this.speaker.write(new byte[AudioChannelConfig.getFrameSize() * 10], 0, AudioChannelConfig.getFrameSize() * 10);
            this.gainControl = (FloatControl)this.speaker.getControl(FloatControl.Type.MASTER_GAIN);
            this.denoiser = Denoiser.createDenoiser();
            this.updateLastRender();
            MicTestButton.this.setMicLocked(true);
        }

        @Override
        public void run() {
            while (this.running) {
                if (System.currentTimeMillis() - this.lastRender > 500L) {
                    this.close();
                    return;
                }
                this.mic.start();
                int dataLength = AudioChannelConfig.getFrameSize();
                if (this.mic.available() < dataLength) {
                    Utils.sleep(1);
                    continue;
                }
                byte[] buff = new byte[dataLength];
                this.mic.read(buff, 0, buff.length);
                Utils.adjustVolumeMono(buff, ((Double)Main.CLIENT_CONFIG.microphoneAmplification.get()).floatValue());
                if (this.denoiser != null && ((Boolean)Main.CLIENT_CONFIG.denoiser.get()).booleanValue()) {
                    buff = this.denoiser.denoise(buff);
                }
                MicTestButton.this.micListener.onMicValue(Utils.dbToPerc(Utils.getHighestAudioLevel(buff)));
                this.gainControl.setValue(Math.min(Math.max(Utils.percentageToDB(((Double)Main.CLIENT_CONFIG.voiceChatVolume.get()).floatValue()), this.gainControl.getMinimum()), this.gainControl.getMaximum()));
                this.speaker.write(buff, 0, buff.length);
            }
        }

        public void updateLastRender() {
            this.lastRender = System.currentTimeMillis();
        }

        public void close() {
            Main.LOGGER.info("Closing mic test audio channel");
            this.running = false;
            this.speaker.stop();
            this.speaker.flush();
            this.speaker.close();
            this.mic.stop();
            this.mic.flush();
            MicTestButton.this.setMicLocked(false);
            MicTestButton.this.micListener.onMicValue(0.0);
            if (this.denoiser != null) {
                this.denoiser.close();
                this.denoiser = null;
            }
        }
    }
}

