/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.stats;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.stats.BaseMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class HeadMaterialStats
extends BaseMaterialStats
implements IRepairableMaterialStats {
    public static final MaterialStatsId ID = new MaterialStatsId(TConstruct.getResource("head"));
    public static final HeadMaterialStats DEFAULT = new HeadMaterialStats(1, 1.0f, 0, 1.0f);
    private static final List<ITextComponent> DESCRIPTION = ImmutableList.of((Object)ToolStats.DURABILITY.getDescription(), (Object)ToolStats.HARVEST_LEVEL.getDescription(), (Object)ToolStats.MINING_SPEED.getDescription(), (Object)ToolStats.ATTACK_DAMAGE.getDescription());
    public static final Color DURABILITY_COLOR = Color.func_240743_a_((int)-12071865);
    public static final Color MINING_SPEED_COLOR = Color.func_240743_a_((int)-8871731);
    public static final Color ATTACK_COLOR = Color.func_240743_a_((int)-2661276);
    private int durability;
    private float miningSpeed;
    private int harvestLevel;
    private float attack;

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.durability);
        buffer.writeFloat(this.miningSpeed);
        buffer.writeInt(this.harvestLevel);
        buffer.writeFloat(this.attack);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.durability = buffer.readInt();
        this.miningSpeed = buffer.readFloat();
        this.harvestLevel = buffer.readInt();
        this.attack = buffer.readFloat();
    }

    @Override
    public MaterialStatsId getIdentifier() {
        return ID;
    }

    @Override
    public List<ITextComponent> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(ToolStats.DURABILITY.formatValue(this.durability));
        info.add(ToolStats.HARVEST_LEVEL.formatValue(this.harvestLevel));
        info.add(ToolStats.MINING_SPEED.formatValue(this.miningSpeed));
        info.add(ToolStats.ATTACK_DAMAGE.formatValue(this.attack));
        return info;
    }

    @Override
    public List<ITextComponent> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    @Override
    public int getDurability() {
        return this.durability;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public float getAttack() {
        return this.attack;
    }

    public HeadMaterialStats() {
    }

    public HeadMaterialStats(int durability, float miningSpeed, int harvestLevel, float attack) {
        this.durability = durability;
        this.miningSpeed = miningSpeed;
        this.harvestLevel = harvestLevel;
        this.attack = attack;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeadMaterialStats)) {
            return false;
        }
        HeadMaterialStats other = (HeadMaterialStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getDurability() != other.getDurability()) {
            return false;
        }
        if (Float.compare(this.getMiningSpeed(), other.getMiningSpeed()) != 0) {
            return false;
        }
        if (this.getHarvestLevel() != other.getHarvestLevel()) {
            return false;
        }
        return Float.compare(this.getAttack(), other.getAttack()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HeadMaterialStats;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getDurability();
        result = result * 59 + Float.floatToIntBits(this.getMiningSpeed());
        result = result * 59 + this.getHarvestLevel();
        result = result * 59 + Float.floatToIntBits(this.getAttack());
        return result;
    }

    public String toString() {
        return "HeadMaterialStats(durability=" + this.getDurability() + ", miningSpeed=" + this.getMiningSpeed() + ", harvestLevel=" + this.getHarvestLevel() + ", attack=" + this.getAttack() + ")";
    }
}

