/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.melee;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.IncrementalModifier;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class PiercingModifier
extends IncrementalModifier {
    private static final ResourceLocation PIERCING_DEBUFF = TConstruct.getResource("piercing_debuff");

    public PiercingModifier() {
        super(10463085);
    }

    @Override
    public void addVolatileData(ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, int level, ModDataNBT volatileData) {
        float toRemove = 0.5f * this.getScaledLevel(persistentData, level);
        float baseDamage = baseStats.getFloat(ToolStats.ATTACK_DAMAGE);
        if (baseDamage < toRemove) {
            volatileData.putFloat(PIERCING_DEBUFF, toRemove - baseDamage);
        }
    }

    @Override
    public void addToolStats(ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, IModDataReadOnly volatileData, int level, ModifierStatsBuilder builder) {
        float toRemove = 0.5f * this.getScaledLevel(persistentData, level) - volatileData.getFloat(PIERCING_DEBUFF);
        ToolStats.ATTACK_DAMAGE.add(builder, -toRemove);
    }

    @Override
    public int afterEntityHit(IModifierToolStack tool, int level, ToolAttackContext context, float damageDealt) {
        PlayerEntity player = context.getPlayerAttacker();
        DamageSource source = player != null ? DamageSource.func_76365_a((PlayerEntity)player) : DamageSource.func_76358_a((LivingEntity)context.getAttacker());
        source.func_76348_h();
        float secondaryDamage = (this.getScaledLevel(tool, level) * tool.getModifier(ToolStats.ATTACK_DAMAGE) - tool.getVolatileData().getFloat(PIERCING_DEBUFF)) * context.getCooldown();
        if (context.isCritical()) {
            secondaryDamage *= 1.5f;
        }
        ToolAttackUtil.attackEntitySecondary(source, secondaryDamage, context.getTarget(), context.getLivingTarget(), true);
        return 0;
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, boolean isAdvanced, boolean detailed) {
        this.addDamageTooltip(tool, this.getScaledLevel(tool, level) * 1.0f - tool.getVolatileData().getFloat(PIERCING_DEBUFF), tooltip);
    }
}

