/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.general;

import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import slimeknights.tconstruct.library.modifiers.IncrementalModifier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ReinforcedModifier
extends IncrementalModifier {
    public ReinforcedModifier() {
        super(0xCACACA);
    }

    private static float getPercentage(float level) {
        if (level < 5.0f) {
            return 0.025f * level * (11.0f - level);
        }
        return 0.75f + (level - 5.0f) * 0.05f;
    }

    @Override
    public int onDamageTool(IModifierToolStack tool, int level, int amount) {
        float percentage = ReinforcedModifier.getPercentage(this.getScaledLevel(tool, level));
        if (percentage >= 1.0f) {
            return 0;
        }
        if (percentage <= 0.0f) {
            return amount;
        }
        int dealt = 0;
        for (int i = 0; i < amount; ++i) {
            if (!(RANDOM.nextFloat() >= percentage)) continue;
            ++dealt;
        }
        return dealt;
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, boolean isAdvanced, boolean detailed) {
        float reinforced = tool.getModifierLevel((Modifier)TinkerModifiers.unbreakable.get()) > 0 ? 1.0f : ReinforcedModifier.getPercentage(this.getScaledLevel(tool, level));
        tooltip.add((ITextComponent)this.applyStyle(new StringTextComponent(Util.PERCENT_FORMAT.format(reinforced)).func_240702_b_(" ").func_230529_a_(this.makeDisplayName())));
    }
}

