/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class MomentumModifier
extends Modifier {
    public MomentumModifier() {
        super(6310251);
    }

    @Override
    public int getPriority() {
        return 75;
    }

    @Override
    public void onBreakSpeed(IModifierToolStack tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            int effectLevel = ((TinkerEffect)TinkerModifiers.momentumEffect.get()).getLevel(event.getEntityLiving()) + 1;
            event.setNewSpeed(event.getNewSpeed() * (1.0f + (float)(level * effectLevel) / 128.0f));
        }
    }

    @Override
    public void afterBlockBreak(IModifierToolStack tool, int level, ToolHarvestContext context) {
        if (context.canHarvest() && context.isEffective() && !context.isAOE()) {
            LivingEntity living = context.getLiving();
            int effectLevel = Math.min(31, ((TinkerEffect)TinkerModifiers.momentumEffect.get()).getLevel(living) + 1);
            int duration = (int)(10.0f / tool.getStats().getFloat(ToolStats.MINING_SPEED) * 1.5f * 20.0f);
            ((TinkerEffect)TinkerModifiers.momentumEffect.get()).apply(living, duration, effectLevel);
        }
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, boolean isAdvanced, boolean detailed) {
        if (tool.hasTag((ITag<Item>)TinkerTags.Items.HARVEST)) {
            tooltip.add((ITextComponent)this.applyStyle(new StringTextComponent(Util.PERCENT_BOOST_FORMAT.format(0.25 * (double)level)).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent(this.getTranslationKey() + ".mining_speed"))));
        }
    }
}

