/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.internal;

import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.TNTBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.SingleUseModifier;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.helper.aoe.CircleAOEHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class FirestarterModifier
extends SingleUseModifier {
    private final int priority;

    public FirestarterModifier(int color, int priority) {
        super(color);
        this.priority = priority;
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return this.priority > Short.MIN_VALUE;
    }

    @Override
    public ActionResultType onEntityUse(IModifierToolStack tool, int level, PlayerEntity player, LivingEntity target, Hand hand) {
        if (target instanceof CreeperEntity) {
            CreeperEntity creeper = (CreeperEntity)target;
            player.field_70170_p.func_184148_a(player, creeper.func_226277_ct_(), creeper.func_226278_cu_(), creeper.func_226281_cx_(), SoundEvents.field_187649_bu, creeper.func_184176_by(), 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
            if (!player.field_70170_p.field_72995_K) {
                creeper.func_146079_cb();
                ToolDamageUtil.damageAnimated(tool, 1, (LivingEntity)player, hand);
            }
            return ActionResultType.func_233537_a_((boolean)player.field_70170_p.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    private static boolean ignite(IModifierToolStack tool, World world, BlockPos pos, BlockState state, Direction sideHit, Direction horizontalFacing, @Nullable PlayerEntity player) {
        if (CampfireBlock.func_241470_h_((BlockState)state)) {
            world.func_184133_a(player, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)), 11);
            return true;
        }
        if (state.func_177230_c() instanceof TNTBlock) {
            TNTBlock tnt = (TNTBlock)state.func_177230_c();
            tnt.catchFire(state, world, pos, sideHit, (LivingEntity)player);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
            return true;
        }
        BlockPos offset = pos.func_177972_a(sideHit);
        if (AbstractFireBlock.func_241465_a_((World)world, (BlockPos)offset, (Direction)horizontalFacing)) {
            world.func_184133_a(player, offset, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
            world.func_180501_a(offset, AbstractFireBlock.func_235326_a_((IBlockReader)world, (BlockPos)offset), 11);
            return true;
        }
        return false;
    }

    @Override
    public ActionResultType afterBlockUse(IModifierToolStack tool, int level, ItemUseContext context) {
        if (tool.isBroken()) {
            return ActionResultType.PASS;
        }
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction sideHit = context.func_196000_l();
        BlockState state = world.func_180495_p(pos);
        ItemStack stack = context.func_195996_i();
        boolean targetingFire = false;
        if (state.func_235714_a_((ITag)BlockTags.field_232872_am_)) {
            pos = pos.func_177972_a(sideHit.func_176734_d());
            targetingFire = true;
        }
        int range = tool.getModifierLevel((Modifier)TinkerModifiers.fireprimer.get()) + tool.getModifierLevel((Modifier)TinkerModifiers.expanded.get());
        Iterable<Object> targets = Collections.emptyList();
        if (range > 0 && player != null) {
            targets = CircleAOEHarvestLogic.calculate(ToolHarvestLogic.DEFAULT, tool, ItemStack.field_190927_a, world, player, pos, sideHit, 1 + range, true, ToolHarvestLogic.AOEMatchType.TRANSFORM);
        }
        Hand hand = context.func_221531_n();
        Direction horizontalFacing = context.func_195992_f();
        boolean didIgnite = false;
        if (!targetingFire && (didIgnite = FirestarterModifier.ignite(tool, world, pos, state, sideHit, horizontalFacing, player)) && ToolDamageUtil.damage(tool, 1, (LivingEntity)player, stack)) {
            if (player != null) {
                player.func_213334_d(hand);
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        for (BlockPos target : targets) {
            if (!FirestarterModifier.ignite(tool, world, target, world.func_180495_p(target), sideHit, horizontalFacing, player)) continue;
            didIgnite = true;
            if (!ToolDamageUtil.damage(tool, 1, (LivingEntity)player, stack)) continue;
            if (player == null) break;
            player.func_213334_d(hand);
            break;
        }
        return didIgnite ? ActionResultType.func_233537_a_((boolean)world.field_72995_K) : ActionResultType.PASS;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

