/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleType;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.commons.lang3.mutable.MutableInt;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.ClientEventBase;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.client.model.tools.MaterialModel;
import slimeknights.tconstruct.library.client.model.tools.ToolModel;
import slimeknights.tconstruct.library.client.modifiers.BreakableModifierModel;
import slimeknights.tconstruct.library.client.modifiers.FluidModifierModel;
import slimeknights.tconstruct.library.client.modifiers.ModifierModelManager;
import slimeknights.tconstruct.library.client.modifiers.NormalModifierModel;
import slimeknights.tconstruct.library.client.modifiers.TankModifierModel;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.MaterialItem;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.client.OverslimeModifierModel;
import slimeknights.tconstruct.tools.client.particles.AxeAttackParticle;
import slimeknights.tconstruct.tools.client.particles.HammerAttackParticle;

@Mod.EventBusSubscriber(modid="tconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ToolClientEvents
extends ClientEventBase {
    public static void addResourceListener(IReloadableResourceManager manager) {
        ModifierModelManager.init(manager);
    }

    @SubscribeEvent
    static void registerModelLoaders(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)TConstruct.getResource("material"), (IModelLoader)MaterialModel.LOADER);
        ModelLoaderRegistry.registerLoader((ResourceLocation)TConstruct.getResource("tool"), (IModelLoader)ToolModel.LOADER);
    }

    @SubscribeEvent
    static void registerModifierModels(ModifierModelManager.ModifierModelRegistrationEvent event) {
        event.registerModel(TConstruct.getResource("normal"), NormalModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("breakable"), BreakableModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("overslime"), OverslimeModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("fluid"), FluidModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("tank"), TankModifierModel.UNBAKED_INSTANCE);
    }

    @SubscribeEvent
    static void clientSetupEvent(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)TinkerTools.indestructibleItem.get()), manager -> new ItemRenderer(manager, Minecraft.func_71410_x().func_175599_af()));
        MinecraftForge.EVENT_BUS.addListener(ToolClientEvents::onTooltipEvent);
        MinecraftForge.EVENT_BUS.addListener(ToolClientEvents::renderHand);
    }

    @SubscribeEvent
    static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)TinkerTools.hammerAttackParticle.get(), HammerAttackParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)TinkerTools.axeAttackParticle.get(), AxeAttackParticle.Factory::new);
    }

    @SubscribeEvent
    static void itemColors(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.pickaxe);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.sledgeHammer);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.veinHammer);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.mattock);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.excavator);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.handAxe);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.broadAxe);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.kama);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.scythe);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.dagger);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.sword);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.cleaver);
    }

    private static void onTooltipEvent(ItemTooltipEvent event) {
        if (event.getItemStack().func_77973_b() instanceof IModifiableDisplay) {
            boolean isShift = Screen.func_231173_s_();
            boolean isCtrl = !isShift && ((IModifiableDisplay)event.getItemStack().func_77973_b()).getToolDefinition().isMultipart() && Screen.func_231172_r_();
            MutableInt removedWhenIn = new MutableInt(0);
            event.getToolTip().removeIf(text -> {
                List siblings;
                if ((isShift || isCtrl && removedWhenIn.intValue() > 0) && text == StringTextComponent.field_240750_d_) {
                    return true;
                }
                if ((isShift || isCtrl) && " ".equals(text.func_150261_e()) && !(siblings = text.func_150253_a()).isEmpty() && siblings.get(0) instanceof TranslationTextComponent) {
                    return ((TranslationTextComponent)siblings.get(0)).func_150268_i().startsWith("attribute.modifier.equals.");
                }
                if (text instanceof TranslationTextComponent) {
                    String key = ((TranslationTextComponent)text).func_150268_i();
                    if ((isCtrl || isShift) && key.startsWith("item.modifiers.")) {
                        removedWhenIn.add(1);
                        return true;
                    }
                    return key.equals("item.durability") || (isCtrl || isShift && removedWhenIn.intValue() > 1) && key.startsWith("attribute.modifier.");
                }
                return false;
            });
        }
    }

    private static void renderHand(RenderHandEvent event) {
        ToolStack tool;
        Hand hand = event.getHand();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (hand != Hand.OFF_HAND || player == null) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (!(!stack.func_77973_b().func_206844_a(TinkerTags.Items.TWO_HANDED) || (tool = ToolStack.from(stack)).getVolatileData().getBoolean(IModifiable.DEFER_OFFHAND) || event.getItemStack().func_77973_b() instanceof BlockItem && tool.getModifierLevel((Modifier)TinkerModifiers.exchanging.get()) != 0)) {
            event.setCanceled(true);
        }
    }

    @Deprecated
    public static void registerMaterialItemColors(ItemColors colors, Supplier<? extends MaterialItem> item) {
    }

    public static void registerToolItemColors(ItemColors colors, Supplier<? extends IModifiable> item) {
        colors.func_199877_a(ToolModel.COLOR_HANDLER, new IItemProvider[]{item.get()});
    }
}

