/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.inventory;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.inventory.EmptyItemHandler;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.shared.inventory.TriggeringMultiModuleContainer;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.block.ITinkerStationBlock;
import slimeknights.tconstruct.tables.client.inventory.BaseStationScreen;
import slimeknights.tconstruct.tables.inventory.SideInventoryContainer;

public class BaseStationContainer<TILE extends TileEntity>
extends TriggeringMultiModuleContainer<TILE> {
    private static final TinkerBlockComp COMPARATOR = new TinkerBlockComp();
    public final List<Pair<BlockPos, BlockState>> stationBlocks = Lists.newLinkedList();

    public BaseStationContainer(ContainerType<?> containerType, int id, @Nullable PlayerInventory inv, @Nullable TILE tile) {
        super(containerType, id, inv, tile);
        if (tile != null && tile.func_145831_w() != null) {
            this.detectStationParts(tile.func_145831_w(), tile.func_174877_v());
        }
    }

    public void detectStationParts(World world, BlockPos start) {
        HashSet visited = Sets.newHashSet();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(start);
        while (!queue.isEmpty()) {
            BlockState state;
            BlockPos pos = (BlockPos)queue.poll();
            if (visited.contains(pos) || !((state = world.func_180495_p(pos)).func_177230_c() instanceof ITinkerStationBlock)) continue;
            for (Direction direction : Direction.values()) {
                BlockPos offset = pos.func_177972_a(direction);
                if (visited.contains(offset)) continue;
                queue.add(offset);
            }
            visited.add(pos);
            this.stationBlocks.add((Pair<BlockPos, BlockState>)Pair.of((Object)pos, (Object)state));
            if (this.stationBlocks.size() < 6) continue;
            break;
        }
        this.stationBlocks.sort(COMPARATOR);
    }

    protected void addChestSideInventory() {
        if (this.tile == null || this.inv == null) {
            return;
        }
        World world = this.tile.func_145831_w();
        if (world != null) {
            TileEntity inventoryTE = null;
            Direction accessDir = null;
            BlockPos pos = this.tile.func_174877_v();
            block0: for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos neighbor = pos.func_177972_a(dir);
                for (Pair<BlockPos, BlockState> tinkerPos : this.stationBlocks) {
                    if (!((BlockPos)tinkerPos.getLeft()).equals((Object)neighbor)) continue;
                    continue block0;
                }
                TileEntity te = world.func_175625_s(neighbor);
                if (te == null || !BaseStationContainer.isUsable(te, this.inv.field_70458_d)) continue;
                if (BaseStationContainer.hasItemHandler(te, null)) {
                    inventoryTE = te;
                    accessDir = null;
                    break;
                }
                Direction side = dir.func_176734_d();
                if (!BaseStationContainer.hasItemHandler(te, side)) continue;
                inventoryTE = te;
                accessDir = side;
                break;
            }
            if (inventoryTE != null) {
                int invSlots = ((IItemHandler)inventoryTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, accessDir).orElse((Object)EmptyItemHandler.INSTANCE)).getSlots();
                int columns = MathHelper.func_76125_a((int)((invSlots - 1) / 9 + 1), (int)3, (int)6);
                this.addSubContainer((Container)new SideInventoryContainer<TileEntity>((ContainerType)TinkerTables.craftingStationContainer.get(), this.field_75152_c, this.inv, inventoryTE, accessDir, -114, 8, columns), false);
            }
        }
    }

    private static boolean isUsable(TileEntity tileEntity, PlayerEntity player) {
        return !TinkerTags.TileEntityTypes.CRAFTING_STATION_BLACKLIST.func_230235_a_((Object)tileEntity.func_200662_C()) && (!(tileEntity instanceof IInventory) || ((IInventory)tileEntity).func_70300_a(player));
    }

    private static boolean hasItemHandler(TileEntity tileEntity, @Nullable Direction direction) {
        return tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).filter(cap -> cap instanceof IItemHandlerModifiable).isPresent();
    }

    public void updateScreen() {
        if (this.tile != null && this.tile.func_145831_w() != null && this.tile.func_145831_w().field_72995_K) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> BaseStationContainer::clientScreenUpdate);
        }
    }

    public void error(IFormattableTextComponent message) {
        if (this.tile != null && this.tile.func_145831_w() != null && this.tile.func_145831_w().field_72995_K) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> BaseStationContainer.clientError(message));
        }
    }

    public void warning(IFormattableTextComponent message) {
        if (this.tile != null && this.tile.func_145831_w() != null && this.tile.func_145831_w().field_72995_K) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> BaseStationContainer.clientWarning(message));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void clientScreenUpdate() {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof BaseStationScreen) {
            ((BaseStationScreen)screen).updateDisplay();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void clientError(IFormattableTextComponent errorMessage) {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof BaseStationScreen) {
            ((BaseStationScreen)screen).error((ITextComponent)errorMessage);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void clientWarning(IFormattableTextComponent warningMessage) {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof BaseStationScreen) {
            ((BaseStationScreen)screen).warning((ITextComponent)warningMessage);
        }
    }

    private static class TinkerBlockComp
    implements Comparator<Pair<BlockPos, BlockState>> {
        private TinkerBlockComp() {
        }

        @Override
        public int compare(Pair<BlockPos, BlockState> o1, Pair<BlockPos, BlockState> o2) {
            int sum2;
            BlockPos pos1 = (BlockPos)o1.getLeft();
            BlockPos pos2 = (BlockPos)o2.getLeft();
            int sum1 = pos1.func_177958_n() + pos1.func_177956_o() + pos1.func_177952_p();
            if (sum1 != (sum2 = pos2.func_177958_n() + pos2.func_177956_o() + pos2.func_177952_p())) {
                return Integer.compare(sum1, sum2);
            }
            if (pos1.func_177956_o() != pos2.func_177956_o()) {
                return Integer.compare(pos1.func_177956_o(), pos2.func_177956_o());
            }
            if (pos1.func_177958_n() != pos2.func_177958_n()) {
                return Integer.compare(pos1.func_177958_n(), pos2.func_177958_n());
            }
            return Integer.compare(pos1.func_177952_p(), pos2.func_177952_p());
        }
    }
}

