/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipe;
import slimeknights.tconstruct.shared.tileentity.TableTileEntity;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.network.FluidUpdatePacket;
import slimeknights.tconstruct.smeltery.recipe.TileCastingWrapper;
import slimeknights.tconstruct.smeltery.tileentity.inventory.MoldingInventoryWrapper;
import slimeknights.tconstruct.smeltery.tileentity.tank.CastingFluidHandler;

public abstract class CastingTileEntity
extends TableTileEntity
implements ITickableTileEntity,
ISidedInventory,
FluidUpdatePacket.IFluidPacketReceiver {
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    private static final String TAG_TANK = "tank";
    private static final String TAG_TIMER = "timer";
    private static final String TAG_RECIPE = "recipe";
    private final CastingFluidHandler tank = new CastingFluidHandler(this);
    private final LazyOptional<CastingFluidHandler> holder = LazyOptional.of(() -> this.tank);
    private final IRecipeType<ICastingRecipe> castingType;
    private final TileCastingWrapper castingInventory;
    private int timer;
    private ICastingRecipe currentRecipe;
    private ResourceLocation recipeName;
    private ICastingRecipe lastCastingRecipe;
    private ItemStack lastOutput = null;
    private final IRecipeType<MoldingRecipe> moldingType;
    private final MoldingInventoryWrapper moldingInventory;
    private MoldingRecipe lastMoldingRecipe;

    protected CastingTileEntity(TileEntityType<?> tileEntityTypeIn, IRecipeType<ICastingRecipe> castingType, IRecipeType<MoldingRecipe> moldingType) {
        super(tileEntityTypeIn, "gui.tconstruct.casting", 2, 1);
        this.itemHandler = new SidedInvWrapper((ISidedInventory)this, Direction.DOWN);
        this.castingType = castingType;
        this.moldingType = moldingType;
        this.castingInventory = new TileCastingWrapper(this);
        this.moldingInventory = new MoldingInventoryWrapper((IItemHandler)this.itemHandler, 0);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void interact(PlayerEntity player, Hand hand) {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.tank.isEmpty()) {
            return;
        }
        ItemStack held = player.func_184586_b(hand);
        ItemStack input = this.func_70301_a(0);
        ItemStack output = this.func_70301_a(1);
        if (!input.func_190926_b() && output.func_190926_b()) {
            this.moldingInventory.setPattern(held);
            MoldingRecipe recipe = this.findMoldingRecipe();
            if (recipe != null) {
                ItemStack result = recipe.func_77572_b((IInventory)this.moldingInventory);
                if (held.func_190926_b()) {
                    this.func_70299_a(0, ItemStack.field_190927_a);
                    player.func_184611_a(hand, result);
                } else {
                    this.func_70299_a(0, result);
                    if (!recipe.isPatternConsumed()) {
                        this.func_70299_a(1, ItemHandlerHelper.copyStackWithSize((ItemStack)held, (int)1));
                        this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
                    }
                    held.func_190918_g(1);
                    player.func_184611_a(hand, held.func_190926_b() ? ItemStack.field_190927_a : held);
                }
                this.moldingInventory.setPattern(ItemStack.field_190927_a);
                return;
            }
            this.moldingInventory.setPattern(ItemStack.field_190927_a);
            recipe = this.findMoldingRecipe();
            if (recipe != null) {
                this.func_70299_a(0, ItemStack.field_190927_a);
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)recipe.func_77572_b((IInventory)this.moldingInventory), (int)player.field_71071_by.field_70461_c);
                return;
            }
            this.moldingInventory.setPattern(ItemStack.field_190927_a);
        }
        if (input.func_190926_b() && output.func_190926_b()) {
            if (!held.func_190926_b()) {
                ItemStack stack = held.func_77979_a(this.stackSizeLimit);
                player.func_184611_a(hand, held.func_190926_b() ? ItemStack.field_190927_a : held);
                this.func_70299_a(0, stack);
            }
        } else {
            int slot = output.func_190926_b() ? 0 : 1;
            ItemStack stack = this.func_70301_a(slot);
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack, (int)player.field_71071_by.field_70461_c);
            this.func_70299_a(slot, ItemStack.field_190927_a);
            if (slot == 1) {
                this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
            }
        }
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        ItemStack original = this.func_70301_a(slot);
        super.func_70299_a(slot, stack);
        if (original.func_190926_b() != stack.func_190926_b() && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
    }

    @Nonnull
    public int[] func_180463_a(Direction side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.tank.isEmpty() && index == 0 && !this.isStackInSlot(1);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return this.tank.isEmpty() && index == 1;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.currentRecipe == null) {
            return;
        }
        FluidStack currentFluid = this.tank.getFluid();
        if (currentFluid.getAmount() >= this.tank.getCapacity() && !currentFluid.isEmpty()) {
            ++this.timer;
            if (!this.field_145850_b.field_72995_K) {
                this.castingInventory.setFluid(currentFluid.getFluid());
                if (this.timer >= this.currentRecipe.getCoolingTime(this.castingInventory)) {
                    if (!this.currentRecipe.func_77569_a((IInventory)this.castingInventory, this.field_145850_b)) {
                        this.currentRecipe = this.findCastingRecipe();
                        this.recipeName = null;
                        if (this.currentRecipe == null || this.currentRecipe.getFluidAmount(this.castingInventory) > currentFluid.getAmount()) {
                            this.timer = 0;
                            return;
                        }
                    }
                    ItemStack output = this.currentRecipe.func_77572_b((IInventory)this.castingInventory);
                    if (this.currentRecipe.switchSlots()) {
                        if (!this.currentRecipe.isConsumed()) {
                            this.func_70299_a(1, this.func_70301_a(0));
                        }
                        this.func_70299_a(0, output);
                    } else {
                        if (this.currentRecipe.isConsumed()) {
                            this.func_70299_a(0, ItemStack.field_190927_a);
                        }
                        this.func_70299_a(1, output);
                    }
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, Sounds.CASTING_COOLS.getSound(), SoundCategory.AMBIENT, 0.5f, 4.0f);
                    this.reset();
                    this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
                }
            } else if (this.field_145850_b.field_73012_v.nextFloat() > 0.9f) {
                this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177956_o() + 1.1, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    private ICastingRecipe findCastingRecipe() {
        if (this.field_145850_b == null) {
            return null;
        }
        if (this.lastCastingRecipe != null && this.lastCastingRecipe.func_77569_a((IInventory)this.castingInventory, this.field_145850_b)) {
            return this.lastCastingRecipe;
        }
        ICastingRecipe castingRecipe = this.field_145850_b.func_199532_z().func_215371_a(this.castingType, (IInventory)this.castingInventory, this.field_145850_b).orElse(null);
        if (castingRecipe != null) {
            this.lastCastingRecipe = castingRecipe;
        }
        return castingRecipe;
    }

    @Nullable
    private MoldingRecipe findMoldingRecipe() {
        if (this.field_145850_b == null) {
            return null;
        }
        if (this.lastMoldingRecipe != null && this.lastMoldingRecipe.matches(this.moldingInventory, this.field_145850_b)) {
            return this.lastMoldingRecipe;
        }
        Optional newRecipe = this.field_145850_b.func_199532_z().func_215371_a(this.moldingType, (IInventory)this.moldingInventory, this.field_145850_b);
        if (newRecipe.isPresent()) {
            this.lastMoldingRecipe = (MoldingRecipe)newRecipe.get();
            return this.lastMoldingRecipe;
        }
        return null;
    }

    public int initNewCasting(Fluid fluid, IFluidHandler.FluidAction action) {
        boolean hasOutput;
        if (this.currentRecipe != null || this.recipeName != null) {
            return 0;
        }
        boolean hasInput = !this.func_70301_a(0).func_190926_b();
        boolean bl = hasOutput = !this.func_70301_a(1).func_190926_b();
        if (hasInput && hasOutput) {
            return 0;
        }
        this.castingInventory.setFluid(fluid);
        if (!hasOutput) {
            this.castingInventory.useInput();
            ICastingRecipe castingRecipe = this.findCastingRecipe();
            if (castingRecipe != null) {
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.currentRecipe = castingRecipe;
                    this.recipeName = null;
                    this.lastOutput = null;
                }
                return castingRecipe.getFluidAmount(this.castingInventory);
            }
        } else {
            this.castingInventory.useOutput();
            ICastingRecipe castingRecipe = this.findCastingRecipe();
            if (castingRecipe != null) {
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.currentRecipe = castingRecipe;
                    this.recipeName = null;
                    this.lastOutput = null;
                    this.func_70299_a(0, this.func_70301_a(1));
                    this.func_70299_a(1, ItemStack.field_190927_a);
                    this.castingInventory.useInput();
                }
                return castingRecipe.getFluidAmount(this.castingInventory);
            }
        }
        return 0;
    }

    public void reset() {
        this.timer = 0;
        this.currentRecipe = null;
        this.recipeName = null;
        this.lastOutput = null;
        this.castingInventory.setFluid(Fluids.field_204541_a);
        this.tank.reset();
    }

    @Override
    public void updateFluidTo(FluidStack fluid) {
        if (fluid.isEmpty()) {
            this.reset();
        } else {
            int capacity = this.initNewCasting(fluid.getFluid(), IFluidHandler.FluidAction.EXECUTE);
            if (capacity > 0) {
                this.tank.setCapacity(capacity);
            }
        }
        this.tank.setFluid(fluid);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return null;
    }

    public ItemStack getRecipeOutput() {
        if (this.lastOutput == null) {
            if (this.currentRecipe == null) {
                return ItemStack.field_190927_a;
            }
            this.castingInventory.setFluid(this.tank.getFluid().getFluid());
            this.lastOutput = this.currentRecipe.func_77572_b((IInventory)this.castingInventory);
        }
        return this.lastOutput;
    }

    public int getRecipeTime() {
        if (this.currentRecipe == null) {
            return -1;
        }
        return this.currentRecipe.getCoolingTime(this.castingInventory);
    }

    private void loadRecipe(World world, ResourceLocation name) {
        FluidStack fluid = this.tank.getFluid();
        if (!fluid.isEmpty()) {
            RecipeHelper.getRecipe((RecipeManager)world.func_199532_z(), (ResourceLocation)name, ICastingRecipe.class).ifPresent(recipe -> {
                this.currentRecipe = recipe;
                this.castingInventory.setFluid(fluid.getFluid());
                this.tank.setCapacity(recipe.getFluidAmount(this.castingInventory));
            });
        }
    }

    public void func_226984_a_(World world, BlockPos pos) {
        super.func_226984_a_(world, pos);
        if (this.recipeName != null) {
            this.loadRecipe(world, this.recipeName);
            this.recipeName = null;
        }
    }

    public void writeSynced(CompoundNBT tags) {
        super.writeSynced(tags);
        tags.func_218657_a(TAG_TANK, (INBT)this.tank.writeToNBT(new CompoundNBT()));
        tags.func_74768_a(TAG_TIMER, this.timer);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tags) {
        tags = super.func_189515_b(tags);
        if (this.currentRecipe != null) {
            tags.func_74778_a(TAG_RECIPE, this.currentRecipe.func_199560_c().toString());
        } else if (this.recipeName != null) {
            tags.func_74778_a(TAG_RECIPE, this.recipeName.toString());
        }
        return tags;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tags) {
        super.func_230337_a_(state, tags);
        this.tank.readFromNBT(tags.func_74775_l(TAG_TANK));
        this.timer = tags.func_74762_e(TAG_TIMER);
        if (tags.func_150297_b(TAG_RECIPE, 8)) {
            ResourceLocation name = new ResourceLocation(tags.func_74779_i(TAG_RECIPE));
            if (this.field_145850_b != null) {
                this.loadRecipe(this.field_145850_b, name);
            } else {
                this.recipeName = name;
            }
        }
    }

    public CastingFluidHandler getTank() {
        return this.tank;
    }

    public int getTimer() {
        return this.timer;
    }

    public static class Table
    extends CastingTileEntity {
        public Table() {
            super((TileEntityType)TinkerSmeltery.table.get(), RecipeTypes.CASTING_TABLE, RecipeTypes.MOLDING_TABLE);
        }
    }

    public static class Basin
    extends CastingTileEntity {
        public Basin() {
            super((TileEntityType)TinkerSmeltery.basin.get(), RecipeTypes.CASTING_BASIN, RecipeTypes.MOLDING_BASIN);
        }
    }
}

