/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.inventory;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.client.inventory.IScreenWithFluidTank;
import slimeknights.tconstruct.smeltery.client.inventory.module.GuiFuelModule;
import slimeknights.tconstruct.smeltery.client.inventory.module.GuiMeltingModule;
import slimeknights.tconstruct.smeltery.client.inventory.module.GuiTankModule;
import slimeknights.tconstruct.smeltery.inventory.MelterContainer;
import slimeknights.tconstruct.smeltery.tileentity.controller.MelterTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.module.FuelModule;

public class MelterScreen
extends ContainerScreen<MelterContainer>
implements IScreenWithFluidTank {
    private static final ResourceLocation BACKGROUND = TConstruct.getResource("textures/gui/melter.png");
    private static final ElementScreen SCALA = new ElementScreen(176, 0, 52, 52, 256, 256);
    private static final ElementScreen FUEL_SLOT = new ElementScreen(176, 52, 18, 36, 256, 256);
    private static final ElementScreen FUEL_TANK = new ElementScreen(194, 52, 14, 38, 256, 256);
    private final GuiMeltingModule melting;
    private final GuiFuelModule fuel;
    private final GuiTankModule tank;

    public MelterScreen(MelterContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        MelterTileEntity te = (MelterTileEntity)container.getTile();
        if (te != null) {
            FuelModule fuelModule = te.getFuelModule();
            this.melting = new GuiMeltingModule(this, te.getMeltingInventory(), fuelModule::getTemperature, slot -> true);
            this.fuel = new GuiFuelModule(this, fuelModule, 153, 32, 12, 36, 152, 15, container.isHasFuelSlot());
            this.tank = new GuiTankModule(this, (IFluidHandler)te.getTank(), 90, 16, 52, 52);
        } else {
            this.melting = null;
            this.fuel = null;
            this.tank = null;
        }
    }

    public void func_230430_a_(MatrixStack matrices, int x, int y, float partialTicks) {
        this.func_230446_a_(matrices);
        super.func_230430_a_(matrices, x, y, partialTicks);
        this.func_230459_a_(matrices, x, y);
    }

    protected void func_230450_a_(MatrixStack matrices, float partialTicks, int mouseX, int mouseY) {
        GuiUtil.drawBackground(matrices, this, BACKGROUND);
        if (this.tank != null) {
            this.tank.draw(matrices);
        }
        if (this.fuel != null) {
            this.getMinecraft().func_110434_K().func_110577_a(BACKGROUND);
            if (((MelterContainer)this.field_147002_h).isHasFuelSlot()) {
                FUEL_SLOT.draw(matrices, this.field_147003_i + 150, this.field_147009_r + 31);
            } else {
                FUEL_TANK.draw(matrices, this.field_147003_i + 152, this.field_147009_r + 31);
            }
            this.fuel.draw(matrices);
        }
    }

    protected void func_230451_b_(MatrixStack matrices, int mouseX, int mouseY) {
        GuiUtil.drawContainerNames(matrices, this, this.field_230712_o_, this.field_213127_e);
        int checkX = mouseX - this.field_147003_i;
        int checkY = mouseY - this.field_147009_r;
        if (this.tank != null) {
            this.tank.highlightHoveredFluid(matrices, checkX, checkY);
        }
        if (this.fuel != null) {
            this.fuel.renderHighlight(matrices, checkX, checkY);
        }
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        SCALA.draw(matrices, 90, 16);
        if (this.melting != null) {
            this.melting.drawHeatBars(matrices);
        }
    }

    protected void func_230459_a_(MatrixStack matrices, int mouseX, int mouseY) {
        super.func_230459_a_(matrices, mouseX, mouseY);
        if (this.tank != null) {
            this.tank.renderTooltip(matrices, mouseX, mouseY);
        }
        if (this.melting != null) {
            this.melting.drawHeatTooltips(matrices, mouseX, mouseY);
        }
        if (this.fuel != null) {
            this.fuel.addTooltip(matrices, mouseX, mouseY, true);
        }
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(double mouseX, double mouseY) {
        FluidStack ingredient = null;
        int checkX = (int)mouseX - this.field_147003_i;
        int checkY = (int)mouseY - this.field_147009_r;
        if (this.fuel != null) {
            ingredient = this.fuel.getIngredient(checkX, checkY);
        }
        if (this.tank != null && ingredient == null) {
            ingredient = this.tank.getIngreientUnderMouse(checkX, checkY);
        }
        return ingredient;
    }
}

