/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.inventory;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.client.inventory.IScreenWithFluidTank;
import slimeknights.tconstruct.smeltery.client.inventory.module.GuiFuelModule;
import slimeknights.tconstruct.smeltery.client.inventory.module.GuiTankModule;
import slimeknights.tconstruct.smeltery.inventory.AlloyerContainer;
import slimeknights.tconstruct.smeltery.tileentity.controller.AlloyerTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.module.FuelModule;
import slimeknights.tconstruct.smeltery.tileentity.module.alloying.MixerAlloyTank;

public class AlloyerScreen
extends ContainerScreen<AlloyerContainer>
implements IScreenWithFluidTank {
    private static final int[] INPUT_TANK_START_X = new int[]{54, 22, 38, 70, 6};
    private static final ResourceLocation BACKGROUND = TConstruct.getResource("textures/gui/alloyer.png");
    private static final ElementScreen SCALA = new ElementScreen(176, 0, 34, 52, 256, 256);
    private static final ElementScreen FUEL_SLOT = new ElementScreen(176, 52, 18, 36, 256, 256);
    private static final ElementScreen FUEL_TANK = new ElementScreen(194, 52, 14, 38, 256, 256);
    private static final ElementScreen INPUT_TANK = new ElementScreen(208, 52, 16, 54, 256, 256);
    private final GuiFuelModule fuel;
    private final GuiTankModule outputTank;
    private GuiTankModule[] inputTanks = new GuiTankModule[0];

    public AlloyerScreen(AlloyerContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        AlloyerTileEntity te = (AlloyerTileEntity)container.getTile();
        if (te != null) {
            FuelModule fuelModule = te.getFuelModule();
            this.fuel = new GuiFuelModule(this, fuelModule, 153, 32, 12, 36, 152, 15, container.isHasFuelSlot());
            this.outputTank = new GuiTankModule(this, (IFluidHandler)te.getTank(), 114, 16, 34, 52);
            this.updateTanks();
        } else {
            this.fuel = null;
            this.outputTank = null;
        }
    }

    private void updateTanks() {
        AlloyerTileEntity te = (AlloyerTileEntity)((AlloyerContainer)this.field_147002_h).getTile();
        if (te != null) {
            MixerAlloyTank alloyTank = te.getAlloyTank();
            int numTanks = alloyTank.getTanks();
            GuiTankModule[] tanks = new GuiTankModule[numTanks];
            int max = Math.min(numTanks, 5);
            for (int i = 0; i < max; ++i) {
                tanks[i] = new GuiTankModule(this, alloyTank.getFluidHandler(i), INPUT_TANK_START_X[i], 16, 14, 52);
            }
            this.inputTanks = tanks;
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        AlloyerTileEntity te = (AlloyerTileEntity)((AlloyerContainer)this.field_147002_h).getTile();
        if (te != null && te.getAlloyTank().getTanks() != this.inputTanks.length) {
            this.updateTanks();
        }
    }

    public void func_230430_a_(MatrixStack matrices, int x, int y, float partialTicks) {
        this.func_230446_a_(matrices);
        super.func_230430_a_(matrices, x, y, partialTicks);
        this.func_230459_a_(matrices, x, y);
    }

    protected void func_230450_a_(MatrixStack matrices, float partialTicks, int mouseX, int mouseY) {
        GuiUtil.drawBackground(matrices, this, BACKGROUND);
        if (this.outputTank != null) {
            this.outputTank.draw(matrices);
        }
        this.getMinecraft().func_110434_K().func_110577_a(BACKGROUND);
        for (GuiTankModule tankModule : this.inputTanks) {
            INPUT_TANK.draw(matrices, tankModule.getX() - 1 + this.field_147003_i, tankModule.getY() - 1 + this.field_147009_r);
        }
        for (GuiTankModule tankModule : this.inputTanks) {
            tankModule.draw(matrices);
        }
        if (this.fuel != null) {
            this.getMinecraft().func_110434_K().func_110577_a(BACKGROUND);
            if (((AlloyerContainer)this.field_147002_h).isHasFuelSlot()) {
                FUEL_SLOT.draw(matrices, this.field_147003_i + 150, this.field_147009_r + 31);
            } else {
                FUEL_TANK.draw(matrices, this.field_147003_i + 152, this.field_147009_r + 31);
            }
            this.fuel.draw(matrices);
        }
    }

    protected void func_230451_b_(MatrixStack matrices, int mouseX, int mouseY) {
        GuiUtil.drawContainerNames(matrices, this, this.field_230712_o_, this.field_213127_e);
        int checkX = mouseX - this.field_147003_i;
        int checkY = mouseY - this.field_147009_r;
        if (this.outputTank != null) {
            this.outputTank.highlightHoveredFluid(matrices, checkX, checkY);
        }
        for (GuiTankModule tankModule : this.inputTanks) {
            tankModule.highlightHoveredFluid(matrices, checkX, checkY);
        }
        if (this.fuel != null) {
            this.fuel.renderHighlight(matrices, checkX, checkY);
        }
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        SCALA.draw(matrices, 114, 16);
    }

    protected void func_230459_a_(MatrixStack matrices, int mouseX, int mouseY) {
        super.func_230459_a_(matrices, mouseX, mouseY);
        if (this.outputTank != null) {
            this.outputTank.renderTooltip(matrices, mouseX, mouseY);
        }
        for (GuiTankModule tankModule : this.inputTanks) {
            tankModule.renderTooltip(matrices, mouseX, mouseY);
        }
        if (this.fuel != null) {
            this.fuel.addTooltip(matrices, mouseX, mouseY, true);
        }
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(double mouseX, double mouseY) {
        FluidStack ingredient = null;
        int checkX = (int)mouseX - this.field_147003_i;
        int checkY = (int)mouseY - this.field_147009_r;
        if (this.fuel != null) {
            ingredient = this.fuel.getIngredient(checkX, checkY);
        }
        if (this.outputTank != null && ingredient == null) {
            ingredient = this.outputTank.getIngreientUnderMouse(checkX, checkY);
        }
        if (ingredient == null) {
            for (GuiTankModule tankModule : this.inputTanks) {
                ingredient = tankModule.getIngreientUnderMouse(checkX, checkY);
                if (ingredient == null) continue;
                return ingredient;
            }
        }
        return ingredient;
    }
}

