/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery;

import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.FenceBuildingBlockObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;
import slimeknights.mantle.util.SupplierItemGroup;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.container.ContainerFillingRecipe;
import slimeknights.tconstruct.library.recipe.casting.container.ContainerFillingRecipeSerializer;
import slimeknights.tconstruct.library.recipe.casting.material.CompositeCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.melting.DamageableMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MaterialMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.OreMeltingRecipe;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipe;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.block.ClearGlassPaneBlock;
import slimeknights.tconstruct.smeltery.block.CastingBasinBlock;
import slimeknights.tconstruct.smeltery.block.CastingTableBlock;
import slimeknights.tconstruct.smeltery.block.ChannelBlock;
import slimeknights.tconstruct.smeltery.block.FaucetBlock;
import slimeknights.tconstruct.smeltery.block.SearedLanternBlock;
import slimeknights.tconstruct.smeltery.block.component.OrientableSmelteryBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedDrainBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedDuctBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedGlassBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedLadderBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedPillarBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.block.controller.AlloyerBlock;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.controller.FoundryControllerBlock;
import slimeknights.tconstruct.smeltery.block.controller.HeaterBlock;
import slimeknights.tconstruct.smeltery.block.controller.MelterBlock;
import slimeknights.tconstruct.smeltery.block.controller.SmelteryControllerBlock;
import slimeknights.tconstruct.smeltery.data.SmelteryRecipeProvider;
import slimeknights.tconstruct.smeltery.inventory.AlloyerContainer;
import slimeknights.tconstruct.smeltery.inventory.HeatingStructureContainer;
import slimeknights.tconstruct.smeltery.inventory.MelterContainer;
import slimeknights.tconstruct.smeltery.inventory.SingleItemContainer;
import slimeknights.tconstruct.smeltery.item.CopperCanItem;
import slimeknights.tconstruct.smeltery.item.TankItem;
import slimeknights.tconstruct.smeltery.tileentity.CastingTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.ChannelTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.FaucetTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.HeaterTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.LanternTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.component.DrainTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.component.DuctTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.component.SmelteryComponentTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.component.SmelteryInputOutputTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.component.TankTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.controller.AlloyerTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.controller.FoundryTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.controller.MelterTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.controller.SmelteryTileEntity;

public final class TinkerSmeltery
extends TinkerModule {
    public static final ItemGroup TAB_SMELTERY = new SupplierItemGroup("tconstruct", "smeltery", () -> new ItemStack(smelteryController));
    public static final Logger log = Util.getLogger("tinker_smeltery");
    private static final Item.Properties SMELTERY_PROPS = new Item.Properties().func_200916_a(TAB_SMELTERY);
    private static final Function<Block, ? extends BlockItem> TOOLTIP_BLOCK_ITEM = b -> new BlockTooltipItem(b, SMELTERY_PROPS);
    public static final ItemObject<Block> grout = BLOCKS.register("grout", TinkerSmeltery.builder(Material.field_151595_p, MaterialColor.field_197656_x, ToolType.SHOVEL, SoundType.field_185855_h).func_200943_b(3.0f).func_200941_a(0.8f), TOOLTIP_BLOCK_ITEM);
    public static final ItemObject<Block> netherGrout = BLOCKS.register("nether_grout", TinkerSmeltery.builder(Material.field_151595_p, ToolType.SHOVEL, SoundType.field_235586_H_).func_200943_b(3.0f).func_200941_a(0.8f), TOOLTIP_BLOCK_ITEM);
    private static final AbstractBlock.Properties SEARED;
    private static final AbstractBlock.Properties TOUGH_SEARED;
    private static final AbstractBlock.Properties SEARED_GLASS;
    private static final AbstractBlock.Properties SEARED_NON_SOLID;
    private static final AbstractBlock.Properties SEARED_LANTERN;
    public static final BuildingBlockObject searedStone;
    public static final BuildingBlockObject searedPaver;
    public static final WallBuildingBlockObject searedCobble;
    public static final WallBuildingBlockObject searedBricks;
    public static final ItemObject<Block> searedCrackedBricks;
    public static final ItemObject<Block> searedFancyBricks;
    public static final ItemObject<Block> searedTriangleBricks;
    public static final ItemObject<SearedLadderBlock> searedLadder;
    public static final ItemObject<SearedGlassBlock> searedGlass;
    public static final ItemObject<ClearGlassPaneBlock> searedGlassPane;
    public static final ItemObject<Block> searedDrain;
    public static final ItemObject<Block> searedDuct;
    public static final ItemObject<Block> searedChute;
    private static final AbstractBlock.Properties SCORCHED;
    private static final AbstractBlock.Properties TOUGH_SCORCHED;
    private static final AbstractBlock.Properties SCORCHED_GLASS;
    private static final AbstractBlock.Properties SCORCHED_NON_SOLID;
    private static final AbstractBlock.Properties SCORCHED_LANTERN;
    public static final ItemObject<Block> scorchedStone;
    public static final ItemObject<Block> polishedScorchedStone;
    public static final ItemObject<Block> chiseledScorchedBricks;
    public static final FenceBuildingBlockObject scorchedBricks;
    public static final BuildingBlockObject scorchedRoad;
    public static final ItemObject<SearedLadderBlock> scorchedLadder;
    public static final ItemObject<SearedGlassBlock> scorchedGlass;
    public static final ItemObject<ClearGlassPaneBlock> scorchedGlassPane;
    public static final ItemObject<Block> scorchedDrain;
    public static final ItemObject<Block> scorchedDuct;
    public static final ItemObject<Block> scorchedChute;
    public static final EnumObject<SearedTankBlock.TankType, SearedTankBlock> searedTank;
    public static final ItemObject<SearedLanternBlock> searedLantern;
    public static final ItemObject<FaucetBlock> searedFaucet;
    public static final ItemObject<ChannelBlock> searedChannel;
    public static final ItemObject<CastingBasinBlock> searedBasin;
    public static final ItemObject<CastingTableBlock> searedTable;
    public static final EnumObject<SearedTankBlock.TankType, SearedTankBlock> scorchedTank;
    public static final ItemObject<SearedLanternBlock> scorchedLantern;
    public static final ItemObject<FaucetBlock> scorchedFaucet;
    public static final ItemObject<ChannelBlock> scorchedChannel;
    public static final ItemObject<CastingBasinBlock> scorchedBasin;
    public static final ItemObject<CastingTableBlock> scorchedTable;
    public static final ItemObject<SmelteryControllerBlock> smelteryController;
    public static final ItemObject<FoundryControllerBlock> foundryController;
    public static final ItemObject<MelterBlock> searedMelter;
    public static final ItemObject<HeaterBlock> searedHeater;
    public static final ItemObject<AlloyerBlock> scorchedAlloyer;
    public static final RegistryObject<TileEntityType<SmelteryComponentTileEntity>> smelteryComponent;
    public static final RegistryObject<TileEntityType<SmelteryInputOutputTileEntity.SmelteryFluidIO>> drain;
    public static final RegistryObject<TileEntityType<SmelteryInputOutputTileEntity.ChuteTileEntity>> chute;
    public static final RegistryObject<TileEntityType<DuctTileEntity>> duct;
    public static final RegistryObject<TileEntityType<TankTileEntity>> tank;
    public static final RegistryObject<TileEntityType<LanternTileEntity>> lantern;
    public static final RegistryObject<TileEntityType<MelterTileEntity>> melter;
    public static final RegistryObject<TileEntityType<SmelteryTileEntity>> smeltery;
    public static final RegistryObject<TileEntityType<FoundryTileEntity>> foundry;
    public static final RegistryObject<TileEntityType<HeaterTileEntity>> heater;
    public static final RegistryObject<TileEntityType<AlloyerTileEntity>> alloyer;
    public static final RegistryObject<TileEntityType<FaucetTileEntity>> faucet;
    public static final RegistryObject<TileEntityType<ChannelTileEntity>> channel;
    public static final RegistryObject<TileEntityType<CastingTileEntity>> basin;
    public static final RegistryObject<TileEntityType<CastingTileEntity>> table;
    public static final ItemObject<Item> searedBrick;
    public static final ItemObject<Item> scorchedBrick;
    public static final ItemObject<Item> copperCan;
    public static final CastItemObject blankCast;
    public static final CastItemObject ingotCast;
    public static final CastItemObject nuggetCast;
    public static final CastItemObject gemCast;
    public static final CastItemObject rodCast;
    public static final CastItemObject repairKitCast;
    public static final CastItemObject plateCast;
    public static final CastItemObject gearCast;
    public static final CastItemObject coinCast;
    public static final CastItemObject pickaxeHeadCast;
    public static final CastItemObject smallAxeHeadCast;
    public static final CastItemObject smallBladeCast;
    public static final CastItemObject hammerHeadCast;
    public static final CastItemObject broadBladeCast;
    public static final CastItemObject broadAxeHeadCast;
    public static final CastItemObject toolBindingCast;
    public static final CastItemObject largePlateCast;
    public static final CastItemObject toolHandleCast;
    public static final CastItemObject toughHandleCast;
    public static final RegistryObject<ItemCastingRecipe.Serializer<ItemCastingRecipe.Basin>> basinRecipeSerializer;
    public static final RegistryObject<ItemCastingRecipe.Serializer<ItemCastingRecipe.Table>> tableRecipeSerializer;
    public static final RegistryObject<ContainerFillingRecipeSerializer<ContainerFillingRecipe.Basin>> basinFillingRecipeSerializer;
    public static final RegistryObject<ContainerFillingRecipeSerializer<ContainerFillingRecipe.Table>> tableFillingRecipeSerializer;
    public static final RegistryObject<MaterialCastingRecipe.Serializer<MaterialCastingRecipe.Basin>> basinMaterialSerializer;
    public static final RegistryObject<MaterialCastingRecipe.Serializer<MaterialCastingRecipe.Table>> tableMaterialSerializer;
    public static final RegistryObject<CompositeCastingRecipe.Serializer<CompositeCastingRecipe.Basin>> basinCompositeSerializer;
    public static final RegistryObject<CompositeCastingRecipe.Serializer<CompositeCastingRecipe.Table>> tableCompositeSerializer;
    public static final RegistryObject<MaterialFluidRecipe.Serializer> materialFluidRecipe;
    public static final RegistryObject<MoldingRecipe.Serializer<MoldingRecipe.Table>> moldingTableSerializer;
    public static final RegistryObject<MoldingRecipe.Serializer<MoldingRecipe.Basin>> moldingBasinSerializer;
    public static final RegistryObject<IRecipeSerializer<MeltingRecipe>> meltingSerializer;
    public static final RegistryObject<IRecipeSerializer<MeltingRecipe>> oreMeltingSerializer;
    public static final RegistryObject<IRecipeSerializer<MeltingRecipe>> damagableMeltingSerializer;
    public static final RegistryObject<IRecipeSerializer<MaterialMeltingRecipe>> materialMeltingSerializer;
    public static final RegistryObject<IRecipeSerializer<MeltingFuel>> fuelSerializer;
    public static final RegistryObject<IRecipeSerializer<EntityMeltingRecipe>> entityMeltingSerializer;
    public static final RegistryObject<IRecipeSerializer<AlloyRecipe>> alloyingSerializer;
    public static final RegistryObject<ContainerType<MelterContainer>> melterContainer;
    public static final RegistryObject<ContainerType<HeatingStructureContainer>> smelteryContainer;
    public static final RegistryObject<ContainerType<SingleItemContainer>> singleItemContainer;
    public static final RegistryObject<ContainerType<AlloyerContainer>> alloyerContainer;

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        if (event.includeServer()) {
            DataGenerator datagenerator = event.getGenerator();
            datagenerator.func_200390_a((IDataProvider)new SmelteryRecipeProvider(datagenerator));
        }
    }

    static {
        IntFunction<AbstractBlock.Properties> solidProps = factor -> TinkerSmeltery.builder(Material.field_151576_e, MaterialColor.field_151670_w, ToolType.PICKAXE, SoundType.field_185852_e).func_235861_h_().func_200948_a(3.0f * (float)factor, 9.0f * (float)factor).func_235827_a_((s, r, p, e) -> !s.func_235901_b_((Property)SearedBlock.IN_STRUCTURE) || (Boolean)s.func_177229_b((Property)SearedBlock.IN_STRUCTURE) == false);
        SEARED = solidProps.apply(1);
        TOUGH_SEARED = solidProps.apply(2);
        Function<SoundType, AbstractBlock.Properties> nonSolidProps = sound -> TinkerSmeltery.builder(Material.field_151576_e, MaterialColor.field_151670_w, ToolType.PICKAXE, sound).func_235861_h_().func_200948_a(3.0f, 9.0f).func_226896_b_().func_235827_a_(Blocks::func_235427_a_).func_235828_a_(Blocks::func_235436_b_).func_235842_b_(Blocks::func_235436_b_).func_235847_c_(Blocks::func_235436_b_);
        SEARED_GLASS = nonSolidProps.apply(SoundType.field_185853_f);
        SEARED_NON_SOLID = nonSolidProps.apply(SoundType.field_185852_e);
        SEARED_LANTERN = nonSolidProps.apply(SoundType.field_222475_v);
        Supplier<SearedBlock> searedBlock = () -> new SearedBlock(SEARED);
        searedStone = BLOCKS.registerBuilding("seared_stone", searedBlock, TOOLTIP_BLOCK_ITEM);
        searedCobble = BLOCKS.registerWallBuilding("seared_cobble", searedBlock, TOOLTIP_BLOCK_ITEM);
        searedPaver = BLOCKS.registerBuilding("seared_paver", searedBlock, TOOLTIP_BLOCK_ITEM);
        searedBricks = BLOCKS.registerWallBuilding("seared_bricks", searedBlock, TOOLTIP_BLOCK_ITEM);
        searedCrackedBricks = BLOCKS.register("seared_cracked_bricks", searedBlock, TOOLTIP_BLOCK_ITEM);
        searedFancyBricks = BLOCKS.register("seared_fancy_bricks", searedBlock, TOOLTIP_BLOCK_ITEM);
        searedTriangleBricks = BLOCKS.register("seared_triangle_bricks", searedBlock, TOOLTIP_BLOCK_ITEM);
        searedLadder = BLOCKS.register("seared_ladder", () -> new SearedLadderBlock(SEARED_NON_SOLID), TOOLTIP_BLOCK_ITEM);
        searedGlass = BLOCKS.register("seared_glass", () -> new SearedGlassBlock(SEARED_GLASS), TOOLTIP_BLOCK_ITEM);
        searedGlassPane = BLOCKS.register("seared_glass_pane", () -> new ClearGlassPaneBlock(SEARED_GLASS), TOOLTIP_BLOCK_ITEM);
        searedDrain = BLOCKS.register("seared_drain", () -> new SearedDrainBlock(TOUGH_SEARED), TOOLTIP_BLOCK_ITEM);
        searedDuct = BLOCKS.register("seared_duct", () -> new SearedDuctBlock(TOUGH_SEARED), TOOLTIP_BLOCK_ITEM);
        searedChute = BLOCKS.register("seared_chute", () -> new OrientableSmelteryBlock(TOUGH_SEARED, SmelteryInputOutputTileEntity.ChuteTileEntity::new), TOOLTIP_BLOCK_ITEM);
        solidProps = factor -> TinkerSmeltery.builder(Material.field_151576_e, MaterialColor.field_193573_Y, ToolType.PICKAXE, SoundType.field_235587_I_).func_235861_h_().func_200948_a(2.5f * (float)factor, 8.0f * (float)factor).func_235827_a_((s, r, p, e) -> !s.func_235901_b_((Property)SearedBlock.IN_STRUCTURE) || (Boolean)s.func_177229_b((Property)SearedBlock.IN_STRUCTURE) == false);
        SCORCHED = solidProps.apply(1);
        TOUGH_SCORCHED = solidProps.apply(3);
        nonSolidProps = sound -> TinkerSmeltery.builder(Material.field_151576_e, MaterialColor.field_193573_Y, ToolType.PICKAXE, sound).func_235861_h_().func_200948_a(2.5f, 8.0f).func_226896_b_().func_235827_a_(Blocks::func_235427_a_).func_235828_a_(Blocks::func_235436_b_).func_235842_b_(Blocks::func_235436_b_).func_235847_c_(Blocks::func_235436_b_);
        SCORCHED_GLASS = nonSolidProps.apply(SoundType.field_185853_f);
        SCORCHED_NON_SOLID = nonSolidProps.apply(SoundType.field_235587_I_);
        SCORCHED_LANTERN = nonSolidProps.apply(SoundType.field_222475_v);
        Supplier<SearedPillarBlock> pillar = () -> new SearedPillarBlock(SCORCHED);
        scorchedStone = BLOCKS.register("scorched_stone", pillar, TOOLTIP_BLOCK_ITEM);
        polishedScorchedStone = BLOCKS.register("polished_scorched_stone", pillar, TOOLTIP_BLOCK_ITEM);
        Supplier<SearedBlock> block = () -> new SearedBlock(SCORCHED);
        scorchedBricks = BLOCKS.registerFenceBuilding("scorched_bricks", block, TOOLTIP_BLOCK_ITEM);
        scorchedRoad = BLOCKS.registerBuilding("scorched_road", block, TOOLTIP_BLOCK_ITEM);
        chiseledScorchedBricks = BLOCKS.register("chiseled_scorched_bricks", block, TOOLTIP_BLOCK_ITEM);
        scorchedLadder = BLOCKS.register("scorched_ladder", () -> new SearedLadderBlock(SCORCHED_NON_SOLID), TOOLTIP_BLOCK_ITEM);
        scorchedGlass = BLOCKS.register("scorched_glass", () -> new SearedGlassBlock(SCORCHED_GLASS), TOOLTIP_BLOCK_ITEM);
        scorchedGlassPane = BLOCKS.register("scorched_glass_pane", () -> new ClearGlassPaneBlock(SCORCHED_GLASS), TOOLTIP_BLOCK_ITEM);
        scorchedDrain = BLOCKS.register("scorched_drain", () -> new SearedDrainBlock(TOUGH_SCORCHED), TOOLTIP_BLOCK_ITEM);
        scorchedDuct = BLOCKS.register("scorched_duct", () -> new SearedDuctBlock(TOUGH_SCORCHED), TOOLTIP_BLOCK_ITEM);
        scorchedChute = BLOCKS.register("scorched_chute", () -> new OrientableSmelteryBlock(TOUGH_SCORCHED, SmelteryInputOutputTileEntity.ChuteTileEntity::new), TOOLTIP_BLOCK_ITEM);
        searedTank = BLOCKS.registerEnum("seared", SearedTankBlock.TankType.values(), type -> new SearedTankBlock(SEARED_NON_SOLID, type.getCapacity()), b -> new TankItem((Block)b, SMELTERY_PROPS, true));
        searedLantern = BLOCKS.register("seared_lantern", () -> new SearedLanternBlock(SEARED_LANTERN, 100), b -> new TankItem((Block)b, SMELTERY_PROPS, false));
        searedFaucet = BLOCKS.register("seared_faucet", () -> new FaucetBlock(SEARED_NON_SOLID), TOOLTIP_BLOCK_ITEM);
        searedChannel = BLOCKS.register("seared_channel", () -> new ChannelBlock(SEARED_NON_SOLID), TOOLTIP_BLOCK_ITEM);
        searedBasin = BLOCKS.register("seared_basin", () -> new CastingBasinBlock(SEARED_NON_SOLID), TOOLTIP_BLOCK_ITEM);
        searedTable = BLOCKS.register("seared_table", () -> new CastingTableBlock(SEARED_NON_SOLID), TOOLTIP_BLOCK_ITEM);
        scorchedTank = BLOCKS.registerEnum("scorched", SearedTankBlock.TankType.values(), type -> new SearedTankBlock(SCORCHED_NON_SOLID, type.getCapacity()), b -> new TankItem((Block)b, SMELTERY_PROPS, true));
        scorchedLantern = BLOCKS.register("scorched_lantern", () -> new SearedLanternBlock(SCORCHED_LANTERN, 100), b -> new TankItem((Block)b, SMELTERY_PROPS, false));
        scorchedFaucet = BLOCKS.register("scorched_faucet", () -> new FaucetBlock(SCORCHED_NON_SOLID), TOOLTIP_BLOCK_ITEM);
        scorchedChannel = BLOCKS.register("scorched_channel", () -> new ChannelBlock(SCORCHED_NON_SOLID), TOOLTIP_BLOCK_ITEM);
        scorchedBasin = BLOCKS.register("scorched_basin", () -> new CastingBasinBlock(SCORCHED_NON_SOLID), TOOLTIP_BLOCK_ITEM);
        scorchedTable = BLOCKS.register("scorched_table", () -> new CastingTableBlock(SCORCHED_NON_SOLID), TOOLTIP_BLOCK_ITEM);
        Supplier<AbstractBlock.Properties> seared = () -> TinkerSmeltery.builder(Material.field_151576_e, MaterialColor.field_151670_w, ToolType.PICKAXE, SoundType.field_185852_e).func_235861_h_().func_200948_a(8.0f, 28.0f).func_235838_a_(s -> (Boolean)s.func_177229_b((Property)ControllerBlock.ACTIVE) != false ? 13 : 0);
        Supplier<AbstractBlock.Properties> scorched = () -> TinkerSmeltery.builder(Material.field_151576_e, MaterialColor.field_193573_Y, ToolType.PICKAXE, SoundType.field_235587_I_).func_235861_h_().func_200948_a(9.0f, 35.0f).func_235838_a_(s -> (Boolean)s.func_177229_b((Property)ControllerBlock.ACTIVE) != false ? 13 : 0);
        smelteryController = BLOCKS.register("smeltery_controller", () -> new SmelteryControllerBlock((AbstractBlock.Properties)seared.get()), TOOLTIP_BLOCK_ITEM);
        foundryController = BLOCKS.register("foundry_controller", () -> new FoundryControllerBlock((AbstractBlock.Properties)scorched.get()), TOOLTIP_BLOCK_ITEM);
        searedMelter = BLOCKS.register("seared_melter", () -> new MelterBlock(((AbstractBlock.Properties)seared.get()).func_226896_b_()), TOOLTIP_BLOCK_ITEM);
        searedHeater = BLOCKS.register("seared_heater", () -> new HeaterBlock((AbstractBlock.Properties)seared.get()), TOOLTIP_BLOCK_ITEM);
        scorchedAlloyer = BLOCKS.register("scorched_alloyer", () -> new AlloyerBlock(((AbstractBlock.Properties)scorched.get()).func_226896_b_()), TOOLTIP_BLOCK_ITEM);
        smelteryComponent = TILE_ENTITIES.register("smeltery_component", SmelteryComponentTileEntity::new, set -> {
            set.addAll((Iterable)searedStone.values());
            set.addAll((Iterable)searedCobble.values());
            set.addAll((Iterable)searedBricks.values());
            set.addAll((Iterable)searedPaver.values());
            set.add((Object[])new Block[]{(Block)searedCrackedBricks.get(), (Block)searedFancyBricks.get(), (Block)searedTriangleBricks.get(), (Block)searedLadder.get(), (Block)searedGlass.get()});
            set.add((Object[])new Block[]{(Block)scorchedStone.get(), (Block)polishedScorchedStone.get(), (Block)chiseledScorchedBricks.get(), (Block)scorchedLadder.get()});
            set.addAll((Iterable)scorchedBricks.values());
            set.addAll((Iterable)scorchedRoad.values());
        });
        drain = TILE_ENTITIES.register("drain", DrainTileEntity::new, set -> set.add((Object[])new Block[]{(Block)searedDrain.get(), (Block)scorchedDrain.get()}));
        chute = TILE_ENTITIES.register("chute", SmelteryInputOutputTileEntity.ChuteTileEntity::new, set -> set.add((Object[])new Block[]{(Block)searedChute.get(), (Block)scorchedChute.get()}));
        duct = TILE_ENTITIES.register("duct", DuctTileEntity::new, set -> set.add((Object[])new Block[]{(Block)searedDuct.get(), (Block)scorchedDuct.get()}));
        tank = TILE_ENTITIES.register("tank", TankTileEntity::new, set -> {
            set.addAll((Iterable)searedTank.values());
            set.addAll((Iterable)scorchedTank.values());
        });
        lantern = TILE_ENTITIES.register("lantern", LanternTileEntity::new, set -> set.add((Object[])new Block[]{(Block)searedLantern.get(), (Block)scorchedLantern.get()}));
        melter = TILE_ENTITIES.register("melter", MelterTileEntity::new, searedMelter);
        smeltery = TILE_ENTITIES.register("smeltery", SmelteryTileEntity::new, smelteryController);
        foundry = TILE_ENTITIES.register("foundry", FoundryTileEntity::new, foundryController);
        heater = TILE_ENTITIES.register("heater", HeaterTileEntity::new, searedHeater);
        alloyer = TILE_ENTITIES.register("alloyer", AlloyerTileEntity::new, scorchedAlloyer);
        faucet = TILE_ENTITIES.register("faucet", FaucetTileEntity::new, set -> set.add((Object[])new Block[]{(Block)searedFaucet.get(), (Block)scorchedFaucet.get()}));
        channel = TILE_ENTITIES.register("channel", ChannelTileEntity::new, set -> set.add((Object[])new Block[]{(Block)searedChannel.get(), (Block)scorchedChannel.get()}));
        basin = TILE_ENTITIES.register("basin", CastingTileEntity.Basin::new, set -> set.add((Object[])new Block[]{(Block)searedBasin.get(), (Block)scorchedBasin.get()}));
        table = TILE_ENTITIES.register("table", CastingTileEntity.Table::new, set -> set.add((Object[])new Block[]{(Block)searedTable.get(), (Block)scorchedTable.get()}));
        searedBrick = ITEMS.register("seared_brick", SMELTERY_PROPS);
        scorchedBrick = ITEMS.register("scorched_brick", SMELTERY_PROPS);
        copperCan = ITEMS.register("copper_can", () -> new CopperCanItem(new Item.Properties().func_200917_a(16).func_200916_a(TAB_SMELTERY)));
        blankCast = ITEMS.registerCast("blank", SMELTERY_PROPS);
        ingotCast = ITEMS.registerCast("ingot", SMELTERY_PROPS);
        nuggetCast = ITEMS.registerCast("nugget", SMELTERY_PROPS);
        gemCast = ITEMS.registerCast("gem", SMELTERY_PROPS);
        rodCast = ITEMS.registerCast("rod", SMELTERY_PROPS);
        repairKitCast = ITEMS.registerCast("repair_kit", SMELTERY_PROPS);
        plateCast = ITEMS.registerCast("plate", SMELTERY_PROPS);
        gearCast = ITEMS.registerCast("gear", SMELTERY_PROPS);
        coinCast = ITEMS.registerCast("coin", SMELTERY_PROPS);
        pickaxeHeadCast = ITEMS.registerCast("pickaxe_head", SMELTERY_PROPS);
        smallAxeHeadCast = ITEMS.registerCast("small_axe_head", SMELTERY_PROPS);
        smallBladeCast = ITEMS.registerCast("small_blade", SMELTERY_PROPS);
        hammerHeadCast = ITEMS.registerCast("hammer_head", SMELTERY_PROPS);
        broadBladeCast = ITEMS.registerCast("broad_blade", SMELTERY_PROPS);
        broadAxeHeadCast = ITEMS.registerCast("broad_axe_head", SMELTERY_PROPS);
        toolBindingCast = ITEMS.registerCast("tool_binding", SMELTERY_PROPS);
        largePlateCast = ITEMS.registerCast("large_plate", SMELTERY_PROPS);
        toolHandleCast = ITEMS.registerCast("tool_handle", SMELTERY_PROPS);
        toughHandleCast = ITEMS.registerCast("tough_handle", SMELTERY_PROPS);
        basinRecipeSerializer = RECIPE_SERIALIZERS.register("casting_basin", () -> new ItemCastingRecipe.Serializer<ItemCastingRecipe.Basin>(ItemCastingRecipe.Basin::new));
        tableRecipeSerializer = RECIPE_SERIALIZERS.register("casting_table", () -> new ItemCastingRecipe.Serializer<ItemCastingRecipe.Table>(ItemCastingRecipe.Table::new));
        basinFillingRecipeSerializer = RECIPE_SERIALIZERS.register("basin_filling", () -> new ContainerFillingRecipeSerializer<ContainerFillingRecipe.Basin>(ContainerFillingRecipe.Basin::new));
        tableFillingRecipeSerializer = RECIPE_SERIALIZERS.register("table_filling", () -> new ContainerFillingRecipeSerializer<ContainerFillingRecipe.Table>(ContainerFillingRecipe.Table::new));
        basinMaterialSerializer = RECIPE_SERIALIZERS.register("basin_casting_material", () -> new MaterialCastingRecipe.Serializer<MaterialCastingRecipe.Basin>(MaterialCastingRecipe.Basin::new));
        tableMaterialSerializer = RECIPE_SERIALIZERS.register("table_casting_material", () -> new MaterialCastingRecipe.Serializer<MaterialCastingRecipe.Table>(MaterialCastingRecipe.Table::new));
        basinCompositeSerializer = RECIPE_SERIALIZERS.register("basin_casting_composite", () -> new CompositeCastingRecipe.Serializer<CompositeCastingRecipe.Basin>(CompositeCastingRecipe.Basin::new));
        tableCompositeSerializer = RECIPE_SERIALIZERS.register("table_casting_composite", () -> new CompositeCastingRecipe.Serializer<CompositeCastingRecipe.Table>(CompositeCastingRecipe.Table::new));
        materialFluidRecipe = RECIPE_SERIALIZERS.register("material_fluid", MaterialFluidRecipe.Serializer::new);
        moldingTableSerializer = RECIPE_SERIALIZERS.register("molding_table", () -> new MoldingRecipe.Serializer<MoldingRecipe.Table>(MoldingRecipe.Table::new));
        moldingBasinSerializer = RECIPE_SERIALIZERS.register("molding_basin", () -> new MoldingRecipe.Serializer<MoldingRecipe.Basin>(MoldingRecipe.Basin::new));
        meltingSerializer = RECIPE_SERIALIZERS.register("melting", () -> new MeltingRecipe.Serializer<MeltingRecipe>(MeltingRecipe::new));
        oreMeltingSerializer = RECIPE_SERIALIZERS.register("ore_melting", () -> new MeltingRecipe.Serializer<MeltingRecipe>(OreMeltingRecipe::new));
        damagableMeltingSerializer = RECIPE_SERIALIZERS.register("damagable_melting", () -> new MeltingRecipe.Serializer<MeltingRecipe>(DamageableMeltingRecipe::new));
        materialMeltingSerializer = RECIPE_SERIALIZERS.register("material_melting", MaterialMeltingRecipe.Serializer::new);
        fuelSerializer = RECIPE_SERIALIZERS.register("melting_fuel", MeltingFuel.Serializer::new);
        entityMeltingSerializer = RECIPE_SERIALIZERS.register("entity_melting", EntityMeltingRecipe.Serializer::new);
        alloyingSerializer = RECIPE_SERIALIZERS.register("alloy", AlloyRecipe.Serializer::new);
        melterContainer = CONTAINERS.register("melter", MelterContainer::new);
        smelteryContainer = CONTAINERS.register("smeltery", HeatingStructureContainer::new);
        singleItemContainer = CONTAINERS.register("single_item", SingleItemContainer::new);
        alloyerContainer = CONTAINERS.register("alloyer", AlloyerContainer::new);
    }
}

