/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.tileentity;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import slimeknights.mantle.tileentity.InventoryTileEntity;
import slimeknights.tconstruct.common.SoundUtils;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.network.InventorySlotSyncPacket;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.tables.inventory.BaseStationContainer;
import slimeknights.tconstruct.tables.network.UpdateStationScreenPacket;

public abstract class TableTileEntity
extends InventoryTileEntity {
    public TableTileEntity(TileEntityType<?> tileEntityTypeIn, String name, int inventorySize) {
        super(tileEntityTypeIn, (ITextComponent)new TranslationTextComponent(name), inventorySize);
    }

    public TableTileEntity(TileEntityType<?> tileEntityTypeIn, String name, int inventorySize, int maxStackSize) {
        super(tileEntityTypeIn, (ITextComponent)new TranslationTextComponent(name), inventorySize, maxStackSize);
    }

    public void func_70299_a(int slot, @Nonnull ItemStack itemstack) {
        if (this.field_145850_b != null && this.field_145850_b instanceof ServerWorld && !this.field_145850_b.field_72995_K && !ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)this.func_70301_a(slot))) {
            TinkerNetwork.getInstance().sendToClientsAround(new InventorySlotSyncPacket(itemstack, slot, this.field_174879_c), (ServerWorld)this.field_145850_b, this.field_174879_c);
        }
        super.func_70299_a(slot, itemstack);
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        this.writeInventoryToNBT(nbt);
        return nbt;
    }

    public void syncToRelevantPlayers(Consumer<PlayerEntity> action) {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.field_145850_b.func_217369_A().stream().filter(player -> {
            if (player.field_71070_bA instanceof BaseStationContainer) {
                return ((BaseStationContainer)player.field_71070_bA).getTile() == this;
            }
            return false;
        }).forEach(action);
    }

    protected void playCraftSound(PlayerEntity player) {
        SoundUtils.playSoundForAll((Entity)player, Sounds.SAW.getSound(), 0.8f, 0.8f + 0.4f * player.func_130014_f_().field_73012_v.nextFloat());
    }

    protected void syncScreen(PlayerEntity player) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && player instanceof ServerPlayerEntity) {
            TinkerNetwork.getInstance().sendTo(new UpdateStationScreenPacket(), (ServerPlayerEntity)player);
        }
    }
}

