/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;

public class ModDataNBT
implements IModDataReadOnly {
    private final CompoundNBT data;

    public ModDataNBT() {
        this(new CompoundNBT());
    }

    @Override
    public int getSlots(SlotType type) {
        return this.data.func_74762_e(type.getName());
    }

    public void setSlots(SlotType type, int value) {
        this.data.func_74768_a(type.getName(), value);
    }

    public void addSlots(SlotType type, int add) {
        if (add != 0) {
            this.setSlots(type, this.getSlots(type) + add);
        }
    }

    @Override
    public <T> T get(ResourceLocation name, BiFunction<CompoundNBT, String, T> function) {
        return function.apply(this.data, name.toString());
    }

    @Override
    public boolean contains(ResourceLocation name, int type) {
        return this.data.func_150297_b(name.toString(), type);
    }

    public void put(ResourceLocation name, INBT nbt) {
        this.data.func_218657_a(name.toString(), nbt);
    }

    public void putInt(ResourceLocation name, int value) {
        this.data.func_74768_a(name.toString(), value);
    }

    public void putBoolean(ResourceLocation name, boolean value) {
        this.data.func_74757_a(name.toString(), value);
    }

    public void putFloat(ResourceLocation name, float value) {
        this.data.func_74776_a(name.toString(), value);
    }

    public void putString(ResourceLocation name, String value) {
        this.data.func_74778_a(name.toString(), value);
    }

    public void remove(ResourceLocation name) {
        this.data.func_82580_o(name.toString());
    }

    public static ModDataNBT readFromNBT(CompoundNBT data) {
        return new ModDataNBT(data);
    }

    @Deprecated
    public void setUpgrades(int value) {
        this.setSlots(SlotType.UPGRADE, value);
    }

    @Deprecated
    public void addUpgrades(int add) {
        this.addSlots(SlotType.UPGRADE, add);
    }

    @Deprecated
    public void setAbilities(int value) {
        this.setSlots(SlotType.ABILITY, value);
    }

    @Deprecated
    public void addAbilities(int add) {
        this.addSlots(SlotType.ABILITY, add);
    }

    @Deprecated
    public void setTraits(int value) {
        this.setSlots(SlotType.SOUL, value);
    }

    @Deprecated
    public void addTraits(int add) {
        this.addSlots(SlotType.SOUL, add);
    }

    @Deprecated
    public int getTraits() {
        return this.getSlots(SlotType.SOUL);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModDataNBT)) {
            return false;
        }
        ModDataNBT other = (ModDataNBT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CompoundNBT this$data = this.getData();
        CompoundNBT other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModDataNBT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CompoundNBT $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    private ModDataNBT(CompoundNBT data) {
        this.data = data;
    }

    protected CompoundNBT getData() {
        return this.data;
    }
}

