/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IToolPart;

public final class ToolBuildHandler {
    private static final List<MaterialId> RENDER_MATERIALS = Arrays.asList(new MaterialId("tconstruct", "ui_render_head"), new MaterialId("tconstruct", "ui_render_handle"), new MaterialId("tconstruct", "ui_render_extra"), new MaterialId("tconstruct", "ui_render_large"), new MaterialId("tconstruct", "ui_render_extra_large"));

    private ToolBuildHandler() {
    }

    public static ItemStack buildItemFromMaterials(IModifiable tool, List<IMaterial> materials) {
        return ToolStack.createTool(tool.func_199767_j(), tool.getToolDefinition(), materials).createStack();
    }

    public static MaterialId getRenderMaterial(int index) {
        return RENDER_MATERIALS.get(index % RENDER_MATERIALS.size());
    }

    public static ItemStack buildToolForRendering(Item item, ToolDefinition definition) {
        ItemStack stack;
        List<IToolPart> requirements = definition.getRequiredComponents();
        int size = requirements.size();
        if (size == 0) {
            stack = new ItemStack((IItemProvider)item);
        } else {
            ArrayList<MaterialId> toolMaterials = new ArrayList<MaterialId>(size);
            for (int i = 0; i < size; ++i) {
                toolMaterials.add(i, ToolBuildHandler.getRenderMaterial(i));
            }
            stack = new MaterialIdNBT(toolMaterials).updateStack(new ItemStack((IItemProvider)item));
        }
        stack.func_196082_o().func_74757_a("tic_display", true);
        return stack;
    }

    public static void addDefaultSubItems(IModifiable item, List<ItemStack> itemList, IMaterial ... fixedMaterials) {
        block4: {
            IMaterial material2;
            MaterialId materialId;
            block3: {
                if (item.getToolDefinition().isMultipart()) break block3;
                itemList.add(ToolBuildHandler.buildItemFromMaterials(item, Collections.emptyList()));
                break block4;
            }
            if (!MaterialRegistry.isFullyLoaded()) break block4;
            String showOnlyId = (String)Config.COMMON.showOnlyToolMaterial.get();
            boolean added = false;
            if (!showOnlyId.isEmpty() && (materialId = MaterialId.tryCreate(showOnlyId)) != null && (material2 = MaterialRegistry.getMaterial(materialId)) != IMaterial.UNKNOWN && ToolBuildHandler.addSubItem(item, itemList, material2, fixedMaterials)) {
                added = true;
            }
            if (!added) {
                for (IMaterial material2 : MaterialRegistry.getInstance().getVisibleMaterials()) {
                    if (ToolBuildHandler.addSubItem(item, itemList, material2, fixedMaterials) && !showOnlyId.isEmpty()) break;
                }
            }
        }
    }

    private static boolean addSubItem(IModifiable item, List<ItemStack> items, IMaterial material, IMaterial[] fixedMaterials) {
        List<IToolPart> required = item.getToolDefinition().getRequiredComponents();
        ArrayList<IMaterial> materials = new ArrayList<IMaterial>(required.size());
        for (int i = 0; i < required.size(); ++i) {
            if (fixedMaterials.length > i && fixedMaterials[i] != null && required.get(i).canUseMaterial(fixedMaterials[i])) {
                materials.add(fixedMaterials[i]);
                continue;
            }
            if (required.get(i).canUseMaterial(material)) {
                materials.add(material);
                continue;
            }
            return false;
        }
        items.add(ToolBuildHandler.buildItemFromMaterials(item, materials));
        return true;
    }
}

