/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.DoubleSupplier;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import slimeknights.mantle.util.OffhandCooldownTracker;
import slimeknights.mantle.util.SingleKeyMultimap;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableWeapon;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class ToolAttackUtil {
    private static final UUID OFFHAND_DAMAGE_MODIFIER_UUID = UUID.fromString("fd666e50-d2cc-11eb-b8bc-0242ac130003");
    private static final float DEGREE_TO_RADIANS = (float)Math.PI / 180;
    private static final AttributeModifier ANTI_KNOCKBACK_MODIFIER = new AttributeModifier("tconstruct.anti_knockback", 1.0, AttributeModifier.Operation.ADDITION);
    public static final DoubleSupplier NO_COOLDOWN = () -> 1.0;

    public static DoubleSupplier getCooldownFunction(PlayerEntity player, Hand hand) {
        if (hand == Hand.OFF_HAND) {
            return () -> OffhandCooldownTracker.getCooldown((PlayerEntity)player);
        }
        return () -> player.func_184825_o(0.5f);
    }

    public static float getAttributeAttackDamage(IModifierToolStack tool, LivingEntity holder, Hand hand) {
        if (hand == Hand.OFF_HAND && !holder.field_70170_p.func_201670_d()) {
            SingleKeyMultimap mainModifiers = new SingleKeyMultimap((Object)Attributes.field_233823_f_, holder.func_184614_ca().func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233823_f_));
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            listBuilder.add((Object)new AttributeModifier(OFFHAND_DAMAGE_MODIFIER_UUID, "tconstruct.tool.offhand_attack_damage", (double)tool.getStats().getFloat(ToolStats.ATTACK_DAMAGE), AttributeModifier.Operation.ADDITION));
            BiConsumer<Attribute, AttributeModifier> attributeConsumer = (attribute, modifier) -> {
                if (attribute == Attributes.field_233823_f_) {
                    listBuilder.add(modifier);
                }
            };
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getModifier().addAttributes(tool, entry.getLevel(), EquipmentSlotType.MAINHAND, attributeConsumer);
            }
            SingleKeyMultimap offhandModifiers = new SingleKeyMultimap((Object)Attributes.field_233823_f_, (Collection)listBuilder.build());
            AttributeModifierManager modifiers = holder.func_233645_dx_();
            modifiers.func_233785_a_((Multimap)mainModifiers);
            modifiers.func_233793_b_((Multimap)offhandModifiers);
            float damage = (float)holder.func_233637_b_(Attributes.field_233823_f_);
            modifiers.func_233785_a_((Multimap)offhandModifiers);
            modifiers.func_233793_b_((Multimap)mainModifiers);
            return damage;
        }
        return (float)holder.func_233637_b_(Attributes.field_233823_f_);
    }

    public static boolean dealDefaultDamage(LivingEntity attacker, Entity target, float damage) {
        if (attacker instanceof PlayerEntity) {
            return target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)), damage);
        }
        return target.func_70097_a(DamageSource.func_76358_a((LivingEntity)attacker), damage);
    }

    public static boolean attackEntity(ItemStack stack, IModifiableWeapon weapon, PlayerEntity attacker, Entity targetEntity) {
        return ToolAttackUtil.attackEntity(weapon, ToolStack.from(stack), (LivingEntity)attacker, Hand.MAIN_HAND, targetEntity, ToolAttackUtil.getCooldownFunction(attacker, Hand.MAIN_HAND), false);
    }

    public static boolean attackEntity(IModifiableWeapon weapon, IModifierToolStack tool, LivingEntity attackerLiving, Hand hand, Entity targetEntity, DoubleSupplier cooldownFunction, boolean isExtraAttack) {
        boolean isMagic;
        SoundEvent sound;
        Entity parent;
        if (tool.isBroken()) {
            return false;
        }
        if (attackerLiving.field_70170_p.field_72995_K || !targetEntity.func_70075_an() || targetEntity.func_85031_j((Entity)attackerLiving)) {
            return true;
        }
        LivingEntity targetLiving = null;
        if (targetEntity instanceof LivingEntity) {
            targetLiving = (LivingEntity)targetEntity;
        } else if (targetEntity instanceof PartEntity && (parent = ((PartEntity)targetEntity).getParent()) instanceof LivingEntity) {
            targetLiving = (LivingEntity)parent;
        }
        PlayerEntity attackerPlayer = null;
        if (attackerLiving instanceof PlayerEntity) {
            attackerPlayer = (PlayerEntity)attackerLiving;
        }
        float damage = ToolAttackUtil.getAttributeAttackDamage(tool, attackerLiving, hand);
        float cooldown = (float)cooldownFunction.getAsDouble();
        boolean fullyCharged = cooldown > 0.9f;
        boolean isCritical = !isExtraAttack && fullyCharged && attackerLiving.field_70143_R > 0.0f && !attackerLiving.func_233570_aj_() && !attackerLiving.func_70617_f_() && !attackerLiving.func_70090_H() && !attackerLiving.func_70644_a(Effects.field_76440_q) && !attackerLiving.func_184218_aH() && targetLiving != null && !attackerLiving.func_70051_ag();
        ToolAttackContext context = new ToolAttackContext(attackerLiving, attackerPlayer, hand, targetEntity, targetLiving, isCritical, cooldown, isExtraAttack);
        float baseDamage = damage;
        List<ModifierEntry> modifiers = tool.getModifierList();
        for (ModifierEntry entry : modifiers) {
            damage = entry.getModifier().getEntityDamage(tool, entry.getLevel(), context, baseDamage, damage);
        }
        if (damage <= 0.0f) {
            return !isExtraAttack;
        }
        float knockback = (float)attackerLiving.func_233637_b_(Attributes.field_233824_g_);
        if (targetLiving != null) {
            knockback += 0.4f;
        }
        if (attackerLiving.func_70051_ag() && fullyCharged) {
            sound = SoundEvents.field_187721_dT;
            knockback += 0.5f;
        } else {
            sound = fullyCharged ? SoundEvents.field_187727_dV : SoundEvents.field_187733_dX;
        }
        if (!isExtraAttack) {
            float criticalModifier;
            float f = criticalModifier = isCritical ? 1.5f : 1.0f;
            if (attackerPlayer != null) {
                CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((PlayerEntity)attackerPlayer, (Entity)targetEntity, (boolean)isCritical, (float)(isCritical ? 1.5f : 1.0f));
                boolean bl = isCritical = hitResult != null;
                if (isCritical) {
                    criticalModifier = hitResult.getDamageModifier();
                }
            }
            if (isCritical) {
                damage *= criticalModifier;
            }
        }
        boolean bl = isMagic = damage > baseDamage;
        if (cooldown < 1.0f) {
            damage *= 0.2f + cooldown * cooldown * 0.8f;
        }
        Vector3d originalTargetMotion = targetEntity.func_213322_ci();
        float oldHealth = 0.0f;
        if (targetLiving != null) {
            oldHealth = targetLiving.func_110143_aJ();
        }
        float baseKnockback = knockback;
        for (ModifierEntry entry : modifiers) {
            knockback = entry.getModifier().beforeEntityHit(tool, entry.getLevel(), context, damage, baseKnockback, knockback);
        }
        ModifierLootingHandler.setLootingHand(attackerLiving, hand);
        Optional<ModifiableAttributeInstance> knockbackModifier = ToolAttackUtil.getKnockbackAttribute(targetLiving);
        boolean canceledKnockback = false;
        if (knockback < 0.4f) {
            canceledKnockback = true;
            knockbackModifier.ifPresent(ToolAttackUtil::disableKnockback);
        } else if (targetLiving != null) {
            knockback -= 0.4f;
        }
        boolean didHit = isExtraAttack ? ToolAttackUtil.dealDefaultDamage(attackerLiving, targetEntity, damage) : weapon.dealDamage(tool, context, damage);
        ModifierLootingHandler.setLootingHand(attackerLiving, Hand.MAIN_HAND);
        if (canceledKnockback) {
            knockbackModifier.ifPresent(ToolAttackUtil::enableKnockback);
        }
        if (!didHit) {
            if (!isExtraAttack) {
                attackerLiving.field_70170_p.func_184148_a(null, attackerLiving.func_226277_ct_(), attackerLiving.func_226278_cu_(), attackerLiving.func_226281_cx_(), SoundEvents.field_187724_dU, attackerLiving.func_184176_by(), 1.0f, 1.0f);
            }
            for (ModifierEntry entry : modifiers) {
                entry.getModifier().failedEntityHit(tool, entry.getLevel(), context);
            }
            return !isExtraAttack;
        }
        float damageDealt = damage;
        if (targetLiving != null) {
            damageDealt = oldHealth - targetLiving.func_110143_aJ();
        }
        if (knockback > 0.0f) {
            if (targetLiving != null) {
                targetLiving.func_233627_a_(knockback, (double)MathHelper.func_76126_a((float)(attackerLiving.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(attackerLiving.field_70177_z * ((float)Math.PI / 180)))));
            } else {
                targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(attackerLiving.field_70177_z * ((float)Math.PI / 180))) * knockback), 0.1, (double)(MathHelper.func_76134_b((float)(attackerLiving.field_70177_z * ((float)Math.PI / 180))) * knockback));
            }
            attackerLiving.func_213317_d(attackerLiving.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            attackerLiving.func_70031_b(false);
        }
        if (targetEntity.field_70133_I && targetEntity instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)targetEntity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(targetEntity));
            targetEntity.field_70133_I = false;
            targetEntity.func_213317_d(originalTargetMotion);
        }
        if (attackerPlayer != null) {
            if (isCritical) {
                sound = SoundEvents.field_187718_dS;
                attackerPlayer.func_71009_b(targetEntity);
            }
            if (isMagic) {
                attackerPlayer.func_71047_c(targetEntity);
            }
            if (sound != null) {
                attackerLiving.field_70170_p.func_184148_a(null, attackerLiving.func_226277_ct_(), attackerLiving.func_226278_cu_(), attackerLiving.func_226281_cx_(), sound, attackerLiving.func_184176_by(), 1.0f, 1.0f);
            }
        }
        if (attackerLiving.field_70170_p instanceof ServerWorld && damageDealt > 2.0f) {
            int particleCount = (int)(damageDealt * 0.5f);
            ((ServerWorld)attackerLiving.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, targetEntity.func_226277_ct_(), targetEntity.func_226283_e_(0.5), targetEntity.func_226281_cx_(), particleCount, 0.1, 0.0, 0.1, 0.2);
        }
        attackerLiving.func_130011_c(targetEntity);
        if (targetLiving != null) {
            EnchantmentHelper.func_151384_a((LivingEntity)targetLiving, (Entity)attackerLiving);
        }
        int durabilityLost = targetLiving != null ? 1 : 0;
        for (ModifierEntry entry : modifiers) {
            durabilityLost += entry.getModifier().afterEntityHit(tool, entry.getLevel(), context, damageDealt);
        }
        float speed = tool.getStats().getFloat(ToolStats.ATTACK_SPEED);
        int time = Math.round(20.0f / speed);
        if (time < targetEntity.field_70172_ad) {
            targetEntity.field_70172_ad = (targetEntity.field_70172_ad + time) / 2;
        }
        if (attackerPlayer != null) {
            if (targetLiving != null) {
                ItemStack held;
                if (!(attackerLiving.field_70170_p.field_72995_K || isExtraAttack || (held = attackerLiving.func_184586_b(hand)).func_190926_b())) {
                    held.func_77961_a(targetLiving, attackerPlayer);
                }
                attackerPlayer.func_195067_a(Stats.field_188111_y, Math.round(damageDealt * 10.0f));
            }
            attackerPlayer.func_71020_j(0.1f);
        }
        if (!TinkerTags.Items.MELEE_PRIMARY.func_230235_a_((Object)tool.getItem())) {
            durabilityLost *= 2;
        }
        ToolDamageUtil.damageAnimated(tool, durabilityLost, attackerLiving);
        return true;
    }

    public static boolean extraEntityAttack(IModifiableWeapon weapon, IModifierToolStack tool, LivingEntity attackerLiving, Hand hand, Entity targetEntity) {
        return ToolAttackUtil.attackEntity(weapon, tool, attackerLiving, hand, targetEntity, NO_COOLDOWN, true);
    }

    public static void spawnAttackParticle(IParticleData particleData, Entity entity, double height) {
        double xd = -MathHelper.func_76126_a((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI));
        double zd = MathHelper.func_76134_b((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI));
        double yd = -MathHelper.func_76126_a((float)(entity.field_70125_A / 180.0f * (float)Math.PI));
        xd *= 1.0;
        yd *= 1.0;
        zd *= 1.0;
        if (entity.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)entity.field_70170_p).func_195598_a(particleData, entity.func_226277_ct_() + xd, entity.func_226278_cu_() + (double)entity.func_213302_cg() * height, entity.func_226281_cx_() + zd, 0, xd, yd, zd, 1.0);
        }
    }

    private static Optional<ModifiableAttributeInstance> getKnockbackAttribute(@Nullable LivingEntity living) {
        return Optional.ofNullable(living).map(e -> e.func_110148_a(Attributes.field_233820_c_)).filter(attribute -> !attribute.func_180374_a(ANTI_KNOCKBACK_MODIFIER));
    }

    private static void disableKnockback(ModifiableAttributeInstance instance) {
        instance.func_233767_b_(ANTI_KNOCKBACK_MODIFIER);
    }

    private static void enableKnockback(ModifiableAttributeInstance instance) {
        instance.func_111124_b(ANTI_KNOCKBACK_MODIFIER);
    }

    public static boolean attackEntitySecondary(DamageSource source, float damage, Entity target, @Nullable LivingEntity living, boolean noKnockback) {
        float oldLastDamage;
        Optional<ModifiableAttributeInstance> knockbackResistance = ToolAttackUtil.getKnockbackAttribute(living);
        float f = oldLastDamage = living == null ? 0.0f : living.field_110153_bc;
        if (noKnockback) {
            knockbackResistance.ifPresent(ToolAttackUtil::disableKnockback);
        }
        target.field_70172_ad = 0;
        boolean hit = target.func_70097_a(source, damage);
        if (living != null) {
            living.field_110153_bc += oldLastDamage;
        }
        if (noKnockback) {
            knockbackResistance.ifPresent(ToolAttackUtil::enableKnockback);
        }
        return hit;
    }
}

