/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.spilling;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.FluidIngredient;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.inventory.IEmptyInventory;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.recipe.LoggingRecipeSerializer;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.SpillingRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffect;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SpillingRecipe
implements ICustomOutputRecipe<IEmptyInventory> {
    private final ResourceLocation id;
    private final FluidIngredient ingredient;
    private final List<ISpillingEffect> effects;

    public boolean matches(Fluid fluid) {
        return this.ingredient.test(fluid);
    }

    public FluidStack applyEffects(FluidStack fluid, int level, ToolAttackContext context) {
        int needed = this.ingredient.getAmount(fluid.getFluid());
        int maxFluid = level * needed;
        float scale = level;
        if (fluid.getAmount() < maxFluid) {
            scale = (float)fluid.getAmount() / (float)maxFluid;
        }
        for (ISpillingEffect effect : this.effects) {
            effect.applyEffects(fluid, scale, context);
        }
        fluid.shrink(maxFluid);
        return fluid;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerModifiers.spillingSerializer.get();
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeTypes.SPILLING;
    }

    @Deprecated
    public boolean matches(IEmptyInventory inv, World worldIn) {
        return false;
    }

    public SpillingRecipe(ResourceLocation id, FluidIngredient ingredient, List<ISpillingEffect> effects) {
        this.id = id;
        this.ingredient = ingredient;
        this.effects = effects;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<SpillingRecipe> {
        public SpillingRecipe read(ResourceLocation id, JsonObject json) {
            FluidIngredient ingredient = FluidIngredient.deserialize((JsonObject)json, (String)"fluid");
            List effects = JsonHelper.parseList((JsonObject)json, (String)"effects", SpillingRecipeLookup::deserializeEffect);
            return new SpillingRecipe(id, ingredient, effects);
        }

        @Override
        @Nullable
        protected SpillingRecipe readSafe(ResourceLocation id, PacketBuffer buffer) {
            FluidIngredient ingredient = FluidIngredient.read((PacketBuffer)buffer);
            ImmutableList.Builder effects = ImmutableList.builder();
            int max = buffer.func_150792_a();
            for (int i = 0; i < max; ++i) {
                effects.add((Object)SpillingRecipeLookup.readEffect(buffer));
            }
            return new SpillingRecipe(id, ingredient, (List<ISpillingEffect>)effects.build());
        }

        @Override
        protected void writeSafe(PacketBuffer buffer, SpillingRecipe recipe) {
            recipe.ingredient.write(buffer);
            buffer.func_150787_b(recipe.effects.size());
            for (ISpillingEffect effect : recipe.effects) {
                SpillingRecipeLookup.writeEffect(effect, buffer);
            }
        }
    }
}

