/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.fuel;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;

public class MeltingFuelLookup {
    private static final Map<Fluid, MeltingFuel> LOOKUP = new HashMap<Fluid, MeltingFuel>();
    private static final RecipeCacheInvalidator.DuelSidedListener LISTENER = RecipeCacheInvalidator.addDuelSidedListener(LOOKUP::clear);

    public static void addFuel(Fluid fluid, MeltingFuel fuel) {
        LISTENER.checkClear();
        LOOKUP.putIfAbsent(fluid, fuel);
    }

    public static boolean isFuel(Fluid fluid) {
        return LOOKUP.containsKey(fluid);
    }

    @Nullable
    public static MeltingFuel findFuel(Fluid fluid) {
        return LOOKUP.get(fluid);
    }

    private MeltingFuelLookup() {
    }
}

