/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import java.util.List;
import net.minecraft.util.text.ITextComponent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class IncrementalModifier
extends Modifier {
    public IncrementalModifier(int color) {
        super(color);
    }

    @Override
    public ITextComponent getDisplayName(IModifierToolStack tool, int level) {
        int amount;
        int neededPerLevel = ModifierRecipeLookup.getNeededPerLevel(this);
        ITextComponent name = this.getDisplayName(level);
        if (neededPerLevel > 0 && (amount = this.getAmount(tool)) < neededPerLevel) {
            return name.func_230532_e_().func_240702_b_(": " + amount + " / " + neededPerLevel);
        }
        return name;
    }

    @Override
    public void onRemoved(IModifierToolStack tool) {
        tool.getPersistentData().remove(this.getId());
    }

    public static int getAmount(IModDataReadOnly persistentData, Modifier modifier) {
        if (persistentData.contains(modifier.getId(), 99)) {
            return persistentData.getInt(modifier.getId());
        }
        return ModifierRecipeLookup.getNeededPerLevel(modifier);
    }

    public static int getAmount(IModifierToolStack tool, Modifier modifier) {
        return IncrementalModifier.getAmount(tool.getPersistentData(), modifier);
    }

    public int getAmount(IModDataReadOnly persistentData) {
        return IncrementalModifier.getAmount(persistentData, (Modifier)this);
    }

    public int getAmount(IModifierToolStack tool) {
        return IncrementalModifier.getAmount(tool, (Modifier)this);
    }

    public float getScaledLevel(IModDataReadOnly persistentData, int level) {
        int neededPerLevel = ModifierRecipeLookup.getNeededPerLevel(this);
        if (neededPerLevel > 0) {
            return (float)level + (float)(this.getAmount(persistentData) - neededPerLevel) / (float)neededPerLevel;
        }
        return level;
    }

    public float getScaledLevel(IModifierToolStack tool, int level) {
        return this.getScaledLevel(tool.getPersistentData(), level);
    }

    public static void setAmount(ModDataNBT persistentData, Modifier modifier, int amount) {
        persistentData.putInt(modifier.getId(), amount);
    }

    protected void addDamageTooltip(IModifierToolStack tool, int level, float levelAmount, List<ITextComponent> tooltip) {
        this.addDamageTooltip(tool, this.getScaledLevel(tool, level) * levelAmount, tooltip);
    }
}

