/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.recipe;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.recipe.data.ConsumerWrapperBuilder;

public interface IRecipeHelper {
    public String getModId();

    default public ResourceLocation modResource(String name) {
        return new ResourceLocation(this.getModId(), name);
    }

    default public String modPrefix(String id) {
        return this.getModId() + ":" + id;
    }

    default public ResourceLocation wrap(IForgeRegistryEntry<?> entry, String prefix, String suffix) {
        ResourceLocation loc = Objects.requireNonNull(entry.getRegistryName());
        return this.modResource(prefix + loc.func_110623_a() + suffix);
    }

    default public ResourceLocation wrap(Supplier<? extends IForgeRegistryEntry<?>> entry, String prefix, String suffix) {
        return this.wrap(entry.get(), prefix, suffix);
    }

    default public ResourceLocation prefix(IForgeRegistryEntry<?> entry, String prefix) {
        ResourceLocation loc = Objects.requireNonNull(entry.getRegistryName());
        return this.modResource(prefix + loc.func_110623_a());
    }

    default public ResourceLocation prefix(Supplier<? extends IForgeRegistryEntry<?>> entry, String prefix) {
        return this.prefix(entry.get(), prefix);
    }

    default public ITag.INamedTag<Item> getTag(String modId, String name) {
        return ItemTags.func_199901_a((String)(modId + ":" + name));
    }

    default public ICondition tagCondition(String name) {
        return new NotCondition((ICondition)new TagEmptyCondition("forge", name));
    }

    default public Consumer<IFinishedRecipe> withCondition(Consumer<IFinishedRecipe> consumer, ICondition ... conditions) {
        ConsumerWrapperBuilder builder = ConsumerWrapperBuilder.wrap();
        for (ICondition condition : conditions) {
            builder.addCondition(condition);
        }
        return builder.build(consumer);
    }
}

