/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.recipe;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.library.data.recipe.IRecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipeBuilder;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.MaterialMeltingRecipeBuilder;

public interface IMaterialRecipeHelper
extends IRecipeHelper {
    default public void materialRecipe(Consumer<IFinishedRecipe> consumer, MaterialId material, Ingredient input, int value, int needed, String saveName) {
        this.materialRecipe(consumer, material, input, value, needed, null, saveName);
    }

    default public void materialRecipe(Consumer<IFinishedRecipe> consumer, MaterialId material, Ingredient input, int value, int needed, @Nullable ItemOutput leftover, String saveName) {
        MaterialRecipeBuilder builder = MaterialRecipeBuilder.materialRecipe(material).setIngredient(input).setValue(value).setNeeded(needed);
        if (leftover != null) {
            builder.setLeftover(leftover);
        }
        builder.build(consumer, this.modResource(saveName));
    }

    default public void metalMaterialRecipe(Consumer<IFinishedRecipe> consumer, MaterialId material, String folder, String name, boolean optional) {
        Consumer<IFinishedRecipe> wrapped = optional ? this.withCondition(consumer, this.tagCondition("ingots/" + name)) : consumer;
        String matName = material.func_110623_a();
        ITag.INamedTag<Item> ingotTag = this.getTag("forge", "ingots/" + name);
        this.materialRecipe(wrapped, material, Ingredient.func_199805_a(ingotTag), 1, 1, folder + matName + "/ingot");
        wrapped = optional ? this.withCondition(consumer, this.tagCondition("nuggets/" + name)) : consumer;
        this.materialRecipe(wrapped, material, Ingredient.func_199805_a(this.getTag("forge", "nuggets/" + name)), 1, 9, folder + matName + "/nugget");
        wrapped = optional ? this.withCondition(consumer, this.tagCondition("storage_blocks/" + name)) : consumer;
        this.materialRecipe(wrapped, material, Ingredient.func_199805_a(this.getTag("forge", "storage_blocks/" + name)), 9, 1, ItemOutput.fromTag(ingotTag, (int)1), folder + matName + "/block");
    }

    default public void materialMeltingCasting(Consumer<IFinishedRecipe> consumer, MaterialId material, FluidObject<?> fluid, boolean forgeTag, int fluidAmount, String folder) {
        MaterialFluidRecipeBuilder.material(material).setFluid((ITag<Fluid>)(forgeTag ? fluid.getForgeTag() : fluid.getLocalTag()), fluidAmount).setTemperature(fluid.get().getAttributes().getTemperature() - 300).build(consumer, this.modResource(folder + "casting/" + material.func_110623_a()));
        MaterialMeltingRecipeBuilder.material(material, new FluidStack((Fluid)fluid.get(), fluidAmount)).build(consumer, this.modResource(folder + "melting/" + material.func_110623_a()));
    }

    default public void materialMeltingCasting(Consumer<IFinishedRecipe> consumer, MaterialId material, FluidObject<?> fluid, boolean forgeTag, String folder) {
        this.materialMeltingCasting(consumer, material, fluid, forgeTag, 144, folder);
    }

    default public void materialMeltingCasting(Consumer<IFinishedRecipe> consumer, MaterialId material, FluidObject<?> fluid, int fluidAmount, String folder) {
        this.materialMeltingCasting(consumer, material, fluid, false, fluidAmount, folder);
    }

    default public void materialMeltingCasting(Consumer<IFinishedRecipe> consumer, MaterialId material, FluidObject<?> fluid, String folder) {
        this.materialMeltingCasting(consumer, material, fluid, 144, folder);
    }

    default public void materialComposite(Consumer<IFinishedRecipe> consumer, MaterialId input, MaterialId output, FluidObject<?> fluid, int amount, boolean forgeTag, String folder) {
        MaterialFluidRecipeBuilder.material(output).setInputId(input).setFluid((ITag<Fluid>)(forgeTag ? fluid.getForgeTag() : fluid.getLocalTag()), amount).setTemperature(fluid.get().getAttributes().getTemperature() - 300).build(consumer, this.modResource(folder + "composite/" + output.func_110623_a()));
    }
}

