/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.google.common.collect.Lists;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.BiomeSourceChecks;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.MansionPieces;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class MansionStructure
extends AbstractBaseStructure<NoFeatureConfig> {
    protected final MansionPieces.MansionTemplate.MANSIONTYPE type;

    public MansionStructure(MansionPieces.MansionTemplate.MANSIONTYPE type) {
        super(NoFeatureConfig.field_236558_a_);
        this.type = type;
    }

    protected boolean func_230365_b_() {
        return false;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig defaultFeatureConfig) {
        if (!BiomeSourceChecks.isCheckeredBiomeSource(biomeSource) && !BiomeSourceChecks.isHexlandBiomeSource(biomeSource)) {
            int biomeRange = 2;
            for (int curChunkX = chunkX - biomeRange; curChunkX <= chunkX + biomeRange; ++curChunkX) {
                for (int curChunkZ = chunkZ - biomeRange; curChunkZ <= chunkZ + biomeRange; ++curChunkZ) {
                    if (biomeSource.func_225526_b_(curChunkX << 2, 64, curChunkZ << 2).func_242440_e().func_242493_a((Structure)this)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new Start((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox box, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, box, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig defaultFeatureConfig) {
            Rotation blockRotation = Rotation.func_222466_a((Random)this.field_214631_d);
            int xOffset = 5;
            int zOffset = 5;
            if (blockRotation == Rotation.CLOCKWISE_90) {
                xOffset = -5;
            } else if (blockRotation == Rotation.CLOCKWISE_180) {
                xOffset = -5;
                zOffset = -5;
            } else if (blockRotation == Rotation.COUNTERCLOCKWISE_90) {
                zOffset = -5;
            }
            int centerX = chunkX * 16;
            int centerZ = chunkZ * 16;
            int firstHeight = chunkGenerator.func_222531_c(centerX, centerZ, Heightmap.Type.WORLD_SURFACE_WG);
            int secondHeight = chunkGenerator.func_222531_c(centerX, centerZ + zOffset, Heightmap.Type.WORLD_SURFACE_WG);
            int thirdHeight = chunkGenerator.func_222531_c(centerX + xOffset, centerZ, Heightmap.Type.WORLD_SURFACE_WG);
            int forthheight = chunkGenerator.func_222531_c(centerX + xOffset, centerZ + zOffset, Heightmap.Type.WORLD_SURFACE_WG);
            int finalheight = Math.min(Math.min(firstHeight, secondHeight), Math.min(thirdHeight, forthheight));
            if (finalheight <= 0) {
                return;
            }
            BlockPos blockPos = new BlockPos(centerX, finalheight + 1, centerZ);
            LinkedList list = Lists.newLinkedList();
            MansionPieces.generateMansion(structureManager, blockPos, blockRotation, list, (Random)this.field_214631_d, MansionStructure.this.type);
            this.field_75075_a.addAll(list);
            this.func_202500_a();
        }

        public void func_230366_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox box, ChunkPos chunkPos) {
            super.func_230366_a_(world, structureAccessor, chunkGenerator, random, box, chunkPos);
            int structureBottomY = this.func_75071_a().field_78895_b;
            int terrainY = Integer.MIN_VALUE;
            for (int x = box.field_78897_a; x <= box.field_78893_d; ++x) {
                for (int z = box.field_78896_c; z <= box.field_78892_f; ++z) {
                    BlockPos blockPos2;
                    BlockPos blockPos = new BlockPos(x, structureBottomY, z);
                    if (RepurposedStructures.RSMansionsConfig.pillarOnlyToLand.get().booleanValue() && (terrainY = GeneralUtils.getFirstLandYFromPos((IWorldReader)world, blockPos.func_177977_b())) <= 0 || world.func_175623_d(blockPos) || !this.func_75071_a().func_175898_b((Vector3i)blockPos)) continue;
                    boolean bl = false;
                    for (StructurePiece structurePiece : this.field_75075_a) {
                        if (!structurePiece.func_74874_b().func_175898_b((Vector3i)blockPos)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                    for (int currentY = structureBottomY - 1; !(currentY <= 1 || RepurposedStructures.RSMansionsConfig.pillarOnlyToLand.get().booleanValue() && currentY <= terrainY || !world.func_175623_d(blockPos2 = new BlockPos(x, currentY, z)) && !world.func_180495_p(blockPos2).func_185904_a().func_76224_d()); --currentY) {
                        world.func_180501_a(blockPos2, MansionStructure.this.type.getFoundationBlock(), 2);
                    }
                }
            }
        }
    }
}

