/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.common.util.Lazy;

public class GenericNetherJigsawStructure
extends GenericJigsawStructure {
    protected final boolean highestLandSearch;
    protected final boolean canPlaceOnLiquid;
    protected final int ledgeSpotOffset;
    protected final int liquidSpotOffset;

    public GenericNetherJigsawStructure(ResourceLocation poolID, Lazy<Integer> structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet, int allowTerrainHeightRange, int terrainHeightRadius, int minHeightLimit, int fixedYSpawn, boolean useHeightmap, boolean cannotSpawnInWater, boolean highestLandSearch, boolean canPlaceOnLiquid, int ledgeSpotOffset, int liquidSpotOffset) {
        super(poolID, structureSize, centerOffset, biomeRange, structureBlacklistRange, avoidStructuresSet, allowTerrainHeightRange, terrainHeightRadius, minHeightLimit, fixedYSpawn, useHeightmap, cannotSpawnInWater);
        this.highestLandSearch = highestLandSearch;
        this.canPlaceOnLiquid = canPlaceOnLiquid;
        this.ledgeSpotOffset = ledgeSpotOffset;
        this.liquidSpotOffset = liquidSpotOffset;
    }

    @Override
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new Start((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public static class Builder<T extends Builder<T>>
    extends GenericJigsawStructure.Builder<T> {
        protected boolean highestLandSearch = false;
        protected boolean canPlaceOnLiquid = false;
        protected int ledgeSpotOffset;
        protected int liquidSpotOffset;

        public Builder(ResourceLocation startPool) {
            super(startPool);
        }

        public T searchForHighestLand() {
            this.highestLandSearch = true;
            return (T)((Builder)this.getThis());
        }

        public T canSpawnOnLiquid() {
            this.canPlaceOnLiquid = true;
            return (T)((Builder)this.getThis());
        }

        public T setLedgeSpotOffset(int ledgeSpotOffset) {
            this.ledgeSpotOffset = ledgeSpotOffset;
            return (T)((Builder)this.getThis());
        }

        public T setLiquidSpotOffset(int liquidSpotOffset) {
            this.liquidSpotOffset = liquidSpotOffset;
            return (T)((Builder)this.getThis());
        }

        @Override
        public GenericNetherJigsawStructure build() {
            return new GenericNetherJigsawStructure(this.startPool, (Lazy<Integer>)this.structureSize, this.centerOffset, this.biomeRange, this.structureBlacklistRange, this.avoidStructuresSet, this.allowTerrainHeightRange, this.terrainHeightRadius, this.minHeightLimit, this.fixedYSpawn, this.useHeightmap, this.cannotSpawnInWater, this.highestLandSearch, this.canPlaceOnLiquid, this.ledgeSpotOffset, this.liquidSpotOffset);
        }
    }

    public class Start
    extends GenericJigsawStructure.MainStart {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox box, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, box, referenceIn, seedIn);
        }

        @Override
        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig defaultFeatureConfig) {
            super.generatePieces(dynamicRegistryManager, chunkGenerator, structureManager, chunkX, chunkZ, biome, defaultFeatureConfig);
            BlockPos placementPos = GenericNetherJigsawStructure.this.highestLandSearch ? GeneralUtils.getHighestLand(chunkGenerator, this.func_75071_a(), GenericNetherJigsawStructure.this.canPlaceOnLiquid) : GeneralUtils.getLowestLand(chunkGenerator, this.func_75071_a(), GenericNetherJigsawStructure.this.canPlaceOnLiquid);
            if (placementPos.func_177956_o() >= chunkGenerator.func_230355_e_() || placementPos.func_177956_o() <= chunkGenerator.func_230356_f_() + 1) {
                this.func_214626_a((Random)this.field_214631_d, chunkGenerator.func_230356_f_() + GenericNetherJigsawStructure.this.ledgeSpotOffset, chunkGenerator.func_230356_f_() + (GenericNetherJigsawStructure.this.ledgeSpotOffset + 1));
            } else {
                this.func_214626_a((Random)this.field_214631_d, placementPos.func_177956_o() + GenericNetherJigsawStructure.this.liquidSpotOffset, placementPos.func_177956_o() + (GenericNetherJigsawStructure.this.liquidSpotOffset + 1));
            }
        }
    }
}

