/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class BuriableStructure
extends AbstractBaseStructure<NoFeatureConfig> {
    private final ResourceLocation startPool;
    private final int offsetAmount;
    private final boolean onLand;
    private final boolean cannotSpawnInWater;

    public BuriableStructure(ResourceLocation startPool, int offsetAmount, boolean onLand, boolean cannotSpawnInWater) {
        super(NoFeatureConfig.field_236558_a_);
        this.startPool = startPool;
        RSStructures.RS_STRUCTURE_START_PIECES.add(this.startPool);
        this.offsetAmount = offsetAmount;
        this.onLand = onLand;
        this.cannotSpawnInWater = cannotSpawnInWater;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig defaultFeatureConfig) {
        if (this.cannotSpawnInWater) {
            BlockPos centerOfChunk = chunkPos.func_206849_h();
            int landHeight = chunkGenerator.func_222531_c(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
            IBlockReader columnOfBlocks = chunkGenerator.func_230348_a_(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p());
            BlockState topBlock = columnOfBlocks.func_180495_p(centerOfChunk.func_177981_b(landHeight));
            return topBlock.func_204520_s().func_206888_e();
        }
        return true;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new Start((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public static class Builder<T extends Builder<T>> {
        private final ResourceLocation startPool;
        private int offsetAmount = 14;
        private boolean onLand = true;
        private boolean cannotSpawnInWater = true;

        public Builder(ResourceLocation startPool) {
            this.startPool = startPool;
        }

        protected T getThis() {
            return (T)this;
        }

        public T setOffsetAmount(int offsetAmount) {
            this.offsetAmount = offsetAmount;
            return this.getThis();
        }

        public T useOceanHeightmap() {
            this.onLand = false;
            return this.getThis();
        }

        public T cannotSpawnInWater() {
            this.cannotSpawnInWater = false;
            return this.getThis();
        }

        public BuriableStructure build() {
            return new BuriableStructure(this.startPool, this.offsetAmount, this.onLand, this.cannotSpawnInWater);
        }
    }

    public class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox box, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, box, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig defaultFeatureConfig) {
            BlockPos blockpos = new BlockPos(chunkX * 16, chunkGenerator.func_230356_f_(), chunkZ * 16);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(BuriableStructure.this.startPool), 11), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)structureManager, (BlockPos)blockpos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)false);
            GeneralUtils.centerAllPieces(blockpos, this.field_75075_a);
            this.func_202500_a();
            Heightmap.Type heightMapToUse = BuriableStructure.this.onLand ? Heightmap.Type.WORLD_SURFACE_WG : Heightmap.Type.OCEAN_FLOOR_WG;
            MutableBoundingBox box = ((StructurePiece)this.field_75075_a.get(0)).func_74874_b();
            int highestLandPos = chunkGenerator.func_222529_a(box.field_78897_a, box.field_78896_c, heightMapToUse);
            highestLandPos = Math.min(highestLandPos, chunkGenerator.func_222529_a(box.field_78897_a, box.field_78892_f, heightMapToUse));
            highestLandPos = Math.min(highestLandPos, chunkGenerator.func_222529_a(box.field_78893_d, box.field_78896_c, heightMapToUse));
            highestLandPos = Math.min(highestLandPos, chunkGenerator.func_222529_a(box.field_78893_d, box.field_78892_f, heightMapToUse));
            if (!BuriableStructure.this.onLand) {
                int maxHeightForSubmerging = chunkGenerator.func_230356_f_() - box.func_78882_c();
                highestLandPos = Math.min(highestLandPos, maxHeightForSubmerging);
            }
            this.func_214626_a((Random)this.field_214631_d, highestLandPos - (BuriableStructure.this.offsetAmount + 1), highestLandPos - BuriableStructure.this.offsetAmount);
        }
    }
}

