/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.misc.MobSpawningOverTime;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IStructureReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public abstract class AbstractBaseStructure<C extends IFeatureConfig>
extends Structure<C> {
    private final Supplier<List<MobSpawnInfo.Spawners>> monsterSpawns = Suppliers.memoize(() -> new ArrayList(MobSpawningOverTime.REPLACE_MOB_SPAWNING.get(EntityClassification.MONSTER).getOrDefault((Object)this, new ArrayList())));
    private final Supplier<List<MobSpawnInfo.Spawners>> creatureSpawns = Suppliers.memoize(() -> new ArrayList(MobSpawningOverTime.REPLACE_MOB_SPAWNING.get(EntityClassification.CREATURE).getOrDefault((Object)this, new ArrayList())));

    public AbstractBaseStructure(Codec<C> codec) {
        super(codec);
    }

    public List<MobSpawnInfo.Spawners> getDefaultSpawnList() {
        return this.monsterSpawns.get();
    }

    public List<MobSpawnInfo.Spawners> getDefaultCreatureSpawnList() {
        return this.creatureSpawns.get();
    }

    public BlockPos func_236388_a_(IWorldReader world, StructureManager structureAccessor, BlockPos searchStartPos, int searchRadius, boolean skipExistingChunks, long worldSeed, StructureSeparationSettings config) {
        return AbstractBaseStructure.locateStructureFast(world, structureAccessor, searchStartPos, searchRadius, skipExistingChunks, worldSeed, config, this);
    }

    public static <C extends IFeatureConfig> BlockPos locateStructureFast(IWorldReader worldView, StructureManager structureAccessor, BlockPos blockPos, int radius, boolean skipExistingChunks, long seed, StructureSeparationSettings structureConfig, Structure<C> structure) {
        int spacing = structureConfig.func_236668_a_();
        int chunkX = blockPos.func_177958_n() >> 4;
        int chunkZ = blockPos.func_177952_p() >> 4;
        SharedSeedRandom chunkRandom = new SharedSeedRandom();
        for (int currentRadius = 0; currentRadius <= 100000; ++currentRadius) {
            for (int xRadius = -currentRadius; xRadius <= currentRadius; ++xRadius) {
                boolean xEdge = xRadius == -currentRadius || xRadius == currentRadius;
                for (int zRadius = -currentRadius; zRadius <= currentRadius; ++zRadius) {
                    boolean zEdge;
                    boolean bl = zEdge = zRadius == -currentRadius || zRadius == currentRadius;
                    if (xEdge || zEdge) {
                        IChunk chunk;
                        StructureStart structureStart;
                        int trueChunkX = chunkX + spacing * xRadius;
                        int trueChunkZ = chunkZ + spacing * zRadius;
                        ChunkPos chunkPos = structure.func_236392_a_(structureConfig, seed, chunkRandom, trueChunkX, trueChunkZ);
                        if (!worldView.func_225526_b_((chunkPos.field_77276_a << 2) + 2, 60, (chunkPos.field_77275_b << 2) + 2).func_242440_e().func_242493_a(structure) || (structureStart = structureAccessor.func_235013_a_(SectionPos.func_218156_a((ChunkPos)(chunk = worldView.func_217348_a(chunkPos.field_77276_a, chunkPos.field_77275_b, ChunkStatus.field_222606_b)).func_76632_l(), (int)0), structure, (IStructureReader)chunk)) == null || !structureStart.func_75069_d()) continue;
                        if (skipExistingChunks && structureStart.func_212687_g()) {
                            structureStart.func_212685_h();
                            return structureStart.func_204294_a();
                        }
                        if (skipExistingChunks) continue;
                        return structureStart.func_204294_a();
                    }
                    zRadius = currentRadius - 1;
                }
            }
        }
        return null;
    }
}

