/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class CloseOffAirSourcesProcessor
extends StructureProcessor {
    public static final Codec<CloseOffAirSourcesProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.mapPair((MapCodec)Registry.field_212618_g.fieldOf("block"), (MapCodec)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("weight")).codec().listOf().fieldOf("weighted_list_of_replacement_blocks").forGetter(processor -> processor.weightedReplacementBlocks)).apply((Applicative)instance, instance.stable(CloseOffAirSourcesProcessor::new)));
    private final List<Pair<Block, Integer>> weightedReplacementBlocks;

    public CloseOffAirSourcesProcessor(List<Pair<Block, Integer>> weightedReplacementBlocks) {
        this.weightedReplacementBlocks = weightedReplacementBlocks;
    }

    public Template.BlockInfo func_230386_a_(IWorldReader worldReader, BlockPos pos, BlockPos pos2, Template.BlockInfo infoIn1, Template.BlockInfo infoIn2, PlacementSettings settings) {
        ChunkPos currentChunkPos = new ChunkPos(infoIn2.field_186242_a);
        if (!infoIn2.field_186243_b.func_204520_s().func_206888_e()) {
            IChunk currentChunk = worldReader.func_212866_a_(currentChunkPos.field_77276_a, currentChunkPos.field_77275_b);
            Fluid currentFluid = infoIn2.field_186243_b.func_204520_s().func_206886_c();
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            for (Direction direction : Direction.values()) {
                Block replacementBlock;
                BlockState neighboringState;
                mutable.func_189533_g((Vector3i)infoIn2.field_186242_a).func_189536_c(direction);
                if (currentChunkPos.field_77276_a != mutable.func_177958_n() >> 4 || currentChunkPos.field_77275_b != mutable.func_177952_p() >> 4) {
                    currentChunk = worldReader.func_217349_x((BlockPos)mutable);
                    currentChunkPos = new ChunkPos((BlockPos)mutable);
                }
                if (!(neighboringState = currentChunk.func_180495_p((BlockPos)mutable)).func_196958_f() && (!(neighboringState.func_177230_c() instanceof FlowingFluidBlock) || currentFluid.equals(neighboringState.func_204520_s().func_206886_c()))) continue;
                if (this.weightedReplacementBlocks.size() == 1) {
                    replacementBlock = (Block)this.weightedReplacementBlocks.get(0).getFirst();
                } else {
                    SharedSeedRandom random = new SharedSeedRandom();
                    random.setSeed(mutable.func_218275_a() * (long)mutable.func_177956_o());
                    replacementBlock = (Block)GeneralUtils.getRandomEntry(this.weightedReplacementBlocks, (Random)random);
                }
                currentChunk.func_177436_a((BlockPos)mutable, replacementBlock.func_176223_P(), false);
            }
        }
        return infoIn2;
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return RSProcessors.CLOSE_OFF_AIR_SOURCES_PROCESSOR;
    }
}

