/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.modinit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructurePieces;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.world.structures.AdvancedDistanceJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.AdvancedJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.BuriableStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.CityNetherStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericNetherJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.LandBasedEndStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.MansionStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.MineshaftEndStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.MineshaftStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.ShipwreckEndStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.ShipwreckNetherStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.StrongholdEndStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.NetherShipwreckConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.MansionPieces;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class RSStructures {
    public static final DeferredRegister<Structure<?>> STRUCTURE_FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"repurposed_structures");
    public static final Map<Structure<?>, StructureSeparationSettings> RS_STRUCTURES = new HashMap();
    public static final Set<ResourceLocation> RS_STRUCTURE_START_PIECES = new HashSet<ResourceLocation>();
    public static RegistryObject<Structure<NoFeatureConfig>> MINESHAFT_BIRCH = RSStructures.addToStructureMaps("mineshaft_birch", () -> ((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)new MineshaftStructure.Builder(new ResourceLocation("repurposed_structures", "mineshafts/birch/start_pool")).setStructureSize(RepurposedStructures.RSMineshaftsConfig.birchMineshaftSize)).setMaxY(RepurposedStructures.RSMineshaftsConfig.birchMineshaftMaxHeight)).setMinY(RepurposedStructures.RSMineshaftsConfig.birchMineshaftMinHeight)).setProbability(RepurposedStructures.RSMineshaftsConfig.birchMineshaftSpawnrate)).build());
    public static RegistryObject<Structure<NoFeatureConfig>> MINESHAFT_DARK_FOREST = RSStructures.addToStructureMaps("mineshaft_dark_forest", () -> ((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)new MineshaftStructure.Builder(new ResourceLocation("repurposed_structures", "mineshafts/dark_forest/start_pool")).setStructureSize(RepurposedStructures.RSMineshaftsConfig.darkForestMineshaftSize)).setMaxY(RepurposedStructures.RSMineshaftsConfig.darkForestMineshaftMaxHeight)).setMinY(RepurposedStructures.RSMineshaftsConfig.darkForestMineshaftMinHeight)).setProbability(RepurposedStructures.RSMineshaftsConfig.darkForestMineshaftSpawnrate)).build());
    public static RegistryObject<Structure<NoFeatureConfig>> MINESHAFT_DESERT = RSStructures.addToStructureMaps("mineshaft_desert", () -> ((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)new MineshaftStructure.Builder(new ResourceLocation("repurposed_structures", "mineshafts/desert/start_pool")).setStructureSize(RepurposedStructures.RSMineshaftsConfig.desertMineshaftSize)).setMaxY(RepurposedStructures.RSMineshaftsConfig.desertMineshaftMaxHeight)).setMinY(RepurposedStructures.RSMineshaftsConfig.desertMineshaftMinHeight)).setProbability(RepurposedStructures.RSMineshaftsConfig.desertMineshaftSpawnrate)).build());
    public static RegistryObject<Structure<NoFeatureConfig>> MINESHAFT_ICY = RSStructures.addToStructureMaps("mineshaft_icy", () -> ((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)new MineshaftStructure.Builder(new ResourceLocation("repurposed_structures", "mineshafts/icy/start_pool")).setStructureSize(RepurposedStructures.RSMineshaftsConfig.icyMineshaftSize)).setMaxY(RepurposedStructures.RSMineshaftsConfig.icyMineshaftMaxHeight)).setMinY(RepurposedStructures.RSMineshaftsConfig.icyMineshaftMinHeight)).setProbability(RepurposedStructures.RSMineshaftsConfig.icyMineshaftSpawnrate)).build());
    public static RegistryObject<Structure<NoFeatureConfig>> MINESHAFT_JUNGLE = RSStructures.addToStructureMaps("mineshaft_jungle", () -> ((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)new MineshaftStructure.Builder(new ResourceLocation("repurposed_structures", "mineshafts/jungle/start_pool")).setStructureSize(RepurposedStructures.RSMineshaftsConfig.jungleMineshaftSize)).setMaxY(RepurposedStructures.RSMineshaftsConfig.jungleMineshaftMaxHeight)).setMinY(RepurposedStructures.RSMineshaftsConfig.jungleMineshaftMinHeight)).setProbability(RepurposedStructures.RSMineshaftsConfig.jungleMineshaftSpawnrate)).build());
    public static RegistryObject<Structure<NoFeatureConfig>> MINESHAFT_OCEAN = RSStructures.addToStructureMaps("mineshaft_ocean", () -> ((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)new MineshaftStructure.Builder(new ResourceLocation("repurposed_structures", "mineshafts/ocean/start_pool")).setStructureSize(RepurposedStructures.RSMineshaftsConfig.oceanMineshaftSize)).setMaxY(RepurposedStructures.RSMineshaftsConfig.oceanMineshaftMaxHeight)).setMinY(RepurposedStructures.RSMineshaftsConfig.oceanMineshaftMinHeight)).setProbability(RepurposedStructures.RSMineshaftsConfig.oceanMineshaftSpawnrate)).build());
    public static RegistryObject<Structure<NoFeatureConfig>> MINESHAFT_SAVANNA = RSStructures.addToStructureMaps("mineshaft_savanna", () -> ((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)new MineshaftStructure.Builder(new ResourceLocation("repurposed_structures", "mineshafts/savanna/start_pool")).setStructureSize(RepurposedStructures.RSMineshaftsConfig.savannaMineshaftSize)).setMaxY(RepurposedStructures.RSMineshaftsConfig.savannaMineshaftMaxHeight)).setMinY(RepurposedStructures.RSMineshaftsConfig.savannaMineshaftMinHeight)).setProbability(RepurposedStructures.RSMineshaftsConfig.savannaMineshaftSpawnrate)).build());
    public static RegistryObject<Structure<NoFeatureConfig>> MINESHAFT_STONE = RSStructures.addToStructureMaps("mineshaft_stone", () -> ((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)new MineshaftStructure.Builder(new ResourceLocation("repurposed_structures", "mineshafts/stone/start_pool")).setStructureSize(RepurposedStructures.RSMineshaftsConfig.stoneMineshaftSize)).setMaxY(RepurposedStructures.RSMineshaftsConfig.stoneMineshaftMaxHeight)).setMinY(RepurposedStructures.RSMineshaftsConfig.stoneMineshaftMinHeight)).setProbability(RepurposedStructures.RSMineshaftsConfig.stoneMineshaftSpawnrate)).build());
    public static RegistryObject<Structure<NoFeatureConfig>> MINESHAFT_SWAMP = RSStructures.addToStructureMaps("mineshaft_swamp", () -> ((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)new MineshaftStructure.Builder(new ResourceLocation("repurposed_structures", "mineshafts/swamp/start_pool")).setStructureSize(RepurposedStructures.RSMineshaftsConfig.swampMineshaftSize)).setMaxY(RepurposedStructures.RSMineshaftsConfig.swampMineshaftMaxHeight)).setMinY(RepurposedStructures.RSMineshaftsConfig.swampMineshaftMinHeight)).setProbability(RepurposedStructures.RSMineshaftsConfig.swampMineshaftSpawnrate)).build());
    public static RegistryObject<Structure<NoFeatureConfig>> MINESHAFT_TAIGA = RSStructures.addToStructureMaps("mineshaft_taiga", () -> ((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)new MineshaftStructure.Builder(new ResourceLocation("repurposed_structures", "mineshafts/taiga/start_pool")).setStructureSize(RepurposedStructures.RSMineshaftsConfig.taigaMineshaftSize)).setMaxY(RepurposedStructures.RSMineshaftsConfig.taigaMineshaftMaxHeight)).setMinY(RepurposedStructures.RSMineshaftsConfig.taigaMineshaftMinHeight)).setProbability(RepurposedStructures.RSMineshaftsConfig.taigaMineshaftSpawnrate)).build());
    public static RegistryObject<Structure<NoFeatureConfig>> MINESHAFT_NETHER = RSStructures.addToStructureMaps("mineshaft_nether", () -> ((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)new MineshaftStructure.Builder(new ResourceLocation("repurposed_structures", "mineshafts/nether/start_pool")).setStructureSize(RepurposedStructures.RSMineshaftsConfig.netherMineshaftSize)).setMaxY(RepurposedStructures.RSMineshaftsConfig.netherMineshaftMaxHeight)).setMinY(RepurposedStructures.RSMineshaftsConfig.netherMineshaftMinHeight)).setProbability(RepurposedStructures.RSMineshaftsConfig.netherMineshaftSpawnrate)).build());
    public static RegistryObject<Structure<NoFeatureConfig>> MINESHAFT_CRIMSON = RSStructures.addToStructureMaps("mineshaft_crimson", () -> ((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)new MineshaftStructure.Builder(new ResourceLocation("repurposed_structures", "mineshafts/crimson/start_pool")).setStructureSize(RepurposedStructures.RSMineshaftsConfig.crimsonMineshaftSize)).setMaxY(RepurposedStructures.RSMineshaftsConfig.crimsonMineshaftMaxHeight)).setMinY(RepurposedStructures.RSMineshaftsConfig.crimsonMineshaftMinHeight)).setProbability(RepurposedStructures.RSMineshaftsConfig.crimsonMineshaftSpawnrate)).build());
    public static RegistryObject<Structure<NoFeatureConfig>> MINESHAFT_WARPED = RSStructures.addToStructureMaps("mineshaft_warped", () -> ((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)((MineshaftStructure.Builder)new MineshaftStructure.Builder(new ResourceLocation("repurposed_structures", "mineshafts/warped/start_pool")).setStructureSize(RepurposedStructures.RSMineshaftsConfig.warpedMineshaftSize)).setMaxY(RepurposedStructures.RSMineshaftsConfig.warpedMineshaftMaxHeight)).setMinY(RepurposedStructures.RSMineshaftsConfig.warpedMineshaftMinHeight)).setProbability(RepurposedStructures.RSMineshaftsConfig.warpedMineshaftSpawnrate)).build());
    public static RegistryObject<Structure<NoFeatureConfig>> MINESHAFT_END = RSStructures.addToStructureMaps("mineshaft_end", () -> ((MineshaftEndStructure.Builder)((MineshaftEndStructure.Builder)new MineshaftEndStructure.Builder(new ResourceLocation("repurposed_structures", "mineshafts/end/start_pool")).setStructureSize(RepurposedStructures.RSMineshaftsConfig.endMineshaftSize)).setProbability(RepurposedStructures.RSMineshaftsConfig.endMineshaftSpawnrate)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> STRONGHOLD_NETHER = RSStructures.addToStructureMaps("stronghold_nether", () -> ((AdvancedDistanceJigsawStructure.Builder)((AdvancedDistanceJigsawStructure.Builder)((AdvancedDistanceJigsawStructure.Builder)((AdvancedDistanceJigsawStructure.Builder)new AdvancedDistanceJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "strongholds/nether/start_pool")).setStructureSize(RepurposedStructures.RSStrongholdsConfig.netherStrongholdSize)).setMaxY(RepurposedStructures.RSStrongholdsConfig.netherStrongholdMaxHeight)).setMinY(RepurposedStructures.RSStrongholdsConfig.netherStrongholdMinHeight)).setDistanceFromWorldOrigin(2817)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> STRONGHOLD_END = RSStructures.addToStructureMaps("stronghold_end", () -> ((StrongholdEndStructure.Builder)((StrongholdEndStructure.Builder)((StrongholdEndStructure.Builder)((StrongholdEndStructure.Builder)((StrongholdEndStructure.Builder)((StrongholdEndStructure.Builder)new StrongholdEndStructure.Builder(new ResourceLocation("repurposed_structures", "strongholds/end/start_pool")).setStructureSize(RepurposedStructures.RSStrongholdsConfig.strongholdEndSize)).setMaxY(RepurposedStructures.RSStrongholdsConfig.strongholdEndMaxHeight)).setMinY(RepurposedStructures.RSStrongholdsConfig.strongholdEndMinHeight)).setVerticalRange(RepurposedStructures.RSStrongholdsConfig.strongholdEndVerticalRange)).setDistanceFromWorldOrigin(8000)).doNotClipOutOfBoundsPieces()).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> FORTRESS_JUNGLE = RSStructures.addToStructureMaps("fortress_jungle", () -> ((AdvancedJigsawStructure.Builder)((AdvancedJigsawStructure.Builder)((AdvancedJigsawStructure.Builder)((AdvancedJigsawStructure.Builder)((AdvancedJigsawStructure.Builder)((AdvancedJigsawStructure.Builder)new AdvancedJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "fortresses/jungle/start_pool")).setStructureSize(RepurposedStructures.RSFortressesConfig.jungleFortressSize)).setBiomeRange(4)).setMaxY(RepurposedStructures.RSFortressesConfig.jungleFortressMaxHeight)).setMinY(RepurposedStructures.RSFortressesConfig.jungleFortressMinHeight)).setVerticalRange(RepurposedStructures.RSFortressesConfig.jungleFortressVerticalRange)).doNotClipOutOfBoundsPieces()).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> IGLOO_GRASSY = RSStructures.addToStructureMaps("igloo_grassy", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "igloos/grassy_top")).setStructureSize(20)).cannotSpawnInWater()).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> IGLOO_STONE = RSStructures.addToStructureMaps("igloo_stone", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "igloos/stone_top")).setStructureSize(20)).cannotSpawnInWater()).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> TEMPLE_NETHER_WASTELAND = RSStructures.addToStructureMaps("temple_nether_wasteland", () -> ((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)new GenericNetherJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "temples/temple_nether_wasteland")).setStructureSize(8)).canSpawnOnLiquid()).setLedgeSpotOffset(-16)).setLiquidSpotOffset(-16)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> TEMPLE_NETHER_BASALT = RSStructures.addToStructureMaps("temple_nether_basalt", () -> ((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)new GenericNetherJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "temples/temple_nether_basalt")).setStructureSize(8)).canSpawnOnLiquid()).setLedgeSpotOffset(-16)).setLiquidSpotOffset(-16)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> TEMPLE_NETHER_WARPED = RSStructures.addToStructureMaps("temple_nether_warped", () -> ((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)new GenericNetherJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "temples/temple_nether_warped")).setStructureSize(8)).canSpawnOnLiquid()).setLedgeSpotOffset(-16)).setLiquidSpotOffset(-16)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> TEMPLE_NETHER_CRIMSON = RSStructures.addToStructureMaps("temple_nether_crimson", () -> ((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)new GenericNetherJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "temples/temple_nether_crimson")).setStructureSize(8)).canSpawnOnLiquid()).setLedgeSpotOffset(-16)).setLiquidSpotOffset(-16)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> TEMPLE_NETHER_SOUL = RSStructures.addToStructureMaps("temple_nether_soul", () -> ((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)new GenericNetherJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "temples/temple_nether_soul")).setStructureSize(8)).canSpawnOnLiquid()).setLedgeSpotOffset(-16)).setLiquidSpotOffset(-16)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_BIRCH = RSStructures.addToStructureMaps("outpost_birch", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "outposts/birch/base_plates")).setStructureSize(11)).setStructureBlacklistRange(5)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.OUTPOST_AVOID_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_JUNGLE = RSStructures.addToStructureMaps("outpost_jungle", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "outposts/jungle/base_plates")).setStructureSize(11)).setBiomeRange(1)).setStructureBlacklistRange(5)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.OUTPOST_AVOID_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_GIANT_TREE_TAIGA = RSStructures.addToStructureMaps("outpost_giant_tree_taiga", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "outposts/giant_tree_taiga/base_plates")).setStructureSize(11)).setStructureBlacklistRange(5)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.OUTPOST_AVOID_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_DESERT = RSStructures.addToStructureMaps("outpost_desert", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "outposts/desert/base_plates")).setStructureSize(11)).setBiomeRange(1)).setStructureBlacklistRange(5)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.OUTPOST_AVOID_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_BADLANDS = RSStructures.addToStructureMaps("outpost_badlands", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "outposts/badlands/base_plates")).setStructureSize(11)).setTerrainHeightRadius(1)).setAllowTerrainHeightRange(20)).setStructureBlacklistRange(5)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.OUTPOST_AVOID_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_SNOWY = RSStructures.addToStructureMaps("outpost_snowy", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "outposts/snowy/base_plates")).setStructureSize(11)).setStructureBlacklistRange(5)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.OUTPOST_AVOID_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_ICY = RSStructures.addToStructureMaps("outpost_icy", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "outposts/icy/base_plates")).setStructureSize(11)).setBiomeRange(1)).setStructureBlacklistRange(5)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.OUTPOST_AVOID_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_TAIGA = RSStructures.addToStructureMaps("outpost_taiga", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "outposts/taiga/base_plates")).setStructureSize(11)).setBiomeRange(1)).setStructureBlacklistRange(5)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.OUTPOST_AVOID_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_OAK = RSStructures.addToStructureMaps("outpost_oak", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "outposts/oak/base_plates")).setStructureSize(11)).setBiomeRange(1)).setStructureBlacklistRange(5)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.OUTPOST_AVOID_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_NETHER_BRICK = RSStructures.addToStructureMaps("outpost_nether_brick", () -> ((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)new GenericNetherJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "outposts/nether_brick/base_plates")).setStructureSize(11)).canSpawnOnLiquid()).setLedgeSpotOffset(-13)).setLiquidSpotOffset(-11)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_WARPED = RSStructures.addToStructureMaps("outpost_warped", () -> ((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)new GenericNetherJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "outposts/warped/base_plates")).setStructureSize(11)).canSpawnOnLiquid()).setLedgeSpotOffset(-13)).setLiquidSpotOffset(-11)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_CRIMSON = RSStructures.addToStructureMaps("outpost_crimson", () -> ((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)new GenericNetherJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "outposts/crimson/base_plates")).setStructureSize(11)).canSpawnOnLiquid()).setLedgeSpotOffset(-13)).setLiquidSpotOffset(-11)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_END = RSStructures.addToStructureMaps("outpost_end", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "outposts/end/base_plates")).setStructureSize(11)).setBiomeRange(2)).setAllowTerrainHeightRange(3)).setAllowTerrainHeightRange(15)).setMinHeightLimit(55)).setStructureBlacklistRange(4)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.END_AVOID_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> PYRAMID_BADLANDS = RSStructures.addToStructureMaps("pyramid_badlands", () -> new BuriableStructure.Builder(new ResourceLocation("repurposed_structures", "temples/pyramid_badlands")).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> PYRAMID_SNOWY = RSStructures.addToStructureMaps("pyramid_snowy", () -> new BuriableStructure.Builder(new ResourceLocation("repurposed_structures", "temples/pyramid_snowy")).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> PYRAMID_ICY = RSStructures.addToStructureMaps("pyramid_icy", () -> new BuriableStructure.Builder(new ResourceLocation("repurposed_structures", "temples/pyramid_icy")).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> PYRAMID_JUNGLE = RSStructures.addToStructureMaps("pyramid_jungle", () -> ((BuriableStructure.Builder)new BuriableStructure.Builder(new ResourceLocation("repurposed_structures", "temples/pyramid_jungle")).setOffsetAmount(20)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> PYRAMID_MUSHROOM = RSStructures.addToStructureMaps("pyramid_mushroom", () -> new BuriableStructure.Builder(new ResourceLocation("repurposed_structures", "temples/pyramid_mushroom")).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> PYRAMID_OCEAN = RSStructures.addToStructureMaps("pyramid_ocean", () -> ((BuriableStructure.Builder)((BuriableStructure.Builder)new BuriableStructure.Builder(new ResourceLocation("repurposed_structures", "temples/pyramid_ocean")).cannotSpawnInWater()).useOceanHeightmap()).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> PYRAMID_GIANT_TREE_TAIGA = RSStructures.addToStructureMaps("pyramid_giant_tree_taiga", () -> new BuriableStructure.Builder(new ResourceLocation("repurposed_structures", "temples/pyramid_giant_tree_taiga")).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> PYRAMID_FLOWER_FOREST = RSStructures.addToStructureMaps("pyramid_flower_forest", () -> new BuriableStructure.Builder(new ResourceLocation("repurposed_structures", "temples/pyramid_flower_forest")).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> PYRAMID_NETHER = RSStructures.addToStructureMaps("pyramid_nether", () -> ((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)new GenericNetherJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "temples/pyramid_nether")).setStructureSize(8)).searchForHighestLand()).canSpawnOnLiquid()).setLedgeSpotOffset(-14)).setLiquidSpotOffset(-13)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> PYRAMID_END = RSStructures.addToStructureMaps("pyramid_end", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new LandBasedEndStructure.Builder(new ResourceLocation("repurposed_structures", "temples/pyramid_end")).setStructureSize(11)).setCenterOffset(-2)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> SHIPWRECK_END = RSStructures.addToStructureMaps("shipwreck_end", ShipwreckEndStructure::new);
    public static final RegistryObject<Structure<NetherShipwreckConfig>> SHIPWRECK_NETHER_BRICKS = RSStructures.addToStructureMaps("shipwreck_nether_bricks", () -> new ShipwreckNetherStructure(new ResourceLocation("repurposed_structures", "shipwrecks/nether_bricks"), -3));
    public static final RegistryObject<Structure<NetherShipwreckConfig>> SHIPWRECK_CRIMSON = RSStructures.addToStructureMaps("shipwreck_crimson", () -> new ShipwreckNetherStructure(new ResourceLocation("repurposed_structures", "shipwrecks/crimson"), -4));
    public static final RegistryObject<Structure<NetherShipwreckConfig>> SHIPWRECK_WARPED = RSStructures.addToStructureMaps("shipwreck_warped", () -> new ShipwreckNetherStructure(new ResourceLocation("repurposed_structures", "shipwrecks/warped"), -4));
    public static final RegistryObject<Structure<NoFeatureConfig>> VILLAGE_BADLANDS = RSStructures.addToStructureMaps("village_badlands", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "village/badlands/town_centers")).setStructureSize(RepurposedStructures.RSVillagesConfig.badlandsVillageSize)).setBiomeRange(1)).setTerrainHeightRadius(2)).setAllowTerrainHeightRange(20)).setStructureBlacklistRange(6)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.MANSION, RSStructureTagMap.STRUCTURE_TAGS.VILLAGE_AVOID_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> VILLAGE_BIRCH = RSStructures.addToStructureMaps("village_birch", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "village/birch/town_centers")).setStructureSize(RepurposedStructures.RSVillagesConfig.birchVillageSize)).setBiomeRange(1)).setStructureBlacklistRange(6)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.MANSION, RSStructureTagMap.STRUCTURE_TAGS.VILLAGE_AVOID_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> VILLAGE_DARK_FOREST = RSStructures.addToStructureMaps("village_dark_oak", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "village/dark_forest/town_centers")).setStructureSize(RepurposedStructures.RSVillagesConfig.darkForestVillageSize)).setBiomeRange(1)).setStructureBlacklistRange(6)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.MANSION, RSStructureTagMap.STRUCTURE_TAGS.VILLAGE_AVOID_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> VILLAGE_JUNGLE = RSStructures.addToStructureMaps("village_jungle", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "village/jungle/town_centers")).setStructureSize(RepurposedStructures.RSVillagesConfig.jungleVillageSize)).setBiomeRange(1)).setStructureBlacklistRange(6)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.MANSION, RSStructureTagMap.STRUCTURE_TAGS.VILLAGE_AVOID_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> VILLAGE_SWAMP = RSStructures.addToStructureMaps("village_swamp", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "village/swamp/town_centers")).setStructureSize(RepurposedStructures.RSVillagesConfig.swampVillageSize)).setCenterOffset(-1)).setBiomeRange(1)).setStructureBlacklistRange(6)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.MANSION, RSStructureTagMap.STRUCTURE_TAGS.VILLAGE_AVOID_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> VILLAGE_MOUNTAINS = RSStructures.addToStructureMaps("village_mountains", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "village/mountains/town_centers")).setStructureSize(RepurposedStructures.RSVillagesConfig.mountainsVillageSize)).setBiomeRange(1)).setStructureBlacklistRange(6)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.MANSION, RSStructureTagMap.STRUCTURE_TAGS.VILLAGE_AVOID_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> VILLAGE_GIANT_TAIGA = RSStructures.addToStructureMaps("village_giant_taiga", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "village/giant_taiga/town_centers")).setStructureSize(RepurposedStructures.RSVillagesConfig.giantTaigaVillageSize)).setBiomeRange(1)).setStructureBlacklistRange(6)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.MANSION, RSStructureTagMap.STRUCTURE_TAGS.VILLAGE_AVOID_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> VILLAGE_OAK = RSStructures.addToStructureMaps("village_oak", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "village/oak/town_centers")).setStructureSize(RepurposedStructures.RSVillagesConfig.oakVillageSize)).setBiomeRange(1)).setStructureBlacklistRange(6)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.MANSION, RSStructureTagMap.STRUCTURE_TAGS.VILLAGE_AVOID_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> VILLAGE_CRIMSON = RSStructures.addToStructureMaps("village_crimson", () -> ((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)new GenericNetherJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "village/crimson/town_centers")).setStructureSize(RepurposedStructures.RSVillagesConfig.crimsonVillageSize)).searchForHighestLand()).setLedgeSpotOffset(-12)).setLiquidSpotOffset(-11)).setBiomeRange(1)).setStructureBlacklistRange(10)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.NETHER_OUTPOST).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> VILLAGE_WARPED = RSStructures.addToStructureMaps("village_warped", () -> ((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)new GenericNetherJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "village/warped/town_centers")).setStructureSize(RepurposedStructures.RSVillagesConfig.warpedVillageSize)).searchForHighestLand()).setLedgeSpotOffset(-12)).setLiquidSpotOffset(-11)).setBiomeRange(1)).setStructureBlacklistRange(10)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.NETHER_OUTPOST).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> VILLAGE_MUSHROOM = RSStructures.addToStructureMaps("village_mushroom", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "village/mushroom/town_centers")).setStructureSize(RepurposedStructures.RSVillagesConfig.mushroomVillageSize)).setBiomeRange(1)).setStructureBlacklistRange(6)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.MANSION, RSStructureTagMap.STRUCTURE_TAGS.VILLAGE_AVOID_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> RUINED_PORTAL_END = RSStructures.addToStructureMaps("ruined_portal_end", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new LandBasedEndStructure.Builder(new ResourceLocation("repurposed_structures", "ruined_portal/end")).setStructureSize(20)).setCenterOffset(-6)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> RUINS_NETHER = RSStructures.addToStructureMaps("ruins_nether", () -> ((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)((GenericNetherJigsawStructure.Builder)new GenericNetherJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "ruins/nether/start_pool")).setStructureSize(1)).searchForHighestLand()).canSpawnOnLiquid()).setLedgeSpotOffset(-14)).setLiquidSpotOffset(-13)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> RUINS_LAND_WARM = RSStructures.addToStructureMaps("ruins_land_warm", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "ruins/land_warm/start_pool")).setStructureSize(2)).setTerrainHeightRadius(2)).setAllowTerrainHeightRange(5)).cannotSpawnInWater()).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> RUINS_LAND_HOT = RSStructures.addToStructureMaps("ruins_land_hot", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "ruins/land_hot/start_pool")).setStructureSize(2)).setTerrainHeightRadius(2)).setAllowTerrainHeightRange(5)).cannotSpawnInWater()).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> CITY_NETHER = RSStructures.addToStructureMaps("city_nether", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new CityNetherStructure.Builder(new ResourceLocation("repurposed_structures", "cities/nether/start_pool")).setStructureSize(5)).setStructureBlacklistRange(4)).setAvoidStructuresSet(Stream.of(RSStructureTagMap.STRUCTURE_TAGS.GENERIC_AVOID_NETHER_STRUCTURE).collect(Collectors.toSet()))).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> MANSION_BIRCH = RSStructures.addToStructureMaps("mansion_birch", () -> new MansionStructure(MansionPieces.MansionTemplate.MANSIONTYPE.BIRCH));
    public static final RegistryObject<Structure<NoFeatureConfig>> MANSION_JUNGLE = RSStructures.addToStructureMaps("mansion_jungle", () -> new MansionStructure(MansionPieces.MansionTemplate.MANSIONTYPE.JUNGLE));
    public static final RegistryObject<Structure<NoFeatureConfig>> MANSION_OAK = RSStructures.addToStructureMaps("mansion_oak", () -> new MansionStructure(MansionPieces.MansionTemplate.MANSIONTYPE.OAK));
    public static final RegistryObject<Structure<NoFeatureConfig>> MANSION_SAVANNA = RSStructures.addToStructureMaps("mansion_savanna", () -> new MansionStructure(MansionPieces.MansionTemplate.MANSIONTYPE.SAVANNA));
    public static final RegistryObject<Structure<NoFeatureConfig>> MANSION_TAIGA = RSStructures.addToStructureMaps("mansion_taiga", () -> new MansionStructure(MansionPieces.MansionTemplate.MANSIONTYPE.TAIGA));
    public static final RegistryObject<Structure<NoFeatureConfig>> MANSION_DESERT = RSStructures.addToStructureMaps("mansion_desert", () -> new MansionStructure(MansionPieces.MansionTemplate.MANSIONTYPE.DESERT));
    public static final RegistryObject<Structure<NoFeatureConfig>> MANSION_SNOWY = RSStructures.addToStructureMaps("mansion_snowy", () -> new MansionStructure(MansionPieces.MansionTemplate.MANSIONTYPE.SNOWY));
    public static final RegistryObject<Structure<NoFeatureConfig>> WITCH_HUTS_OAK = RSStructures.addToStructureMaps("witch_hut_oak", () -> ((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "witch_huts/oak_start_pool")).setStructureSize(11)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> WITCH_HUTS_TAIGA = RSStructures.addToStructureMaps("witch_hut_taiga", () -> ((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "witch_huts/taiga_start_pool")).setStructureSize(11)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> WITCH_HUTS_BIRCH = RSStructures.addToStructureMaps("witch_hut_birch", () -> ((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "witch_huts/birch_start_pool")).setStructureSize(11)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> WITCH_HUTS_DARK_FOREST = RSStructures.addToStructureMaps("witch_hut_dark_forest", () -> ((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "witch_huts/dark_forest_start_pool")).setStructureSize(11)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> WITCH_HUTS_GIANT_TREE_TAIGA = RSStructures.addToStructureMaps("witch_hut_giant_tree_taiga", () -> ((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "witch_huts/giant_tree_taiga_start_pool")).setStructureSize(11)).build());
    public static final RegistryObject<Structure<NoFeatureConfig>> BASTION_UNDERGROUND = RSStructures.addToStructureMaps("bastion_underground", () -> ((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)((GenericJigsawStructure.Builder)new GenericJigsawStructure.Builder(new ResourceLocation("repurposed_structures", "bastions/underground/starts")).setStructureSize(10)).setFixedYSpawn(12)).doNotUseHeightmap()).setBiomeRange(7)).setStructureBlacklistRange(5)).setAvoidStructuresSet((Set<RSStructureTagMap.STRUCTURE_TAGS>)ImmutableSet.of((Object)((Object)RSStructureTagMap.STRUCTURE_TAGS.BASTION_AVOID_STRUCTURE)))).build());

    private static <T extends Structure<?>> RegistryObject<T> addToStructureMaps(String name, Supplier<T> structure) {
        return STRUCTURE_FEATURES.register(name, structure);
    }

    public static void setupStructures() {
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_birch"), (Structure)MINESHAFT_BIRCH.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 399117345));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_dark_forest"), (Structure)MINESHAFT_DARK_FOREST.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 2011511156));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_desert"), (Structure)MINESHAFT_DESERT.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1990612785));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_end"), (Structure)MINESHAFT_END.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 2057488602));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_nether"), (Structure)MINESHAFT_NETHER.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1220811654));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_crimson"), (Structure)MINESHAFT_CRIMSON.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1153019610));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_warped"), (Structure)MINESHAFT_WARPED.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1095888662));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_icy"), (Structure)MINESHAFT_ICY.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1451015246));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_jungle"), (Structure)MINESHAFT_JUNGLE.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1434412876));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_ocean"), (Structure)MINESHAFT_OCEAN.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1774808662));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_savanna"), (Structure)MINESHAFT_SAVANNA.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1960212212));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_stone"), (Structure)MINESHAFT_STONE.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1436736620));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_swamp"), (Structure)MINESHAFT_SWAMP.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 2037177700));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_taiga"), (Structure)MINESHAFT_TAIGA.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1383003172));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "stronghold_nether"), (Structure)STRONGHOLD_NETHER.get(), GenerationStage.Decoration.TOP_LAYER_MODIFICATION, RSStructures.createSpacingAndSalt(RepurposedStructures.RSStrongholdsConfig.netherStrongholdMaxChunkDistance.get(), 0.5f, 1731422513));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "stronghold_end"), (Structure)STRONGHOLD_END.get(), GenerationStage.Decoration.STRONGHOLDS, new StructureSeparationSettings(RepurposedStructures.RSStrongholdsConfig.strongholdEndMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSStrongholdsConfig.strongholdEndMaxChunkDistance.get().intValue() * 0.5f), 1922886435));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "fortress_jungle"), (Structure)FORTRESS_JUNGLE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSFortressesConfig.jungleFortressMaxChunkDistance.get(), 0.5f, 1464189157));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "igloo_grassy"), (Structure)IGLOO_GRASSY.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSIgloosConfig.grassyIglooMaxChunkDistance.get(), 0.5f, 1460835582));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "igloo_stone"), (Structure)IGLOO_STONE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSIgloosConfig.stoneIglooMaxChunkDistance.get(), 0.5f, 1327429039));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "temple_nether_wasteland"), (Structure)TEMPLE_NETHER_WASTELAND.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSTemplesConfig.netherWastelandTempleMaxChunkDistance.get(), 0.5f, 1435489909));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "temple_nether_soul"), (Structure)TEMPLE_NETHER_SOUL.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSTemplesConfig.netherSoulTempleMaxChunkDistance.get(), 0.5f, 1799485937));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "temple_nether_basalt"), (Structure)TEMPLE_NETHER_BASALT.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSTemplesConfig.netherBasaltTempleMaxChunkDistance.get(), 0.5f, 1063117750));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "temple_nether_crimson"), (Structure)TEMPLE_NETHER_CRIMSON.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSTemplesConfig.netherCrimsonTempleMaxChunkDistance.get(), 0.5f, 1898896156));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "temple_nether_warped"), (Structure)TEMPLE_NETHER_WARPED.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSTemplesConfig.netherWarpedTempleMaxChunkDistance.get(), 0.5f, 1635542708));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_nether_brick"), (Structure)OUTPOST_NETHER_BRICK.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSOutpostsConfig.netherBrickOutpostMaxChunkDistance.get(), 0.5f, 1305971394));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_warped"), (Structure)OUTPOST_WARPED.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSOutpostsConfig.warpedOutpostMaxChunkDistance.get(), 0.5f, 1928816918));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_crimson"), (Structure)OUTPOST_CRIMSON.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSOutpostsConfig.crimsonOutpostMaxChunkDistance.get(), 0.5f, 1951425662));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_birch"), (Structure)OUTPOST_BIRCH.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSOutpostsConfig.outpostBirchMaxChunkDistance.get(), 0.5f, 1676743168));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_jungle"), (Structure)OUTPOST_JUNGLE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSOutpostsConfig.outpostJungleMaxChunkDistance.get(), 0.5f, 548433028));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_giant_tree_taiga"), (Structure)OUTPOST_GIANT_TREE_TAIGA.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSOutpostsConfig.outpostGiantTreeTaigaMaxChunkDistance.get(), 0.5f, 993252541));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_desert"), (Structure)OUTPOST_DESERT.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSOutpostsConfig.outpostDesertMaxChunkDistance.get(), 0.5f, 593099376));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_badlands"), (Structure)OUTPOST_BADLANDS.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSOutpostsConfig.outpostBadlandsMaxChunkDistance.get(), 0.5f, 1702026868));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_snowy"), (Structure)OUTPOST_SNOWY.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSOutpostsConfig.outpostSnowyMaxChunkDistance.get(), 0.5f, 849388460));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_icy"), (Structure)OUTPOST_ICY.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSOutpostsConfig.outpostIcyMaxChunkDistance.get(), 0.5f, 935294633));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_taiga"), (Structure)OUTPOST_TAIGA.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSOutpostsConfig.outpostTaigaMaxChunkDistance.get(), 0.5f, 272805097));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_oak"), (Structure)OUTPOST_OAK.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSOutpostsConfig.outpostOakMaxChunkDistance.get(), 0.5f, 698118385));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_end"), (Structure)OUTPOST_END.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSOutpostsConfig.outpostEndMaxChunkDistance.get(), 0.5f, 831830630));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_badlands"), (Structure)PYRAMID_BADLANDS.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSPyramidsConfig.badlandsPyramidMaxChunkDistance.get(), 0.5f, 1718729448));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_nether"), (Structure)PYRAMID_NETHER.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSPyramidsConfig.netherPyramidMaxChunkDistance.get(), 0.5f, 2054372964));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_snowy"), (Structure)PYRAMID_SNOWY.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSPyramidsConfig.pyramidSnowyMaxChunkDistance.get(), 0.5f, 1630533493));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_end"), (Structure)PYRAMID_END.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSPyramidsConfig.pyramidEndMaxChunkDistance.get(), 0.5f, 1145023315));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_icy"), (Structure)PYRAMID_ICY.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSPyramidsConfig.pyramidIcyMaxChunkDistance.get(), 0.5f, 884076931));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_jungle"), (Structure)PYRAMID_JUNGLE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSPyramidsConfig.pyramidJungleMaxChunkDistance.get(), 0.5f, 1483015905));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_mushroom"), (Structure)PYRAMID_MUSHROOM.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSPyramidsConfig.pyramidMushroomMaxChunkDistance.get(), 0.5f, 1035759391));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_ocean"), (Structure)PYRAMID_OCEAN.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSPyramidsConfig.pyramidOceanMaxChunkDistance.get(), 0.5f, 777281414));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_giant_tree_taiga"), (Structure)PYRAMID_GIANT_TREE_TAIGA.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSPyramidsConfig.pyramidGiantTreeTaigaMaxChunkDistance.get(), 0.5f, 1977974973));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_flower_forest"), (Structure)PYRAMID_FLOWER_FOREST.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSPyramidsConfig.pyramidFlowerForestMaxChunkDistance.get(), 0.5f, 1984904323));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "shipwreck_end"), (Structure)SHIPWRECK_END.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSShipwrecksConfig.endShipwreckMaxChunkDistance.get(), 0.5f, 1605500075));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "shipwreck_nether_bricks"), (Structure)SHIPWRECK_NETHER_BRICKS.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSShipwrecksConfig.netherBricksShipwreckMaxChunkDistance.get(), 0.5f, 2073308006), new NetherShipwreckConfig(true));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "shipwreck_crimson"), (Structure)SHIPWRECK_CRIMSON.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSShipwrecksConfig.crimsonShipwreckMaxChunkDistance.get(), 0.5f, 1019716871), new NetherShipwreckConfig(false));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "shipwreck_warped"), (Structure)SHIPWRECK_WARPED.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSShipwrecksConfig.warpedShipwreckMaxChunkDistance.get(), 0.5f, 2072979641), new NetherShipwreckConfig(false));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_badlands"), (Structure)VILLAGE_BADLANDS.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSVillagesConfig.badlandsVillageMaxChunkDistance.get(), 0.5f, 1319707555));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_birch"), (Structure)VILLAGE_BIRCH.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSVillagesConfig.birchVillageMaxChunkDistance.get(), 0.5f, 1102567365));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_dark_oak"), (Structure)VILLAGE_DARK_FOREST.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSVillagesConfig.darkForestVillageMaxChunkDistance.get(), 0.5f, 1921339358));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_jungle"), (Structure)VILLAGE_JUNGLE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSVillagesConfig.jungleVillageMaxChunkDistance.get(), 0.5f, 1229975218));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_swamp"), (Structure)VILLAGE_SWAMP.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSVillagesConfig.swampVillageMaxChunkDistance.get(), 0.5f, 1559650945));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_mountains"), (Structure)VILLAGE_MOUNTAINS.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSVillagesConfig.mountainsVillageMaxChunkDistance.get(), 0.5f, 2010875989));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_giant_taiga"), (Structure)VILLAGE_GIANT_TAIGA.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSVillagesConfig.giantTaigaVillageMaxChunkDistance.get(), 0.5f, 1559528842));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_crimson"), (Structure)VILLAGE_CRIMSON.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSVillagesConfig.crimsonVillageMaxChunkDistance.get(), 0.5f, 1854750198));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_warped"), (Structure)VILLAGE_WARPED.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSVillagesConfig.warpedVillageMaxChunkDistance.get(), 0.5f, 1298332136));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_oak"), (Structure)VILLAGE_OAK.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSVillagesConfig.oakVillageMaxChunkDistance.get(), 0.5f, 2112891039));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_mushroom"), (Structure)VILLAGE_MUSHROOM.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSVillagesConfig.villageMushroomAverageChunkDistance.get(), 0.5f, 1150624897));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "ruined_portal_end"), (Structure)RUINED_PORTAL_END.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSRuinedPortalsConfig.ruinedPortalEndMaxChunkDistance.get(), 0.5f, 532404086));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "ruins_nether"), (Structure)RUINS_NETHER.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSRuinsConfig.ruinsNetherMaxChunkDistance.get(), 0.5f, 1336047555));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "ruins_land_warm"), (Structure)RUINS_LAND_WARM.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSRuinsConfig.ruinsLandWarmMaxChunkDistance.get(), 0.25f, 18646107));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "ruins_land_hot"), (Structure)RUINS_LAND_HOT.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSRuinsConfig.ruinsLandHotMaxChunkDistance.get(), 0.25f, 1243670027));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "city_nether"), (Structure)CITY_NETHER.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSCitiesConfig.citiesNetherMaxChunkDistance.get(), 0.5f, 2082652405));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mansion_birch"), (Structure)MANSION_BIRCH.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSMansionsConfig.mansionBirchMaxChunkDistance.get(), 0.5f, 182367035));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mansion_jungle"), (Structure)MANSION_JUNGLE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSMansionsConfig.mansionJungleMaxChunkDistance.get(), 0.5f, 1267916621));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mansion_oak"), (Structure)MANSION_OAK.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSMansionsConfig.mansionOakMaxChunkDistance.get(), 0.5f, 147853731));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mansion_savanna"), (Structure)MANSION_SAVANNA.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSMansionsConfig.mansionSavannaMaxChunkDistance.get(), 0.5f, 2024558925));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mansion_taiga"), (Structure)MANSION_TAIGA.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSMansionsConfig.mansionTaigaMaxChunkDistance.get(), 0.5f, 418506505));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mansion_desert"), (Structure)MANSION_DESERT.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSMansionsConfig.mansionDesertMaxChunkDistance.get(), 0.5f, 724317387));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mansion_snowy"), (Structure)MANSION_SNOWY.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSMansionsConfig.mansionSnowyMaxChunkDistance.get(), 0.5f, 1115107889));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "witch_hut_oak"), (Structure)WITCH_HUTS_OAK.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSWitchHutsConfig.witchHutsOakMaxChunkDistance.get(), 0.5f, 741641348));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "witch_hut_taiga"), (Structure)WITCH_HUTS_TAIGA.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSWitchHutsConfig.witchHutsTaigaMaxChunkDistance.get(), 0.5f, 1925189659));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "witch_hut_birch"), (Structure)WITCH_HUTS_BIRCH.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSWitchHutsConfig.witchHutsBirchMaxChunkDistance.get(), 0.5f, 904634508));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "witch_hut_dark_forest"), (Structure)WITCH_HUTS_DARK_FOREST.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSWitchHutsConfig.witchHutsDarkForestMaxChunkDistance.get(), 0.5f, 165100151));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "witch_hut_giant_tree_taiga"), (Structure)WITCH_HUTS_GIANT_TREE_TAIGA.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSWitchHutsConfig.witchHutsGiantTreeTaigaMaxChunkDistance.get(), 0.5f, 200289401));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "bastion_underground"), (Structure)BASTION_UNDERGROUND.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, RSStructures.createSpacingAndSalt(RepurposedStructures.RSBastionsConfig.bastionUndergroundMaxChunkDistance.get(), 0.5f, 1359301629));
        RSStructurePieces.registerStructurePieces();
    }

    private static StructureSeparationSettings createSpacingAndSalt(int averageSpacing, float percentageForMinSpacing, int salt) {
        return new StructureSeparationSettings(averageSpacing, (int)((float)averageSpacing * percentageForMinSpacing), salt);
    }

    public static <F extends Structure<NoFeatureConfig>> void addToTerraformingAndStructureMaps(ResourceLocation resourceLocation, F structure, GenerationStage.Decoration stage, StructureSeparationSettings StructureSeparationSettings2) {
        Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        RSStructures.addToStructureMaps(resourceLocation, structure, stage, StructureSeparationSettings2);
    }

    public static <C extends IFeatureConfig, F extends Structure<C>> void addToStructureMaps(ResourceLocation resourceLocation, F structure, GenerationStage.Decoration stage, StructureSeparationSettings structureSeparationSettings, C config) {
        Structure.field_236365_a_.put((Object)resourceLocation.toString().toLowerCase(Locale.ROOT), structure);
        Structure.field_236385_u_.put(structure, stage);
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        FlatGenerationSettings.field_202247_j.put(structure, structure.func_236391_a_(config));
        RS_STRUCTURES.put(structure, structureSeparationSettings);
    }

    public static <F extends Structure<NoFeatureConfig>> void addToStructureMaps(ResourceLocation resourceLocation, F structure, GenerationStage.Decoration stage, StructureSeparationSettings structureSeparationSettings) {
        Structure.field_236365_a_.put((Object)resourceLocation.toString().toLowerCase(Locale.ROOT), structure);
        Structure.field_236385_u_.put(structure, stage);
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        FlatGenerationSettings.field_202247_j.put(structure, structure.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        RS_STRUCTURES.put(structure, structureSeparationSettings);
    }
}

