/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.configs;

import com.telepathicgrunt.repurposedstructures.utils.ConfigHelper;
import net.minecraftforge.common.ForgeConfigSpec;

public class RSMansionsConfig {

    public static class RSMansionsConfigValues {
        public ConfigHelper.ConfigValueListener<Boolean> pillarOnlyToLand;
        public ConfigHelper.ConfigValueListener<Integer> mansionJungleMaxChunkDistance;
        public ConfigHelper.ConfigValueListener<Integer> mansionBirchMaxChunkDistance;
        public ConfigHelper.ConfigValueListener<Integer> mansionOakMaxChunkDistance;
        public ConfigHelper.ConfigValueListener<Integer> mansionSavannaMaxChunkDistance;
        public ConfigHelper.ConfigValueListener<Integer> mansionTaigaMaxChunkDistance;
        public ConfigHelper.ConfigValueListener<Integer> mansionDesertMaxChunkDistance;
        public ConfigHelper.ConfigValueListener<Integer> mansionSnowyMaxChunkDistance;

        public RSMansionsConfigValues(ForgeConfigSpec.Builder builder, ConfigHelper.Subscriber subscriber) {
            this.pillarOnlyToLand = subscriber.subscribe(builder.comment(new String[]{"\n Only make supports downward if there is land below.", " (Helps make structure look better in floating island worlds instead of support going down to void at world bottom)"}).translation("repurposedstructures.config.mansions.mansionbirchmaxchunkdistance").define("pillarOnlyToLand", true));
            this.mansionBirchMaxChunkDistance = subscriber.subscribe(builder.comment(new String[]{"\n Add Birch Mansions to modded Birch biomes.", " 1 for spawning in most chunks and 1001 for none."}).translation("repurposedstructures.config.mansions.mansionbirchmaxchunkdistance").defineInRange("mansionBirchMaxChunkDistance", 180, 1, 1001));
            this.mansionJungleMaxChunkDistance = subscriber.subscribe(builder.comment(new String[]{"\n Add Jungle Mansions to modded Jungle biomes.", " 1 for spawning in most chunks and 1001 for none."}).translation("repurposedstructures.config.mansions.mansionjunglemaxchunkdistance").defineInRange("mansionJungleMaxChunkDistance", 225, 1, 1001));
            this.mansionOakMaxChunkDistance = subscriber.subscribe(builder.comment(new String[]{"\n Add Oak Mansions to modded forest category biomes that are not birch or dark forest.", " 1 for spawning in most chunks and 1001 for none."}).translation("repurposedstructures.config.mansions.mansionoakmaxchunkdistance").defineInRange("mansionOakMaxChunkDistance", 205, 1, 1001));
            this.mansionSavannaMaxChunkDistance = subscriber.subscribe(builder.comment(new String[]{"\n Add Savanna Mansions to modded Savanna biomes.", " 1 for spawning in most chunks and 1001 for none."}).translation("repurposedstructures.config.mansions.mansionsavannamaxchunkdistance").defineInRange("mansionSavannaMaxChunkDistance", 225, 1, 1001));
            this.mansionTaigaMaxChunkDistance = subscriber.subscribe(builder.comment(new String[]{"\n Add Taiga Mansions to modded non-snowy Taiga biomes.", " 1 for spawning in most chunks and 1001 for none."}).translation("repurposedstructures.config.mansions.mansiontaigamaxchunkdistance").defineInRange("mansionTaigaMaxChunkDistance", 205, 1, 1001));
            this.mansionDesertMaxChunkDistance = subscriber.subscribe(builder.comment(new String[]{"\n Add Desert Mansions to modded Desert biomes.", " 1 for spawning in most chunks and 1001 for none."}).translation("repurposedstructures.config.mansions.mansiondesertmaxchunkdistance").defineInRange("mansionDesertMaxChunkDistance", 225, 1, 1001));
            this.mansionSnowyMaxChunkDistance = subscriber.subscribe(builder.comment(new String[]{"\n Add Snowy Mansions to modded Snowy biomes.", " 1 for spawning in most chunks and 1001 for none."}).translation("repurposedstructures.config.mansions.mansionsnowymaxchunkdistance").defineInRange("mansionSnowyMaxChunkDistance", 225, 1, 1001));
        }
    }
}

