/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility;

import com.infinityraider.infinitylib.InfinityLib;
import java.lang.reflect.Field;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class EntityHelper {
    private static final Field goalsField = EntityHelper.initGoalsField();
    private static final Field priorityField = EntityHelper.initPriorityField();

    public static boolean injectGoal(MobEntity entity, Goal goal, int priority) {
        if (EntityHelper.incrementPriorities(entity.field_70714_bg, priority)) {
            entity.field_70714_bg.func_75776_a(priority, goal);
            return true;
        }
        return false;
    }

    private static boolean incrementPriorities(GoalSelector selector, int priority) {
        if (goalsField == null) {
            InfinityLib.instance.getLogger().error("Could not increment priorities, goals field not retrieved", new Object[0]);
            return false;
        }
        if (priorityField == null) {
            InfinityLib.instance.getLogger().error("Could not increment priorities, priority field not retrieved", new Object[0]);
            return false;
        }
        try {
            Set goals = (Set)goalsField.get(selector);
            return goals.stream().filter(goal -> goal.func_220770_h() >= priority).allMatch(goal -> {
                try {
                    priorityField.set(goal, (Integer)priorityField.get(goal) + 1);
                    return true;
                }
                catch (Exception e) {
                    InfinityLib.instance.getLogger().error("Failed to increment priority", new Object[0]);
                    InfinityLib.instance.getLogger().printStackTrace(e);
                    return false;
                }
            });
        }
        catch (Exception e) {
            InfinityLib.instance.getLogger().error("Encountered error while getting the goals from the GoalSelector", new Object[0]);
            InfinityLib.instance.getLogger().printStackTrace(e);
            return false;
        }
    }

    @Nullable
    private static Field initGoalsField() {
        try {
            return ObfuscationReflectionHelper.findField(GoalSelector.class, (String)"field_220892_d");
        }
        catch (Exception e) {
            InfinityLib.instance.getLogger().error("Could not retrieve Goals field from GoalSelector.class", new Object[0]);
            InfinityLib.instance.getLogger().printStackTrace(e);
            return null;
        }
    }

    private static Field initPriorityField() {
        try {
            Field field = ObfuscationReflectionHelper.findField(PrioritizedGoal.class, (String)"field_220775_b");
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            return field;
        }
        catch (Exception e) {
            InfinityLib.instance.getLogger().error("Could not retrieve Priority field from PrioritizedGoal.class", new Object[0]);
            InfinityLib.instance.getLogger().printStackTrace(e);
            return null;
        }
    }
}

