/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.infinityraider.infinitylib.utility.Combinatorics;
import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;

public class DirectionalConnectivity
implements Comparable<DirectionalConnectivity> {
    public static final List<DirectionalConnectivity>[] MAP = DirectionalConnectivity.init();
    public static final DirectionalConnectivity NONE = MAP[0].get(0);
    public static final Set<DirectionalConnectivity> ALL = Arrays.stream(MAP).flatMap(Collection::stream).collect(Collectors.toSet());
    private final Set<Direction> connections;
    private final Function<Direction, DirectionalConnectivity> adds;
    private final Function<Direction, DirectionalConnectivity> removes;
    private final int order;
    private final String id;

    public static Optional<DirectionalConnectivity> fromString(String string) {
        String[] split = string.split("_");
        int connections = split.length;
        int counter = 0;
        for (String text : split) {
            Direction dir = Direction.func_176739_a((String)text);
            if (dir == null) {
                --connections;
                continue;
            }
            counter += dir.func_176745_a();
        }
        int order = counter;
        return MAP[connections].stream().filter(c -> c.order == order).findFirst();
    }

    private DirectionalConnectivity(Set<Direction> connections, Function<Direction, DirectionalConnectivity> adds, Function<Direction, DirectionalConnectivity> removes) {
        this.connections = ImmutableSet.copyOf(connections);
        this.adds = adds;
        this.removes = removes;
        int order = 0;
        StringBuilder builder = new StringBuilder();
        for (Direction dir : this.connections) {
            order += dir.func_176745_a();
            builder.append(dir.name() + "_");
        }
        builder.deleteCharAt(builder.length() - 1);
        this.order = order;
        this.id = builder.toString();
    }

    @Override
    public int compareTo(DirectionalConnectivity o) {
        int d = this.connections() - o.connections();
        return d == 0 ? this.order - o.order : d;
    }

    public String toString() {
        return this.id;
    }

    public boolean isConnected(Direction direction) {
        return this.connections.contains(direction);
    }

    public int connections() {
        return this.connections.size();
    }

    public DirectionalConnectivity toggleConnection(Direction dir) {
        if (this.isConnected(dir)) {
            return this.addConnection(dir);
        }
        return this.removeConnection(dir);
    }

    public DirectionalConnectivity addConnection(Direction dir) {
        return this.isConnected(dir) ? this : this.adds.apply(dir);
    }

    public DirectionalConnectivity removeConnection(Direction dir) {
        return this.isConnected(dir) ? this.removes.apply(dir) : this;
    }

    private static List<DirectionalConnectivity>[] init() {
        int i;
        List<Builder>[] nodes = Combinatorics.combineAsObject(Direction.values().length, array -> new Builder().addDirections(array));
        for (int i2 = 0; i2 < nodes.length - 1; ++i2) {
            List<Builder> forwards = nodes[i2 + 1];
            nodes[0].forEach(builder -> DirectionalConnectivity.linkForwards(builder, forwards));
        }
        List[] connections = new List[nodes.length];
        for (i = 0; i < nodes.length; ++i) {
            connections[i] = nodes[i].stream().map(rec$ -> ((Builder)rec$).build()).collect(Collectors.toList());
        }
        for (i = 0; i < nodes.length; ++i) {
            nodes[i].stream().forEach(rec$ -> ((Builder)rec$).clean());
        }
        return connections;
    }

    private static void linkForwards(Builder builder, List<Builder> forwards) {
        for (Direction direction : Direction.values()) {
            if (builder.hasConnection(direction)) continue;
            for (Builder forward : forwards) {
                if (!forward.hasConnection(direction)) continue;
                builder.linkForwards(forward, direction);
            }
        }
    }

    private static class Builder {
        private final Set<Direction> connections = Sets.newEnumSet(Collections.emptyList(), Direction.class);
        private final Map<Direction, Either<Builder, DirectionalConnectivity>> adds = Maps.newEnumMap(Direction.class);
        private final Map<Direction, Either<Builder, DirectionalConnectivity>> removes = Maps.newEnumMap(Direction.class);
        private DirectionalConnectivity built;

        private Builder() {
            Arrays.stream(Direction.values()).forEach(dir -> {
                this.adds.put((Direction)dir, (Either<Builder, DirectionalConnectivity>)Either.left((Object)this));
                this.removes.put((Direction)dir, (Either<Builder, DirectionalConnectivity>)Either.left((Object)this));
            });
        }

        private DirectionalConnectivity build() {
            if (this.isBuilt()) {
                this.built = new DirectionalConnectivity(this.connections, dir -> (DirectionalConnectivity)this.adds.get(dir).map(Builder::build, d -> d), dir -> (DirectionalConnectivity)this.removes.get(dir).map(Builder::build, d -> d));
            }
            return this.built;
        }

        private boolean isBuilt() {
            return this.built != null;
        }

        private boolean hasConnection(Direction direction) {
            return this.connections.contains(direction);
        }

        private Builder addDirections(int[] ordinals) {
            Arrays.stream(ordinals).forEach(this::addDirection);
            return this;
        }

        private Builder addDirection(int ordinal) {
            return this.addDirection(Direction.func_82600_a((int)ordinal));
        }

        private Builder addDirection(Direction connection) {
            this.connections.add(connection);
            this.adds.put(connection, (Either<Builder, DirectionalConnectivity>)Either.left((Object)this));
            return this;
        }

        private Builder linkForwards(Builder other, Direction direction) {
            this.adds.put(direction, (Either<Builder, DirectionalConnectivity>)Either.left((Object)other));
            other.removes.put(direction, (Either<Builder, DirectionalConnectivity>)Either.left((Object)this));
            return this;
        }

        private void clean() {
            Builder.cleanMap(this.adds);
            Builder.cleanMap(this.removes);
        }

        private static void cleanMap(Map<Direction, Either<Builder, DirectionalConnectivity>> map) {
            map.entrySet().stream().filter(e -> ((Either)e.getValue()).left().map(Builder::isBuilt).orElse(false)).map(e -> ((Either)e.getValue()).left().map(b -> new Tuple(e, b))).filter(Optional::isPresent).map(Optional::get).forEach(t -> ((Map.Entry)t.func_76341_a()).setValue(Either.right((Object)((Builder)t.func_76340_b()).build())));
        }
    }
}

