/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.model;

import com.google.common.collect.Sets;
import com.infinityraider.infinitylib.render.model.InfModelLoader;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.geometry.IModelGeometry;

@OnlyIn(value=Dist.CLIENT)
public class ModelLoaderRegistrar {
    private static final ModelLoaderRegistrar INSTANCE = new ModelLoaderRegistrar();
    private final Set<InfModelLoader<?>> loaders = Sets.newConcurrentHashSet();

    public static final ModelLoaderRegistrar getInstance() {
        return INSTANCE;
    }

    private ModelLoaderRegistrar() {
    }

    public <T extends IModelGeometry<T>> void registerModelLoader(InfModelLoader<T> loader) {
        this.loaders.add(loader);
    }

    public final void registerModelLoaders(ModelRegistryEvent event) {
        this.loaders.forEach(loader -> ModelLoaderRegistry.registerLoader((ResourceLocation)loader.getId(), (IModelLoader)loader));
    }
}

