/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.proxy.base;

import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.capability.CapabilityHandler;
import com.infinityraider.infinitylib.capability.ICapabilityImplementation;
import com.infinityraider.infinitylib.config.ConfigurationHandler;
import com.infinityraider.infinitylib.modules.dynamiccamera.IDynamicCameraController;
import com.infinityraider.infinitylib.sound.SidedSoundDelegate;
import com.infinityraider.infinitylib.sound.SoundDelegateServer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;

public interface IProxyBase<C extends ConfigurationHandler.SidedModConfig> {
    public Function<ForgeConfigSpec.Builder, C> getConfigConstructor();

    public void registerEventHandlers();

    public void activateRequiredModules();

    public void registerCapabilities();

    default public void registerFMLEventHandlers(IEventBus bus) {
    }

    default public void registerEventHandler(Object handler) {
        InfinityLib.instance.getLogger().debug("Registering event handler: " + handler.getClass().getName(), new Object[0]);
        MinecraftForge.EVENT_BUS.register(handler);
    }

    default public void registerCapability(ICapabilityImplementation capability) {
        CapabilityHandler.getInstance().registerCapability(capability);
    }

    default public void onCommonSetupEvent(FMLCommonSetupEvent event) {
    }

    default public void onClientSetupEvent(FMLClientSetupEvent event) {
    }

    default public void onDedicatedServerSetupEvent(FMLDedicatedServerSetupEvent event) {
    }

    default public void onInterModEnqueueEvent(InterModEnqueueEvent event) {
    }

    default public void onInterModProcessEvent(InterModProcessEvent event) {
    }

    default public void onModLoadCompleteEvent(FMLLoadCompleteEvent event) {
    }

    default public void onServerStartingEvent(FMLServerStartingEvent event) {
    }

    default public void onServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
    }

    default public void onServerStoppingEvent(FMLServerStoppingEvent event) {
    }

    default public void onServerStoppedEvent(FMLServerStoppedEvent event) {
    }

    default public Dist getPhysicalSide() {
        return FMLEnvironment.dist;
    }

    default public LogicalSide getLogicalSide() {
        return EffectiveSide.get();
    }

    default public MinecraftServer getMinecraftServer() {
        return (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
    }

    public PlayerEntity getClientPlayer();

    public World getClientWorld();

    default public Entity getEntityById(World world, int id) {
        return world == null ? null : world.func_73045_a(id);
    }

    default public Entity getEntityById(RegistryKey<World> dimension, int id) {
        return this.getEntityById(this.getWorldFromDimension(dimension), id);
    }

    @Nullable
    default public Entity getRenderViewEntity() {
        return null;
    }

    default public void setRenderViewEntity(Entity entity) {
    }

    public World getWorldFromDimension(RegistryKey<World> var1);

    default public SidedSoundDelegate getSoundDelegate() {
        return new SoundDelegateServer();
    }

    default public double getFieldOfView() {
        return 70.0;
    }

    default public void queueTask(Runnable task) {
        this.getMinecraftServer().func_212871_a_((Runnable)new TickDelayedTask(this.getMinecraftServer().func_71259_af() + 1, task));
    }

    default public Item.Properties setItemRenderer(Item.Properties properties) {
        return properties;
    }

    default public boolean toggleDynamicCamera(IDynamicCameraController controller, boolean status) {
        return false;
    }
}

