/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.network.serialization;

import com.google.common.collect.Sets;
import com.infinityraider.infinitylib.network.serialization.IMessageReader;
import com.infinityraider.infinitylib.network.serialization.IMessageSerializer;
import com.infinityraider.infinitylib.network.serialization.IMessageWriter;
import com.infinityraider.infinitylib.network.serialization.MessageSerializerArray;
import com.infinityraider.infinitylib.network.serialization.MessageSerializerEnum;
import com.infinityraider.infinitylib.network.serialization.MessageSerializerGeneric;
import com.infinityraider.infinitylib.network.serialization.MessageSerializerSubClass;
import com.infinityraider.infinitylib.network.serialization.PacketBufferUtil;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;

public final class MessageSerializerStore {
    private static final Set<IMessageSerializer> SERIALIZERS = Sets.newHashSet();

    public static <T> Optional<IMessageSerializer<T>> getMessageSerializer(Class<T> clazz) {
        for (IMessageSerializer serializer : SERIALIZERS) {
            if (!serializer.accepts(clazz)) continue;
            return Optional.of(serializer);
        }
        return Optional.empty();
    }

    public static <T> void registerMessageSerializer(Class<T> clazz, IMessageWriter<T> writer, IMessageReader<T> reader) {
        MessageSerializerStore.registerMessageSerializer(MessageSerializerGeneric.createSerializer(clazz, writer, reader));
    }

    public static <T> void registerMessageSerializer(IMessageSerializer<T> serializer) {
        SERIALIZERS.add(serializer);
    }

    static {
        MessageSerializerStore.registerMessageSerializer(Boolean.TYPE, PacketBufferUtil::writeBoolean, PacketBufferUtil::readBoolean);
        MessageSerializerStore.registerMessageSerializer(Boolean.class, PacketBufferUtil::writeBoolean, PacketBufferUtil::readBoolean);
        MessageSerializerStore.registerMessageSerializer(Byte.TYPE, PacketBufferUtil::writeByte, PacketBufferUtil::readByte);
        MessageSerializerStore.registerMessageSerializer(Byte.class, PacketBufferUtil::writeByte, PacketBufferUtil::readByte);
        MessageSerializerStore.registerMessageSerializer(Short.TYPE, PacketBufferUtil::writeShort, PacketBufferUtil::readShort);
        MessageSerializerStore.registerMessageSerializer(Short.class, PacketBufferUtil::writeShort, PacketBufferUtil::readShort);
        MessageSerializerStore.registerMessageSerializer(Integer.TYPE, PacketBufferUtil::writeInt, PacketBufferUtil::readInt);
        MessageSerializerStore.registerMessageSerializer(Integer.class, PacketBufferUtil::writeInt, PacketBufferUtil::readInt);
        MessageSerializerStore.registerMessageSerializer(Long.TYPE, PacketBufferUtil::writeLong, PacketBufferUtil::readLong);
        MessageSerializerStore.registerMessageSerializer(Long.class, PacketBufferUtil::writeLong, PacketBufferUtil::readLong);
        MessageSerializerStore.registerMessageSerializer(Float.TYPE, PacketBufferUtil::writeFloat, PacketBufferUtil::readFloat);
        MessageSerializerStore.registerMessageSerializer(Float.class, PacketBufferUtil::writeFloat, PacketBufferUtil::readFloat);
        MessageSerializerStore.registerMessageSerializer(Double.TYPE, PacketBufferUtil::writeDouble, PacketBufferUtil::readDouble);
        MessageSerializerStore.registerMessageSerializer(Double.class, PacketBufferUtil::writeDouble, PacketBufferUtil::readDouble);
        MessageSerializerStore.registerMessageSerializer(Character.TYPE, PacketBufferUtil::writeChar, PacketBufferUtil::readChar);
        MessageSerializerStore.registerMessageSerializer(Character.class, PacketBufferUtil::writeChar, PacketBufferUtil::readChar);
        MessageSerializerStore.registerMessageSerializer(String.class, PacketBufferUtil::writeString, PacketBufferUtil::readString);
        MessageSerializerStore.registerMessageSerializer(Entity.class, PacketBufferUtil::writeEntity, PacketBufferUtil::readEntity);
        MessageSerializerStore.registerMessageSerializer(TileEntity.class, PacketBufferUtil::writeTileEntity, PacketBufferUtil::readTileEntity);
        MessageSerializerStore.registerMessageSerializer(BlockPos.class, PacketBufferUtil::writeBlockPos, PacketBufferUtil::readBlockPos);
        MessageSerializerStore.registerMessageSerializer(Block.class, PacketBufferUtil::writeBlock, PacketBufferUtil::readBlock);
        MessageSerializerStore.registerMessageSerializer(Item.class, PacketBufferUtil::writeItem, PacketBufferUtil::readItem);
        MessageSerializerStore.registerMessageSerializer(ItemStack.class, PacketBufferUtil::writeItemStack, PacketBufferUtil::readItemStack);
        MessageSerializerStore.registerMessageSerializer(CompoundNBT.class, PacketBufferUtil::writeNBT, PacketBufferUtil::readNBT);
        MessageSerializerStore.registerMessageSerializer(Vector3d.class, PacketBufferUtil::writeVec3d, PacketBufferUtil::readVec3d);
        MessageSerializerStore.registerMessageSerializer(ITextComponent.class, PacketBufferUtil::writeTextComponent, PacketBufferUtil::readTextComponent);
        MessageSerializerStore.registerMessageSerializer(RegistryKey.class, PacketBufferUtil::writeRegistryKey, PacketBufferUtil::readRegistryKey);
        MessageSerializerStore.registerMessageSerializer(MessageSerializerEnum.INSTANCE);
        MessageSerializerStore.registerMessageSerializer(MessageSerializerSubClass.TILE_ENTITY);
        MessageSerializerStore.registerMessageSerializer(MessageSerializerSubClass.ENTITY);
        MessageSerializerStore.registerMessageSerializer(MessageSerializerSubClass.BLOCK);
        MessageSerializerStore.registerMessageSerializer(MessageSerializerSubClass.ITEM);
        MessageSerializerStore.registerMessageSerializer(MessageSerializerSubClass.TEXT);
        MessageSerializerStore.registerMessageSerializer(MessageSerializerArray.INSTANCE);
    }
}

