/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.Eidolon;
import elucent.eidolon.Registry;
import elucent.eidolon.particle.Particles;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class RitualConsumePacket {
    BlockPos src;
    BlockPos dst;
    float r;
    float g;
    float b;

    public RitualConsumePacket(BlockPos src, BlockPos dst, float r, float g, float b) {
        this.src = src;
        this.dst = dst;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public static void encode(RitualConsumePacket object, PacketBuffer buffer) {
        buffer.func_179255_a(object.src).func_179255_a(object.dst);
        buffer.writeFloat(object.r).writeFloat(object.g).writeFloat(object.b);
    }

    public static RitualConsumePacket decode(PacketBuffer buffer) {
        return new RitualConsumePacket(buffer.func_179259_c(), buffer.func_179259_c(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    public static void consume(RitualConsumePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            World world = Eidolon.proxy.getWorld();
            if (world != null) {
                BlockPos src = packet.src;
                BlockPos dst = packet.dst;
                world.func_184148_a(Eidolon.proxy.getPlayer(), (double)src.func_177958_n() + 0.5, (double)src.func_177956_o() + 0.5, (double)src.func_177952_p() + 0.5, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 1.0f, 1.0f);
                for (int i = 0; i < 10; ++i) {
                    Particles.create(Registry.LINE_WISP_PARTICLE).setAlpha(0.75f, 0.0f).setScale(0.25f + 0.125f * world.field_73012_v.nextFloat(), 0.0f).setLifetime(16 + world.field_73012_v.nextInt(4)).randomOffset(0.375, 0.375).randomVelocity(0.125, 0.125).addVelocity((double)dst.func_177958_n() + 0.5, dst.func_177956_o() + 1, (double)dst.func_177952_p() + 0.5).setColor(packet.r, packet.g, packet.b, packet.r, packet.g * 0.5f, packet.b * 1.5f).spawn(world, (double)src.func_177958_n() + 0.5, (double)src.func_177956_o() + 0.5, (double)src.func_177952_p() + 0.5);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

