/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.Eidolon;
import elucent.eidolon.capability.KnowledgeProvider;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class KnowledgeUpdatePacket {
    UUID uuid;
    CompoundNBT tag;
    boolean playSound;

    public KnowledgeUpdatePacket(UUID uuid, CompoundNBT tag, boolean playSound) {
        this.uuid = uuid;
        this.tag = tag;
        this.playSound = playSound;
    }

    public KnowledgeUpdatePacket(PlayerEntity entity, boolean playSound) {
        this.uuid = entity.func_110124_au();
        entity.getCapability(KnowledgeProvider.CAPABILITY, null).ifPresent(k -> {
            this.tag = (CompoundNBT)KnowledgeProvider.CAPABILITY.getStorage().writeNBT(KnowledgeProvider.CAPABILITY, k, null);
        });
        this.playSound = playSound;
    }

    public static void encode(KnowledgeUpdatePacket object, PacketBuffer buffer) {
        buffer.func_179252_a(object.uuid);
        buffer.func_150786_a(object.tag);
        buffer.writeBoolean(object.playSound);
    }

    public static KnowledgeUpdatePacket decode(PacketBuffer buffer) {
        return new KnowledgeUpdatePacket(buffer.func_179253_g(), buffer.func_150793_b(), buffer.readBoolean());
    }

    public static void consume(KnowledgeUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            World world = Eidolon.proxy.getWorld();
            PlayerEntity player = world.func_217371_b(packet.uuid);
            if (player != null) {
                player.getCapability(KnowledgeProvider.CAPABILITY, null).ifPresent(k -> {
                    KnowledgeProvider.CAPABILITY.getStorage().readNBT(KnowledgeProvider.CAPABILITY, k, null, (INBT)packet.tag);
                    if (packet.playSound) {
                        player.func_184185_a(SoundEvents.field_187802_ec, 1.0f, 0.5f);
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

