/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.entity;

import elucent.eidolon.Registry;
import elucent.eidolon.network.Networking;
import elucent.eidolon.network.SpellCastPacket;
import elucent.eidolon.particle.SignParticleData;
import elucent.eidolon.spell.Sign;
import elucent.eidolon.spell.Signs;
import elucent.eidolon.spell.Spell;
import elucent.eidolon.spell.Spells;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ChantCasterEntity
extends Entity {
    public static final DataParameter<CompoundNBT> SIGNS = EntityDataManager.func_187226_a(ChantCasterEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    public static final DataParameter<Integer> INDEX = EntityDataManager.func_187226_a(ChantCasterEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Optional<UUID>> CASTER_ID = EntityDataManager.func_187226_a(ChantCasterEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    int timer = 0;

    public ChantCasterEntity(World world, PlayerEntity caster, List<Sign> signs) {
        super((EntityType)Registry.CHANT_CASTER.get(), world);
        ListNBT list = new ListNBT();
        for (Sign sign : signs) {
            list.add((Object)StringNBT.func_229705_a_((String)sign.getRegistryName().toString()));
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("signs", (INBT)list);
        this.func_184212_Q().func_187227_b(SIGNS, (Object)nbt);
        this.func_184212_Q().func_187227_b(CASTER_ID, Optional.of(caster.func_110124_au()));
    }

    public ChantCasterEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(SIGNS, (Object)new CompoundNBT());
        this.func_184212_Q().func_187214_a(INDEX, (Object)0);
        this.func_184212_Q().func_187214_a(CASTER_ID, Optional.empty());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.timer > 0) {
            --this.timer;
            if (this.timer == 0) {
                ListNBT signData = ((CompoundNBT)this.func_184212_Q().func_187225_a(SIGNS)).func_150295_c("signs", 8);
                Optional optuuid = (Optional)this.func_184212_Q().func_187225_a(CASTER_ID);
                if (!this.field_70170_p.field_72995_K && optuuid.isPresent()) {
                    ArrayList<Sign> signs = new ArrayList<Sign>();
                    for (int i = 0; i < signData.size(); ++i) {
                        signs.add(Signs.find(new ResourceLocation(signData.func_150307_f(i))));
                    }
                    Spell spell = Spells.find(signs);
                    PlayerEntity player = this.field_70170_p.func_217371_b((UUID)optuuid.get());
                    if (spell != null && player != null && spell.canCast(this.field_70170_p, this.func_233580_cy_(), player, signs)) {
                        spell.cast(this.field_70170_p, this.func_233580_cy_(), player, signs);
                        Networking.sendToTracking(this.field_70170_p, this.func_233580_cy_(), new SpellCastPacket(player, this.func_233580_cy_(), spell, signs));
                    } else {
                        this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_187646_bt, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    }
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.func_241204_bJ_();
                }
                return;
            }
        }
        if (this.field_70173_aa % 5 == 0) {
            ListNBT signs = ((CompoundNBT)this.func_184212_Q().func_187225_a(SIGNS)).func_150295_c("signs", 8);
            int index = (Integer)this.func_184212_Q().func_187225_a(INDEX);
            if (index >= signs.size()) {
                return;
            }
            Sign sign = Signs.find(new ResourceLocation(signs.func_150307_f(index)));
            double x = this.func_226277_ct_() + 0.2 * this.field_70146_Z.nextGaussian();
            double y = this.func_226278_cu_() + 0.2 * this.field_70146_Z.nextGaussian();
            double z = this.func_226281_cx_() + 0.2 * this.field_70146_Z.nextGaussian();
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)new SignParticleData(sign), x, y, z, 0.0, 0.0, 0.0);
            }
            this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)Registry.CHANT_WORD.get(), SoundCategory.NEUTRAL, 0.7f, this.field_70146_Z.nextFloat() * 0.375f + 0.625f);
            if (index + 1 >= signs.size()) {
                this.timer = 40;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_184212_Q().func_187227_b(INDEX, (Object)(index + 1));
            }
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.func_184212_Q().func_187227_b(SIGNS, (Object)compound.func_74775_l("signs_tag"));
        this.func_184212_Q().func_187227_b(INDEX, (Object)compound.func_74762_e("index"));
        this.func_184212_Q().func_187227_b(CASTER_ID, Optional.of(compound.func_186857_a("caster_id")));
        this.timer = compound.func_74762_e("timer");
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_218657_a("signs_tag", (INBT)this.func_184212_Q().func_187225_a(SIGNS));
        compound.func_74768_a("index", ((Integer)this.func_184212_Q().func_187225_a(INDEX)).intValue());
        compound.func_74768_a("timer", this.timer);
        compound.func_186854_a("caster_id", (UUID)((Optional)this.func_184212_Q().func_187225_a(CASTER_ID)).get());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

