/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.util;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.util.StringBuilderStream;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.SafetyException;
import com.tom.cpm.shared.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ErrorLog {
    private static List<LogEntry> errors = new ArrayList<LogEntry>();

    public static List<LogEntry> collectErrors() {
        List<Player<?, ?>> players = MinecraftClientAccess.get().getDefinitionLoader().getPlayers();
        List<LogEntry> entries = players.stream().map(Player::getModelDefinition0).filter(d -> d != null && d.getError() != null).map(d -> {
            Throwable err = d.getError();
            if (err instanceof SafetyException) {
                return new LogEntry(LogLevel.INFO, new FormatText("label.cpm.error.blockedBySafety", d.getPlayerObj().getName()), err, 0L);
            }
            return new LogEntry(LogLevel.WARNING, new FormatText("label.cpm.error.errorWhileLoading", d.getPlayerObj().getName(), err.toString()), err, 0L);
        }).collect(Collectors.toList());
        entries.addAll(errors);
        return entries;
    }

    public static void addLog(LogLevel lvl, String text) {
        Log.warn(text);
        ErrorLog.addLog0(lvl, text, new Throwable("Caller stacktrace:"));
    }

    public static void addLog(LogLevel lvl, String text, Throwable error) {
        Log.warn(text, error);
        ErrorLog.addLog0(lvl, text, error);
    }

    private static void addLog0(LogLevel lvl, String text, Throwable error) {
        errors.add(new LogEntry(lvl, new FormatText("label.cpm.identity", text), error, System.currentTimeMillis()));
    }

    public static void addFormattedLog(LogLevel lvl, String text, Object ... args) {
        errors.add(new LogEntry(lvl, new FormatText(text, args), new Throwable("Caller stacktrace:"), System.currentTimeMillis()));
    }

    public static void addFormattedLog(LogLevel lvl, String text, Throwable error, Object ... args) {
        errors.add(new LogEntry(lvl, new FormatText(text, args), error, System.currentTimeMillis()));
    }

    public static void clear() {
        errors.clear();
    }

    public static class FormatText {
        private String key;
        private Object[] args;

        public FormatText(String text, Object ... args) {
            this.key = text;
            this.args = args;
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("key", this.key);
            ArrayList<Object> a = new ArrayList<Object>();
            for (int i = 0; i < this.args.length; ++i) {
                Object o = this.args[i];
                if (o instanceof FormatText) {
                    a.add(((FormatText)o).toMap());
                    continue;
                }
                a.add(String.valueOf(o));
            }
            m.put("args", a);
            return m;
        }

        public String toString(IGui gui) {
            Object[] a = new Object[this.args.length];
            for (int i = 0; i < this.args.length; ++i) {
                Object o = this.args[i];
                a[i] = o instanceof FormatText ? ((FormatText)o).toString(gui) : String.valueOf(o);
            }
            return gui.i18nFormat(this.key, a);
        }
    }

    public static enum LogLevel {
        ERROR,
        WARNING,
        INFO;

    }

    public static class LogEntry {
        private LogLevel level;
        private FormatText message;
        private Throwable error;
        private long time;

        public LogEntry(LogLevel level, FormatText name, Throwable error, long time) {
            this.level = level;
            this.message = name;
            this.error = error;
            this.time = time;
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("level", this.level.name());
            m.put("msg", this.message.toMap());
            StringBuilder sb = new StringBuilder();
            this.error.printStackTrace(new StringBuilderStream(sb, "\n"));
            m.put("error", sb.toString());
            m.put("time", Long.toString(this.time, 16));
            return m;
        }

        public LogLevel getLevel() {
            return this.level;
        }

        public FormatText getMessage() {
            return this.message;
        }

        public String toTooltipString(IGui gui, boolean st) {
            String msg;
            if (st) {
                StringBuilder sb = new StringBuilder();
                this.error.printStackTrace(new StringBuilderStream(sb, "\n\t"));
                msg = sb.toString().replace("\t", "   ").replace("\n", "\\");
            } else {
                msg = this.error.toString();
            }
            String lvl = gui.i18nFormat("label.cpm.level." + this.level.name().toLowerCase(), new Object[0]);
            return gui.i18nFormat(st ? "tooltip.cpm.errorLogST" : "tooltip.cpm.errorLog", this.message.toString(gui), lvl, msg);
        }
    }
}

