/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.template.args;

import com.tom.cpl.math.MathHelper;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.template.args.ArgBase;
import java.io.IOException;

public class AngleArg
extends ArgBase {
    private float value;

    @Override
    public String getType() {
        return "angle";
    }

    @Override
    public void write(IOHelper h) throws IOException {
        h.writeShort(MathHelper.clamp((int)(this.value / 360.0f * 65535.0f), 0, 65535));
    }

    @Override
    public void load(IOHelper h) throws IOException {
        this.value = (float)((double)((float)h.readShort() / 65535.0f * 2.0f) * Math.PI);
    }

    @Override
    public Object toJson() {
        return Float.valueOf(this.value);
    }

    @Override
    public void fromJson(Object v) {
        this.value = ((Number)v).floatValue();
    }
}

