/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts;

import com.tom.cpm.shared.config.ResourceLoader;
import com.tom.cpm.shared.definition.Link;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.io.ChecksumInputStream;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart;
import java.io.IOException;
import java.io.InputStream;

public abstract class ModelPartLink
implements IModelPart {
    private Link link;
    private ModelDefinition def;

    public ModelPartLink(IOHelper in, ModelDefinition def) throws IOException {
        this.link = new Link(in);
        this.def = def;
    }

    public ModelPartLink(Link link) {
        this.link = link;
    }

    @Override
    public IResolvedModelPart resolve() throws IOException {
        try (InputStream in = this.def.getLoader().load(this.link, ResourceLoader.ResourceEncoding.BASE64, this.def);){
            if (in.read() != 83) {
                throw new IOException();
            }
            ChecksumInputStream cis = new ChecksumInputStream(in);
            IModelPart part = this.load(new IOHelper(cis), this.def);
            cis.checkSum();
            IResolvedModelPart iResolvedModelPart = part.resolve();
            return iResolvedModelPart;
        }
    }

    protected abstract IModelPart load(IOHelper var1, ModelDefinition var2) throws IOException;

    @Override
    public void write(IOHelper dout) throws IOException {
        this.link.write(dout);
    }

    public String toString() {
        StringBuilder bb = new StringBuilder("Link\n\tPath: ");
        bb.append(this.link);
        return bb.toString();
    }

    public Link getLink() {
        return this.link;
    }
}

