/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.network;

import com.tom.cpl.util.TriConsumer;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.PlayerData;
import com.tom.cpm.shared.io.ModelFile;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class NetHandler<RL, NBT, P, PB, NET> {
    public static final String GET_SKIN = "get_skin";
    public static final String SET_SKIN = "set_skin";
    public static final String HELLO = "hello";
    public static final String SKIN_LAYERS = "layer";
    public static final String SET_SCALE = "set_scl";
    public static final String FORCED_TAG = "forced";
    public static final String DATA_TAG = "data";
    public static final String SCALE_TAG = "scale";
    public static final String FORCED_CHAT_MSG = "chat.cpm.skinForced";
    protected Supplier<PB> newPacketBuffer;
    protected Supplier<NBT> newNbt;
    protected Function<P, UUID> getPlayerUUID;
    protected BiConsumer<PB, NBT> writeCompound;
    protected Function<PB, NBT> readCompound;
    protected TriConsumer<NET, RL, PB> sendPacket;
    protected TriConsumer<P, RL, PB> sendToAllTracking;
    protected BiConsumer<PB, P> writePlayerId;
    protected Function<PB, Object> readPlayerId;
    protected Function<Object, P> getPlayerById;
    protected NBTSetter<NBT, Boolean> setBoolean;
    protected NBTSetter<NBT, byte[]> setByteArray;
    protected NBTSetter<NBT, Float> setFloat;
    protected NBTGetter<NBT, Boolean> getBoolean;
    protected NBTGetter<NBT, byte[]> getByteArray;
    protected NBTGetter<NBT, Float> getFloat;
    protected BiPredicate<NBT, String> contains;
    protected BiConsumer<P, String> sendChat;
    protected BiConsumer<P, Consumer<P>> findTracking;
    protected Function<NET, Executor> executor;
    protected Function<P, Object> playerToLoader;
    protected BiConsumer<P, Float> scaleSetter;
    protected Supplier<P> getClient;
    protected Function<P, NET> getNet;
    protected Function<NET, P> getPlayer;
    public final RL helloPacket;
    public final RL setSkin;
    public final RL getSkin;
    public final RL setLayer;
    public final RL setScale;

    public NetHandler(BiFunction<String, String, RL> keyFactory) {
        this.helloPacket = keyFactory.apply("cpm_net", HELLO);
        this.setSkin = keyFactory.apply("cpm_net", SET_SKIN);
        this.getSkin = keyFactory.apply("cpm_net", GET_SKIN);
        this.setLayer = keyFactory.apply("cpm_net", SKIN_LAYERS);
        this.setScale = keyFactory.apply("cpm_net", SET_SCALE);
    }

    public void onJoin(P player) {
        PB pb = this.newPacketBuffer.get();
        NBT data = this.newNbt.get();
        this.writeCompound.accept(pb, data);
        PlayerData pd = this.newData();
        this.getSNetH(player).cpm$setEncodedModelData(pd);
        this.sendPacket.accept(this.getNet.apply(player), this.helloPacket, pb);
        pd.load(this.getPlayerUUID.apply(player).toString());
    }

    protected PlayerData newData() {
        return new PlayerData();
    }

    public void receiveServer(RL key, PB data, NetH.ServerNetH net) {
        try {
            NetH.ServerNetH from = net;
            P pl = this.getPlayer.apply(from);
            if (key.equals(this.helloPacket)) {
                this.executor.apply(from).execute(() -> {
                    net.cpm$setHasMod(true);
                    this.findTracking.accept(pl, p -> this.sendPlayerData(p, pl));
                    PlayerData pd = net.cpm$getEncodedModelData();
                    if (pd.canChangeModel()) {
                        this.sendPacket.accept(from, this.getSkin, this.newPacketBuffer.get());
                    } else {
                        this.sendPacket.accept(from, this.setSkin, this.writeSkinData(pd, pl));
                    }
                });
            } else if (key.equals(this.setSkin)) {
                PlayerData pd = net.cpm$getEncodedModelData();
                if (pd.canChangeModel()) {
                    NBT tag = this.readCompound.apply(data);
                    this.executor.apply(from).execute(() -> {
                        pd.setModel(this.contains.test(tag, DATA_TAG) ? this.getByteArray.get(tag, DATA_TAG) : null, false, false);
                        this.sendToAllTracking.accept(pl, this.setSkin, this.writeSkinData(pd, pl));
                        pd.save(this.getPlayerUUID.apply(pl).toString());
                    });
                } else {
                    this.sendChat.accept(pl, FORCED_CHAT_MSG);
                }
            } else if (key.equals(this.setScale)) {
                NBT tag = this.readCompound.apply(data);
                float scale = this.getFloat.get(tag, SCALE_TAG).floatValue();
                if (this.scaleSetter != null) {
                    this.scaleSetter.accept(pl, Float.valueOf(scale));
                    net.cpm$getEncodedModelData().scale = scale;
                }
            }
        }
        catch (Throwable e) {
            Log.error("Exception while processing cpm packet", e);
        }
    }

    public void receiveClient(RL key, PB data, NetH net) {
        try {
            NetH from = net;
            if (key.equals(this.helloPacket)) {
                NBT nbt = this.readCompound.apply(data);
                this.executor.apply(from).execute(() -> {
                    net.cpm$setHasMod(true);
                    MinecraftClientAccess.get().getDefinitionLoader().clearServerData();
                    this.sendPacket.accept(from, this.helloPacket, this.newPacketBuffer.get());
                });
            } else if (key.equals(this.setSkin)) {
                Object pl = this.readPlayerId.apply(data);
                NBT tag = this.readCompound.apply(data);
                this.executor.apply(from).execute(() -> {
                    P player = this.getPlayerById.apply(pl);
                    if (player != null) {
                        MinecraftClientAccess.get().getDefinitionLoader().setModel(this.playerToLoader.apply(player), this.contains.test(tag, DATA_TAG) ? this.getByteArray.get(tag, DATA_TAG) : null, this.getBoolean.get(tag, FORCED_TAG));
                    }
                });
            } else if (key.equals(this.getSkin)) {
                this.sendSkinData(from);
            }
        }
        catch (Throwable e) {
            Log.error("Exception while processing cpm packet", e);
        }
    }

    public void sendSkinData() {
        if (this.hasModClient()) {
            this.sendSkinData(this.getClientNet());
        }
    }

    private void sendSkinData(NET pl) {
        String model = ModConfig.getCommonConfig().getString("selectedModel", null);
        if (model != null) {
            File modelsDir = new File(MinecraftClientAccess.get().getGameDir(), "player_models");
            try {
                ModelFile file = ModelFile.load(new File(modelsDir, model));
                PB pb = this.newPacketBuffer.get();
                NBT data = this.newNbt.get();
                this.setByteArray.set(data, DATA_TAG, file.getDataBlock());
                this.writeCompound.accept(pb, data);
                this.sendPacket.accept(pl, this.setSkin, pb);
                file.registerLocalCache(MinecraftClientAccess.get().getDefinitionLoader());
            }
            catch (IOException file) {}
        } else {
            PB pb = this.newPacketBuffer.get();
            NBT data = this.newNbt.get();
            this.writeCompound.accept(pb, data);
            this.sendPacket.accept(pl, this.setSkin, pb);
        }
    }

    public void sendPlayerData(P target, P to) {
        PlayerData dt = this.getSNetH(target).cpm$getEncodedModelData();
        if (dt == null) {
            return;
        }
        this.sendPacket.accept(this.getNet.apply(to), this.setSkin, this.writeSkinData(dt, target));
    }

    private PB writeSkinData(PlayerData dt, P target) {
        PB pb = this.newPacketBuffer.get();
        this.writePlayerId.accept(pb, target);
        NBT data = this.newNbt.get();
        if (dt.data != null) {
            this.setBoolean.set(data, FORCED_TAG, dt.forced);
            this.setByteArray.set(data, DATA_TAG, dt.data);
        }
        this.writeCompound.accept(pb, data);
        return pb;
    }

    public void onCommand(P pl, String skin, boolean force, boolean save) {
        PlayerData pd = this.getSNetH(pl).cpm$getEncodedModelData();
        pd.setModel(skin, force, save);
        if (skin == null) {
            this.sendPacket.accept(this.getNet.apply(pl), this.getSkin, this.newPacketBuffer.get());
        }
        this.sendToAllTracking.accept(pl, this.setSkin, this.writeSkinData(pd, pl));
        pd.save(this.getPlayerUUID.apply(pl).toString());
    }

    public void setScale(float scl) {
        if (this.hasModClient()) {
            PB pb = this.newPacketBuffer.get();
            NBT nbt = this.newNbt.get();
            this.setFloat.set(nbt, SCALE_TAG, Float.valueOf(scl));
            this.writeCompound.accept(pb, nbt);
            this.sendPacket.accept(this.getClientNet(), this.setScale, pb);
        }
    }

    public void onRespawn(P pl) {
        float sc;
        if (this.scaleSetter != null && ((sc = this.getSNetH(pl).cpm$getEncodedModelData().scale) != 1.0f || sc != 0.0f)) {
            this.scaleSetter.accept(pl, Float.valueOf(sc));
        }
    }

    public boolean hasModClient() {
        NET n = this.getClientNet();
        return n instanceof NetH && ((NetH)n).cpm$hasMod();
    }

    public P getClient() {
        return this.getClient.get();
    }

    public NET getClientNet() {
        return this.getNet.apply(this.getClient());
    }

    private NetH.ServerNetH getSNetH(P player) {
        return (NetH.ServerNetH)this.getNet.apply(player);
    }

    public void setNewPacketBuffer(Supplier<PB> newPacketBuffer) {
        this.newPacketBuffer = newPacketBuffer;
    }

    public void setNewNbt(Supplier<NBT> newNbt) {
        this.newNbt = newNbt;
    }

    public void setGetPlayerUUID(Function<P, UUID> getPlayerUUID) {
        this.getPlayerUUID = getPlayerUUID;
    }

    public void setWriteCompound(BiConsumer<PB, NBT> writeCompound, Function<PB, NBT> readCompound) {
        this.writeCompound = writeCompound;
        this.readCompound = readCompound;
    }

    public void setSendPacket(TriConsumer<NET, RL, PB> sendPacket, TriConsumer<P, RL, PB> sendToAllTracking) {
        this.sendPacket = sendPacket;
        this.sendToAllTracking = sendToAllTracking;
    }

    public void setWritePlayerId(BiConsumer<PB, P> writePlayerId) {
        this.writePlayerId = writePlayerId;
    }

    public void setNBTSetters(NBTSetter<NBT, Boolean> setBoolean, NBTSetter<NBT, byte[]> setByteArray, NBTSetter<NBT, Float> setFloat) {
        this.setBoolean = setBoolean;
        this.setByteArray = setByteArray;
        this.setFloat = setFloat;
    }

    public void setNBTGetters(NBTGetter<NBT, Boolean> getBoolean, NBTGetter<NBT, byte[]> getByteArray, NBTGetter<NBT, Float> getFloat) {
        this.getBoolean = getBoolean;
        this.getByteArray = getByteArray;
        this.getFloat = getFloat;
    }

    public void setContains(BiPredicate<NBT, String> contains) {
        this.contains = contains;
    }

    public void setFindTracking(BiConsumer<P, Consumer<P>> findTracking) {
        this.findTracking = findTracking;
    }

    public void setSendChat(BiConsumer<P, String> sendChat) {
        this.sendChat = sendChat;
    }

    public void setExecutor(Supplier<Executor> executor) {
        this.executor = v -> (Executor)executor.get();
    }

    public void setExecutor(Function<NET, Executor> executor) {
        this.executor = executor;
    }

    public <T> void setReadPlayerId(Function<PB, T> readPlayerId, Function<T, P> getPlayerById) {
        this.readPlayerId = readPlayerId;
        this.getPlayerById = getPlayerById;
    }

    public void setPlayerToLoader(Function<P, Object> playerToloader) {
        this.playerToLoader = playerToloader;
    }

    public void setScaleSetter(BiConsumer<P, Float> scaleSetter) {
        this.scaleSetter = scaleSetter;
    }

    public void setGetClient(Supplier<P> getClient) {
        this.getClient = getClient;
    }

    public void setGetNet(Function<P, NET> getNet) {
        this.getNet = getNet;
    }

    public void setGetPlayer(Function<NET, P> getPlayer) {
        this.getPlayer = getPlayer;
    }

    @FunctionalInterface
    public static interface NBTGetter<NBT, T> {
        public T get(NBT var1, String var2);
    }

    @FunctionalInterface
    public static interface NBTSetter<NBT, T> {
        public void set(NBT var1, String var2, T var3);
    }
}

