/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model.render;

import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.render.PlayerModelSetup;
import com.tom.cpm.shared.model.render.VanillaPartRenderer;
import com.tom.cpm.shared.util.PlayerModelLayer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class VanillaPlayerModel {
    public List<VanillaPartRenderer> parts = new ArrayList<VanillaPartRenderer>();
    public VanillaPartRenderer head;
    public VanillaPartRenderer body;
    public VanillaPartRenderer rightArm;
    public VanillaPartRenderer leftArm;
    public VanillaPartRenderer rightLeg;
    public VanillaPartRenderer leftLeg;
    public VanillaPartRenderer cape;
    public VanillaPartRenderer elytraLeft;
    public VanillaPartRenderer elytraRight;
    public VanillaPartRenderer armorHelmet;
    public VanillaPartRenderer armorBody;
    public VanillaPartRenderer armorLeftArm;
    public VanillaPartRenderer armorRightArm;
    public VanillaPartRenderer armorLeggingsBody;
    public VanillaPartRenderer armorLeftLeg;
    public VanillaPartRenderer armorRightLeg;
    public VanillaPartRenderer armorLeftFoot;
    public VanillaPartRenderer armorRightFoot;
    public boolean crouching;
    public boolean riding;
    public float attackTime;
    public float swimAmount;
    public PlayerModelSetup.ArmPose leftArmPose = PlayerModelSetup.ArmPose.EMPTY;
    public PlayerModelSetup.ArmPose rightArmPose = PlayerModelSetup.ArmPose.EMPTY;

    public VanillaPlayerModel(SkinType skin) {
        this.head = new VanillaPartRenderer(this, PlayerModelParts.HEAD, skin, 64, 64);
        this.body = new VanillaPartRenderer(this, PlayerModelParts.BODY, skin, 64, 64);
        this.leftArm = new VanillaPartRenderer(this, PlayerModelParts.LEFT_ARM, skin, 64, 64);
        this.rightArm = new VanillaPartRenderer(this, PlayerModelParts.RIGHT_ARM, skin, 64, 64);
        this.leftLeg = new VanillaPartRenderer(this, PlayerModelParts.LEFT_LEG, skin, 64, 64);
        this.rightLeg = new VanillaPartRenderer(this, PlayerModelParts.RIGHT_LEG, skin, 64, 64);
        this.cape = new VanillaPartRenderer(this, RootModelType.CAPE, skin, 64, 32);
        this.elytraLeft = new VanillaPartRenderer(this, RootModelType.ELYTRA_LEFT, skin, 64, 32);
        this.elytraRight = new VanillaPartRenderer(this, RootModelType.ELYTRA_RIGHT, skin, 64, 32);
        this.armorHelmet = new VanillaPartRenderer(this, RootModelType.ARMOR_HELMET, skin, 64, 32);
        this.armorBody = new VanillaPartRenderer(this, RootModelType.ARMOR_BODY, skin, 64, 32);
        this.armorLeftArm = new VanillaPartRenderer(this, RootModelType.ARMOR_LEFT_ARM, skin, 64, 32);
        this.armorRightArm = new VanillaPartRenderer(this, RootModelType.ARMOR_RIGHT_ARM, skin, 64, 32);
        this.armorLeggingsBody = new VanillaPartRenderer(this, RootModelType.ARMOR_LEGGINGS_BODY, skin, 64, 32);
        this.armorLeftLeg = new VanillaPartRenderer(this, RootModelType.ARMOR_LEFT_LEG, skin, 64, 32);
        this.armorRightLeg = new VanillaPartRenderer(this, RootModelType.ARMOR_RIGHT_LEG, skin, 64, 32);
        this.armorLeftFoot = new VanillaPartRenderer(this, RootModelType.ARMOR_LEFT_FOOT, skin, 64, 32);
        this.armorRightFoot = new VanillaPartRenderer(this, RootModelType.ARMOR_RIGHT_FOOT, skin, 64, 32);
    }

    public void setAllVisible(boolean b) {
        this.head.visible = b;
        this.body.visible = b;
        this.rightArm.visible = b;
        this.leftArm.visible = b;
        this.rightLeg.visible = b;
        this.leftLeg.visible = b;
    }

    public void render(MatrixStack stack, VertexBuffer buffer) {
        this.head.render(stack, buffer);
        this.body.render(stack, buffer);
        this.leftArm.render(stack, buffer);
        this.rightArm.render(stack, buffer);
        this.leftLeg.render(stack, buffer);
        this.rightLeg.render(stack, buffer);
    }

    public void poseLayer(PlayerModelLayer layer, Set<PlayerModelLayer> layers) {
        switch (layer) {
            case BODY: {
                this.armorBody.copyFrom(this.body);
                this.armorLeftArm.copyFrom(this.leftArm);
                this.armorRightArm.copyFrom(this.rightArm);
                break;
            }
            case BOOTS: {
                this.armorLeftFoot.copyFrom(this.leftLeg);
                this.armorRightFoot.copyFrom(this.rightLeg);
                break;
            }
            case CAPE: {
                float f1 = 0.0f;
                if (this.crouching) {
                    f1 += 25.0f;
                }
                if (!layers.contains((Object)PlayerModelLayer.BODY)) {
                    if (this.crouching) {
                        this.cape.z = 1.775f;
                        this.cape.y = 2.35f;
                    } else {
                        this.cape.z = 2.0f;
                        this.cape.y = 0.0f;
                    }
                } else if (this.crouching) {
                    this.cape.z = 2.3f;
                    this.cape.y = 1.1f;
                } else {
                    this.cape.z = 2.9f;
                    this.cape.y = 0.14999998f;
                }
                this.cape.xRot = (float)(-Math.toRadians(6.0f + f1));
                this.cape.yRot = (float)Math.toRadians(180.0);
                break;
            }
            case ELYTRA: {
                this.elytraLeft.x = 5.0f;
                this.elytraLeft.y = 0.0f;
                this.elytraLeft.xRot = 0.2617994f;
                this.elytraLeft.zRot = -0.2617994f;
                this.elytraLeft.yRot = 0.0f;
                this.elytraRight.x = -this.elytraLeft.x;
                this.elytraRight.yRot = -this.elytraLeft.yRot;
                this.elytraRight.y = this.elytraLeft.y;
                this.elytraRight.xRot = this.elytraLeft.xRot;
                this.elytraRight.zRot = -this.elytraLeft.zRot;
                break;
            }
            case HELMET: {
                this.armorHelmet.copyFrom(this.head);
                break;
            }
            case LEGS: {
                this.armorLeggingsBody.copyFrom(this.body);
                this.armorLeftLeg.copyFrom(this.leftLeg);
                this.armorRightLeg.copyFrom(this.rightLeg);
                break;
            }
        }
    }

    public void renderLayer(MatrixStack stack, VertexBuffer buffer, PlayerModelLayer layer) {
        switch (layer) {
            case BODY: {
                this.armorBody.render(stack, buffer);
                this.armorLeftArm.render(stack, buffer);
                this.armorRightArm.render(stack, buffer);
                break;
            }
            case BOOTS: {
                this.armorLeftFoot.render(stack, buffer);
                this.armorRightFoot.render(stack, buffer);
                break;
            }
            case CAPE: {
                this.cape.render(stack, buffer);
                break;
            }
            case ELYTRA: {
                stack.push();
                stack.translate(0.0, 0.0, 0.125);
                this.elytraLeft.render(stack, buffer);
                this.elytraRight.render(stack, buffer);
                stack.pop();
                break;
            }
            case HELMET: {
                this.armorHelmet.render(stack, buffer);
                break;
            }
            case LEGS: {
                this.armorLeggingsBody.render(stack, buffer);
                this.armorLeftLeg.render(stack, buffer);
                this.armorRightLeg.render(stack, buffer);
                break;
            }
        }
    }

    public void reset() {
        this.crouching = false;
        this.riding = false;
        this.attackTime = 0.0f;
        this.leftArmPose = PlayerModelSetup.ArmPose.EMPTY;
        this.rightArmPose = PlayerModelSetup.ArmPose.EMPTY;
        this.parts.forEach(VanillaPartRenderer::reset);
    }
}

