/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model.render;

import com.tom.cpl.function.ToFloatFunction;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.RenderTypes;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpm.shared.IPlayerRenderManager;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.EditorDefinition;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.model.PartRoot;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.model.RootModelElement;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.BoxRender;
import com.tom.cpm.shared.model.render.Mesh;
import com.tom.cpm.shared.model.render.RenderMode;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.util.ErrorLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class ModelRenderManager<D, S, P, MB>
implements IPlayerRenderManager {
    public static final Predicate<Player<?, ?>> ALWAYS = p -> true;
    protected Map<MB, RedirectHolder<MB, D, S, P>> holders = new HashMap<MB, RedirectHolder<MB, D, S, P>>();
    private RedirectHolderFactory<D, S, P> factory;
    private RedirectRendererFactory<MB, S, P> redirectFactory;
    private AnimationEngine animEngine = new AnimationEngine();
    private ModelPartVec3fSetter<P> posSet;
    private ModelPartVec3fSetter<P> rotSet;
    private ToFloatFunction<P> px;
    private ToFloatFunction<P> py;
    private ToFloatFunction<P> pz;
    private ToFloatFunction<P> rx;
    private ToFloatFunction<P> ry;
    private ToFloatFunction<P> rz;
    private Predicate<P> getVis;
    private BoolSetter<P> setVis;

    public void setFactory(RedirectHolderFactory<D, S, P> factory) {
        this.factory = factory;
    }

    public void setRedirectFactory(RedirectRendererFactory<MB, S, P> redirectFactory) {
        this.redirectFactory = redirectFactory;
    }

    public void setModelSetters(ModelPartVec3fSetter<P> posSet, ModelPartVec3fSetter<P> rotSet) {
        this.posSet = posSet;
        this.rotSet = rotSet;
    }

    public void setModelPosGetters(ToFloatFunction<P> x, ToFloatFunction<P> y, ToFloatFunction<P> z) {
        this.px = x;
        this.py = y;
        this.pz = z;
    }

    public void setModelRotGetters(ToFloatFunction<P> x, ToFloatFunction<P> y, ToFloatFunction<P> z) {
        this.rx = x;
        this.ry = y;
        this.rz = z;
    }

    public void setVis(Predicate<P> getVis, BoolSetter<P> setVis) {
        this.getVis = getVis;
        this.setVis = setVis;
    }

    public void bindModel(MB model, String arg, D addDt, ModelDefinition def, Player<?, MB> player, AnimationEngine.AnimationMode mode) {
        this.getHolderSafe(model, arg, h -> h.swapIn(def, addDt, player, mode));
    }

    public void bindModel(MB model, D addDt, ModelDefinition def, Player<?, MB> player, AnimationEngine.AnimationMode mode) {
        this.bindModel(model, null, addDt, def, player, mode);
    }

    public void unbindModel(MB model) {
        RedirectHolder<MB, D, S, P> h = this.holders.get(model);
        if (h != null) {
            h.swapOut();
        }
    }

    public void bindSkin(MB model, String arg, S cbi, TextureSheetType tex) {
        this.getHolderSafe(model, arg, h -> ((RedirectHolder)h).bindTexture0(cbi, tex));
    }

    public void bindSkin(MB model, S cbi, TextureSheetType tex) {
        this.bindSkin(model, null, cbi, tex);
    }

    public void rebindModel(MB model) {
        this.getHolderSafe(model, null, rec$ -> ((RedirectHolder)rec$).rebind());
    }

    public boolean isBound(MB model, String arg) {
        return this.getHolderSafe(model, arg, h -> h.swappedIn, false);
    }

    public boolean isBound(MB model) {
        return this.isBound(model, null);
    }

    public <R> R getHolderSafe(MB model, String arg, Function<RedirectHolder<MB, D, S, P>, R> func, R def) {
        RedirectHolder<Object, D, S, P> h = this.holders.get(model);
        if (h == null && (h = this.factory.create(model, arg)) != null) {
            this.holders.put(model, h);
        }
        if (h == null) {
            return def;
        }
        return func.apply(h);
    }

    public void getHolderSafe(MB model, String arg, Consumer<RedirectHolder<MB, D, S, P>> func) {
        RedirectHolder<Object, D, S, P> h = this.holders.get(model);
        if (h == null && (h = this.factory.create(model, arg)) != null) {
            this.holders.put(model, h);
        }
        if (h != null) {
            func.accept(h);
        }
    }

    private RedirectHolder<MB, D, S, P> create(MB model) {
        RedirectHolder<?, D, S, P> r = this.factory.create(model, null);
        if (r == null) {
            throw new IllegalArgumentException("Tried to create RedirectHolder for unknown model type: " + model.getClass());
        }
        return r;
    }

    public RedirectHolder<MB, D, S, P> getHolder(MB model) {
        return this.holders.computeIfAbsent(model, this::create);
    }

    public void copyModelForArmor(P from, P to) {
        this.posSet.set(to, this.px.apply(from), this.py.apply(from), this.pz.apply(from));
        this.rotSet.set(to, this.rx.apply(from), this.ry.apply(from), this.rz.apply(from));
    }

    private static Mesh createBox(RenderedCube elem, RedirectHolder<?, ?, ?, ?> holder) {
        Cube c = elem.getCube();
        if (c.texSize == 0) {
            return BoxRender.createColored(c.offset.x, c.offset.y, c.offset.z, c.size.x * c.scale.x, c.size.y * c.scale.y, c.size.z * c.scale.z, c.mcScale, holder.sheetX, holder.sheetY);
        }
        if (elem.singleTex) {
            return BoxRender.createTexturedSingle(c.offset, c.size, c.scale, c.mcScale, c.u, c.v, c.texSize, holder.sheetX, holder.sheetY);
        }
        if (elem.faceUVs != null) {
            return BoxRender.createTextured(c.offset, c.size, c.scale, c.mcScale, elem.faceUVs, c.texSize, holder.sheetX, holder.sheetY);
        }
        return BoxRender.createTextured(c.offset, c.size, c.scale, c.mcScale, c.u, c.v, c.texSize, holder.sheetX, holder.sheetY);
    }

    @Override
    public AnimationEngine getAnimationEngine() {
        return this.animEngine;
    }

    @FunctionalInterface
    public static interface BoolSetter<P> {
        public void set(P var1, boolean var2);
    }

    @FunctionalInterface
    public static interface ModelPartVec3fSetter<P> {
        public void set(P var1, float var2, float var3, float var4);

        default public void set(P p, Vec3f v) {
            this.set(p, v.x, v.y, v.z);
        }
    }

    @FunctionalInterface
    public static interface RedirectRendererFactory<M, S, P> {
        public RedirectRenderer<P> create(M var1, RedirectHolder<M, ?, S, P> var2, Supplier<P> var3, VanillaModelPart var4);
    }

    public static class Field<V> {
        private Supplier<V> get;
        private Consumer<V> set;
        private VanillaModelPart part;

        public Field(Supplier<V> get, Consumer<V> set, VanillaModelPart part) {
            this.part = part;
            this.get = get;
            this.set = set;
        }
    }

    public static interface RedirectRenderer<P> {
        public P swapIn();

        public P swapOut();

        public RedirectHolder<?, ?, ?, P> getHolder();

        public P getParent();

        public VanillaModelPart getPart();

        public void renderParent();

        public VBuffers getVBuffers();

        public Vec4f getColor();

        default public RedirectRenderer<P> setCopyFrom(RedirectRenderer<P> from) {
            this.getHolder().partData.get(this).copyFrom = from;
            return this;
        }

        default public RedirectRenderer<P> setRenderPredicate(Predicate<Player<?, ?>> renderPredicate) {
            this.getHolder().partData.get(this).renderPredicate = renderPredicate;
            return this;
        }

        default public boolean noReset() {
            return false;
        }

        default public void render() {
            RedirectHolder<?, ?, ?, RedirectRenderer> holder = this.getHolder();
            ModelRenderManager mngr = holder.mngr;
            RedirectRenderer tp = this;
            P parent = this.getParent();
            if (holder.mngr.getVis.test(tp)) {
                if (holder.def != null) {
                    RedirectDataHolder dh = holder.partData.get(this);
                    VanillaModelPart part = this.getPart();
                    if (!holder.preRenderSetup) {
                        holder.preRenderSetup = true;
                        holder.bindFirstSetup();
                    }
                    if (!holder.skinBound) {
                        holder.skinBound = true;
                        holder.bindSkin();
                    }
                    if (part == null) {
                        if (dh.copyFrom != null) {
                            holder.copyModel(dh.copyFrom, tp);
                        }
                        return;
                    }
                    PartRoot elems = holder.def.getModelElementFor(part);
                    if (elems != null) {
                        if (elems.isEmpty()) {
                            return;
                        }
                        boolean skipTransform = holder.mode == AnimationEngine.AnimationMode.SKULL || holder.mode == AnimationEngine.AnimationMode.HAND || holder.skipTransform(this);
                        float px = mngr.px.apply(tp);
                        float py = mngr.py.apply(tp);
                        float pz = mngr.pz.apply(tp);
                        float rx = mngr.rx.apply(tp);
                        float ry = mngr.ry.apply(tp);
                        float rz = mngr.rz.apply(tp);
                        boolean doRender = holder.playerObj == null || dh.renderPredicate.test(holder.playerObj) || !holder.def.isHideHeadIfSkull();
                        elems.forEach(elem -> {
                            if (!elem.renderPart()) {
                                return;
                            }
                            if (holder.def.isRemoveArmorOffset() && elems.getMainRoot() != elem && part.getCopyFrom() != null) {
                                elem.setPosAndRot(holder.def.getModelElementFor(part.getCopyFrom()));
                            }
                            if (!skipTransform) {
                                mngr.posSet.set(tp, elem.getPos());
                                mngr.rotSet.set(tp, elem.getRot());
                            }
                            if (elem.doDisplay() && doRender) {
                                holder.copyModel(tp, (RedirectRenderer)parent);
                                this.renderParent();
                            }
                            this.doRender0((RootModelElement)elem, doRender);
                        });
                        if (!this.noReset()) {
                            mngr.posSet.set(parent, px, py, pz);
                            mngr.rotSet.set(parent, rx, ry, rz);
                        }
                        if (!skipTransform) {
                            RootModelElement elem2 = elems.getMainRoot();
                            mngr.posSet.set(tp, elem2.getPos());
                            mngr.rotSet.set(tp, elem2.getRot());
                        }
                    } else {
                        holder.copyModel(tp, (RedirectRenderer)parent);
                        this.renderParent();
                    }
                } else {
                    holder.copyModel(tp, (RedirectRenderer)parent);
                    this.renderParent();
                }
            }
        }

        public static void translateRotate(RenderedCube rc, MatrixStack matrixStackIn) {
            RedirectRenderer.translateRotate(rc.pos.x, rc.pos.y, rc.pos.z, rc.rotation.x, rc.rotation.y, rc.rotation.z, matrixStackIn);
        }

        public static void translateRotate(float px, float py, float pz, float rx, float ry, float rz, MatrixStack matrixStackIn) {
            matrixStackIn.translate(px / 16.0f, py / 16.0f, pz / 16.0f);
            if (rz != 0.0f) {
                matrixStackIn.rotate(Vec3f.POSITIVE_Z.getRadialQuaternion(rz));
            }
            if (ry != 0.0f) {
                matrixStackIn.rotate(Vec3f.POSITIVE_Y.getRadialQuaternion(ry));
            }
            if (rx != 0.0f) {
                matrixStackIn.rotate(Vec3f.POSITIVE_X.getRadialQuaternion(rx));
            }
        }

        default public void translateRotate(MatrixStack matrixStackIn) {
            RedirectHolder<?, ?, ?, P> holder = this.getHolder();
            ModelRenderManager m = holder.mngr;
            RedirectRenderer tp = this;
            RedirectRenderer.translateRotate(m.px.apply(tp), m.py.apply(tp), m.pz.apply(tp), m.rx.apply(tp), m.ry.apply(tp), m.rz.apply(tp), matrixStackIn);
        }

        default public void render(RenderedCube elem, MatrixStack matrixStackIn, VBuffers buf, float red, float green, float blue, float alpha) {
            RedirectHolder<?, ?, ?, P> holder = this.getHolder();
            if (holder.def instanceof EditorDefinition && buf != null) {
                ((EditorDefinition)holder.def).render(matrixStackIn, buf, holder.renderTypes, elem);
            }
            if (elem.children == null) {
                return;
            }
            for (RenderedCube cube : elem.children) {
                if (!cube.display) continue;
                matrixStackIn.push();
                RedirectRenderer.translateRotate(cube, matrixStackIn);
                if (cube.itemRenderer != null) {
                    Cube c = cube.getCube();
                    if (holder.def instanceof EditorDefinition && buf != null) {
                        ((EditorDefinition)holder.def).render(matrixStackIn, buf, holder.renderTypes, cube);
                    }
                    matrixStackIn.translate(c.offset.x / 16.0f, c.offset.y / 16.0f, c.offset.z / 16.0f);
                    matrixStackIn.scale(c.scale.x, c.scale.y, c.scale.z);
                    if (cube.itemRenderer.slot != ItemSlot.ANY_SLOT) {
                        holder.def.storeTransform(cube.itemRenderer.slot, matrixStackIn);
                    }
                    matrixStackIn.pop();
                    continue;
                }
                if (buf != null) {
                    float r = red;
                    float g = green;
                    float b = blue;
                    if (cube.color != 0xFFFFFF) {
                        r *= (float)((cube.color & 0xFF0000) >> 16) / 255.0f;
                        g *= (float)((cube.color & 0xFF00) >> 8) / 255.0f;
                        b *= (float)(cube.color & 0xFF) / 255.0f;
                    }
                    if (cube.useDynamic || cube.renderObject == null) {
                        if (cube.renderObject != null) {
                            cube.renderObject.free();
                        }
                        cube.renderObject = ModelRenderManager.createBox(cube, holder);
                    }
                    Mesh mesh = cube.renderObject;
                    VertexBuffer buffer = buf.getBuffer(holder.renderTypes, mesh.getLayer());
                    if (holder.def.isEditor()) {
                        RenderedCube.ElementSelectMode sel = cube.getSelected();
                        if (!sel.applyColor()) {
                            r = 1.0f;
                            g = 1.0f;
                            b = 1.0f;
                        } else if (cube.glow) {
                            buffer = buf.getBuffer(holder.renderTypes, RenderMode.GLOW);
                        }
                    } else if (cube.glow) {
                        buffer = buf.getBuffer(holder.renderTypes, RenderMode.GLOW);
                    }
                    mesh.draw(matrixStackIn, buffer, r, g, b, alpha);
                }
                this.render(cube, matrixStackIn, buf, red, green, blue, alpha);
                matrixStackIn.pop();
            }
        }

        default public void doRender0(RootModelElement elem, boolean doRender) {
            MatrixStack stack = new MatrixStack();
            this.translateRotate(stack);
            if (doRender) {
                Vec4f color = this.getColor();
                VBuffers buf = this.getVBuffers().replay();
                this.render(elem, stack, buf, color.x, color.y, color.z, color.w);
                buf.finishAll();
            } else {
                this.render(elem, stack, null, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }

        default public MatrixStack.Entry getPartTransform() {
            RedirectHolder<?, ?, ?, P> holder = this.getHolder();
            VanillaModelPart part = this.getPart();
            if (part == PlayerModelParts.LEFT_ARM) {
                return holder.def.getTransform(ItemSlot.LEFT_HAND);
            }
            if (part == PlayerModelParts.RIGHT_ARM) {
                return holder.def.getTransform(ItemSlot.RIGHT_HAND);
            }
            if (part == PlayerModelParts.HEAD) {
                return holder.def.getTransform(ItemSlot.HEAD);
            }
            return null;
        }
    }

    private static class RedirectDataHolder<P> {
        private RedirectRenderer<P> copyFrom;
        private Predicate<Player<?, ?>> renderPredicate = ALWAYS;

        private RedirectDataHolder() {
        }
    }

    public static abstract class RedirectHolder<M, D, S, P> {
        protected final ModelRenderManager<D, S, P, M> mngr;
        public final M model;
        public ModelDefinition def;
        public boolean swappedIn;
        public int sheetX;
        public int sheetY;
        public D addDt;
        public List<Field<P>> modelFields;
        public List<RedirectRenderer<P>> redirectRenderers;
        public boolean preRenderSetup;
        public boolean skinBound;
        public Map<RedirectRenderer<P>, RedirectDataHolder<P>> partData;
        public Player<?, M> playerObj;
        public AnimationEngine.AnimationMode mode;
        public RenderTypes<RenderMode> renderTypes;
        private boolean loggedWarning;

        public RedirectHolder(ModelRenderManager<D, S, P, M> mngr, M model) {
            this.model = model;
            this.mngr = mngr;
            this.modelFields = new ArrayList<Field<P>>();
            this.redirectRenderers = new ArrayList<RedirectRenderer<P>>();
            this.partData = new HashMap<RedirectRenderer<P>, RedirectDataHolder<P>>();
            this.renderTypes = new RenderTypes<RenderMode>(RenderMode.class);
        }

        public final void swapIn(ModelDefinition def, D addDt, Player<?, M> playerObj, AnimationEngine.AnimationMode mode) {
            this.def = def;
            this.addDt = addDt;
            this.mode = mode;
            if (this.swappedIn) {
                return;
            }
            this.swapIn0();
            for (int i = 0; i < this.modelFields.size(); ++i) {
                Field<P> field = this.modelFields.get(i);
                RedirectRenderer<P> rd = this.redirectRenderers.get(i);
                ((Field)field).set.accept(rd.swapIn());
            }
            this.playerObj = playerObj;
            this.swappedIn = true;
        }

        public final void swapOut() {
            this.def = null;
            this.addDt = null;
            this.skinBound = false;
            this.preRenderSetup = false;
            this.renderTypes.clear();
            this.playerObj = null;
            if (!this.swappedIn) {
                return;
            }
            this.swapOut0();
            for (int i = 0; i < this.modelFields.size(); ++i) {
                Field<P> field = this.modelFields.get(i);
                ((Field)field).set.accept(this.redirectRenderers.get(i).swapOut());
            }
            this.swappedIn = false;
        }

        private void rebind() {
            if (!this.swappedIn) {
                return;
            }
            ModelDefinition def = this.def;
            D addDt = this.addDt;
            Player<?, M> playerObj = this.playerObj;
            AnimationEngine.AnimationMode mode = this.mode;
            this.swapOut();
            this.swapIn(def, addDt, playerObj, mode);
        }

        private void bindTexture0(S cbi, TextureSheetType tex) {
            if (this.def == null) {
                return;
            }
            TextureProvider skin = this.def.getTexture(tex, this.isInGui());
            if (skin != null && skin.texture != null) {
                this.bindTexture(cbi, skin);
                this.sheetX = skin.getSize().x;
                this.sheetY = skin.getSize().y;
            } else {
                Vec2i s = tex.getDefSize();
                this.sheetX = s.x;
                this.sheetY = s.y;
            }
            this.setupRenderSystem(cbi, tex);
        }

        protected void setupRenderSystem(S cbi, TextureSheetType tex) {
        }

        protected void bindTexture(S cbi, TextureProvider skin) {
        }

        protected abstract void swapIn0();

        protected abstract void swapOut0();

        protected void bindSkin() {
        }

        protected void bindFirstSetup() {
            for (int i = 0; i < this.redirectRenderers.size(); ++i) {
                PartRoot elems;
                RedirectRenderer<P> re = this.redirectRenderers.get(i);
                VanillaModelPart part = re.getPart();
                if (part == null || (elems = this.def.getModelElementFor(part)) == null) continue;
                RedirectRenderer<P> tp = re;
                float px = ((ModelRenderManager)this.mngr).px.apply(tp);
                float py = ((ModelRenderManager)this.mngr).py.apply(tp);
                float pz = ((ModelRenderManager)this.mngr).pz.apply(tp);
                float rx = ((ModelRenderManager)this.mngr).rx.apply(tp);
                float ry = ((ModelRenderManager)this.mngr).ry.apply(tp);
                float rz = ((ModelRenderManager)this.mngr).rz.apply(tp);
                elems.setRootPosAndRot(px, py, pz, rx, ry, rz);
            }
        }

        protected RedirectRenderer<P> register(Field<P> f) {
            RedirectRenderer rd = ((ModelRenderManager)this.mngr).redirectFactory.create(this.model, this, ((Field)f).get, ((Field)f).part);
            this.modelFields.add(f);
            this.redirectRenderers.add(rd);
            this.partData.put(rd, new RedirectDataHolder());
            return rd;
        }

        protected RedirectRenderer<P> register(Field<P> f, Predicate<Player<?, ?>> doRender) {
            return this.register(f).setRenderPredicate(doRender);
        }

        public void copyModel(P from, P to) {
            ((ModelRenderManager)this.mngr).posSet.set(to, ((ModelRenderManager)this.mngr).px.apply(from), ((ModelRenderManager)this.mngr).py.apply(from), ((ModelRenderManager)this.mngr).pz.apply(from));
            ((ModelRenderManager)this.mngr).rotSet.set(to, ((ModelRenderManager)this.mngr).rx.apply(from), ((ModelRenderManager)this.mngr).ry.apply(from), ((ModelRenderManager)this.mngr).rz.apply(from));
            ((ModelRenderManager)this.mngr).setVis.set(to, ((ModelRenderManager)this.mngr).getVis.test(from));
        }

        protected boolean skipTransform(RedirectRenderer<P> part) {
            return false;
        }

        public void logWarning() {
            if (!this.loggedWarning) {
                ErrorLog.addFormattedLog(ErrorLog.LogLevel.ERROR, "label.cpm.error.renderInitFail", this.model.getClass().toString());
                this.loggedWarning = true;
            }
        }

        protected boolean isInGui() {
            return false;
        }
    }

    public static interface RedirectHolderFactory<D, S, P> {
        public <M> RedirectHolder<?, D, S, P> create(M var1, String var2);
    }
}

