/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model;

import com.tom.cpl.util.Image;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import java.io.IOException;
import java.io.InputStream;

public enum SkinType {
    SLIM(0, "Slim"),
    DEFAULT(1, "Classic"),
    UNKNOWN(-1, "Classic");

    private final int channel;
    private final String lowerName;
    private final String apiName;
    public static final SkinType[] VALUES;
    public static final SkinType[] VANILLA_TYPES;

    private SkinType(int channel, String apiName) {
        this.channel = channel;
        this.lowerName = this.name().toLowerCase();
        this.apiName = apiName;
    }

    public static SkinType get(String name) {
        if (name == null) {
            return DEFAULT;
        }
        for (SkinType pl : VALUES) {
            if (!name.equals(pl.lowerName)) continue;
            return pl;
        }
        return UNKNOWN;
    }

    public int getChannel() {
        return this.channel;
    }

    public String getName() {
        return this.lowerName;
    }

    public String getApiName() {
        return this.apiName;
    }

    public Image getSkinTexture() {
        if (this == UNKNOWN) {
            return DEFAULT.getSkinTexture();
        }
        Image tex = new Image(64, 64);
        try (InputStream is = ModelDefinitionLoader.class.getResourceAsStream("/assets/cpm/textures/template/" + this.lowerName + ".png");){
            tex = Image.loadFrom(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return tex;
    }

    static {
        VALUES = SkinType.values();
        VANILLA_TYPES = new SkinType[]{SLIM, DEFAULT};
    }
}

