/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.loaders;

import com.tom.cpm.shared.config.ConfigKeys;
import com.tom.cpm.shared.config.ResourceLoader;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.definition.SafetyException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;

public abstract class HttpResourceLoader
implements ResourceLoader {
    protected abstract URL createURL(String var1) throws IOException;

    @Override
    public byte[] loadResource(String path, ResourceLoader.ResourceEncoding enc, ModelDefinition def) throws IOException {
        URL url = this.createURL(path);
        InputStream web = null;
        URLConnection connection = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            connection = url.openConnection();
            web = connection.getInputStream();
            byte[] buffer = new byte[10240];
            int totalBytesDownloaded = 0;
            int bytesJustDownloaded = 0;
            while ((bytesJustDownloaded = web.read(buffer)) > 0) {
                out.write(buffer, 0, bytesJustDownloaded);
                totalBytesDownloaded += bytesJustDownloaded;
                if (def == null) continue;
                ConfigKeys.MAX_LINK_SIZE.checkFor(def.getPlayerObj(), totalBytesDownloaded / 1024, SafetyException.BlockReason.LINK_OVERFLOW);
            }
            switch (enc) {
                case NO_ENCODING: {
                    byte[] byArray = out.toByteArray();
                    return byArray;
                }
                case BASE64: {
                    byte[] byArray = Base64.getDecoder().decode(new String(out.toByteArray()));
                    return byArray;
                }
            }
            throw new IOException("Unsupported file encoding");
        }
        finally {
            if (connection != null && connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
            if (web != null) {
                try {
                    web.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

