/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.panel;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.math.Mat3f;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.render.RenderTypes;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpl.util.Hand;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.DisplayItem;
import com.tom.cpm.shared.editor.RootGroups;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.Panel3d;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.GuiModelRenderManager;
import com.tom.cpm.shared.model.render.PlayerModelSetup;
import com.tom.cpm.shared.model.render.RenderMode;
import com.tom.cpm.shared.model.render.VanillaPlayerModel;
import com.tom.cpm.shared.util.PlayerModelLayer;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Set;

public abstract class ViewportPanelBase3d
extends Panel3d {
    private static final GuiModelRenderManager manager = new GuiModelRenderManager();
    private static final EnumMap<SkinType, VanillaPlayerModel> models = new EnumMap(SkinType.class);
    protected int mx;
    protected int my;
    protected boolean enableDrag;
    protected boolean dragMode;
    protected int paintColor;
    protected Vec2i mouseCursorPos = new Vec2i();
    private RenderTypes<RenderMode> types;

    public ViewportPanelBase3d(IGui gui) {
        super(gui);
        this.setBackgroundColor(gui.getColors().popup_background);
    }

    public void renderModel(MatrixStack stack, VBuffers buf, float partialTicks) {
        float scale = this.getScale();
        stack.push();
        stack.translate(0.5, 0.0, 0.5);
        stack.rotate(Vec3f.POSITIVE_Y.getDegreesQuaternion(90.0f));
        stack.scale(-scale, -scale, scale);
        stack.translate(0.0, -1.5, 0.0);
        this.preRender();
        ModelDefinition def = this.getDefinition();
        VanillaPlayerModel p = models.get((Object)def.getSkinType());
        VBuffers rp = buf.replay();
        manager.bindModel(p, "player", rp, def, null, this.getAnimMode());
        manager.bindSkin(p, this, TextureSheetType.SKIN);
        this.poseModel(p, stack, partialTicks);
        p.render(stack, rp.getBuffer(this.types, this.getMode()));
        Set<PlayerModelLayer> layers = this.getArmorLayers();
        for (PlayerModelLayer l : PlayerModelLayer.VALUES) {
            if (!layers.contains((Object)l)) continue;
            p.poseLayer(l, layers);
        }
        stack.push();
        p.rightArm.translateRotatePart(stack);
        this.renderItem(stack, ItemSlot.RIGHT_HAND, this.getHeldItem(ItemSlot.RIGHT_HAND));
        stack.pop();
        stack.push();
        p.leftArm.translateRotatePart(stack);
        this.renderItem(stack, ItemSlot.LEFT_HAND, this.getHeldItem(ItemSlot.LEFT_HAND));
        stack.pop();
        stack.push();
        p.head.translateRotatePart(stack);
        this.renderItem(stack, ItemSlot.HEAD, this.getHeldItem(ItemSlot.HEAD));
        stack.pop();
        manager.unbindModel(p);
        for (PlayerModelLayer l : PlayerModelLayer.VALUES) {
            if (!this.getArmorLayers().contains((Object)l)) continue;
            manager.bindModel(p, l.name(), rp, def, null, this.getAnimMode());
            manager.bindSkin(p, this, RootGroups.getGroup(l.parts[0]).getTexSheet(l.parts[0]));
            p.renderLayer(stack, rp.getBuffer(this.types, this.getMode()), l);
            manager.unbindModel(p);
        }
        rp.finishAll();
        stack.pop();
    }

    protected void poseModel(VanillaPlayerModel p, MatrixStack stack, float partialTicks) {
        p.reset();
        p.setAllVisible(true);
        PlayerModelSetup.setRotationAngles(p, 0.0f, 0.0f, Hand.RIGHT, false);
    }

    protected RenderMode getMode() {
        return this.applyLighting() ? RenderMode.DEFAULT : RenderMode.PAINT;
    }

    public void renderBase(MatrixStack stack, VBuffers buf) {
        RenderTypes<RenderMode> rt = this.getRenderTypes("area");
        VertexBuffer t = buf.getBuffer(rt, RenderMode.DEFAULT);
        Mat3f n = stack.getLast().getNormal();
        Mat4f m = stack.getLast().getMatrix();
        t.pos(m, 4.0f, 0.0f, 4.0f).tex(1.0f, 1.0f).normal(n, 0.0f, 1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 4.0f, 0.0f, -3.0f).tex(0.0f, 1.0f).normal(n, 0.0f, 1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, -3.0f, 0.0f, -3.0f).tex(0.0f, 0.0f).normal(n, 0.0f, 1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, -3.0f, 0.0f, 4.0f).tex(1.0f, 0.0f).normal(n, 0.0f, 1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.finish();
        rt = this.getRenderTypes("base");
        t = buf.getBuffer(rt, RenderMode.DEFAULT);
        float y = -1.001f;
        t.pos(m, 1.0f, y, 0.0f).tex(1.0f, 1.0f).normal(n, 0.0f, 0.0f, -1.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y, 0.0f).tex(0.0f, 1.0f).normal(n, 0.0f, 0.0f, -1.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y + 1.0f, 0.0f).tex(0.0f, 0.0f).normal(n, 0.0f, 0.0f, -1.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y + 1.0f, 0.0f).tex(1.0f, 0.0f).normal(n, 0.0f, 0.0f, -1.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y, 1.0f).tex(1.0f, 1.0f).normal(n, 0.0f, 0.0f, 1.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y, 1.0f).tex(0.0f, 1.0f).normal(n, 0.0f, 0.0f, 1.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y + 1.0f, 1.0f).tex(0.0f, 0.0f).normal(n, 0.0f, 0.0f, 1.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y + 1.0f, 1.0f).tex(1.0f, 0.0f).normal(n, 0.0f, 0.0f, 1.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y, 1.0f).tex(1.0f, 1.0f).normal(n, 1.0f, 0.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y, 0.0f).tex(0.0f, 1.0f).normal(n, 1.0f, 0.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y + 1.0f, 0.0f).tex(0.0f, 0.0f).normal(n, 1.0f, 0.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y + 1.0f, 1.0f).tex(1.0f, 0.0f).normal(n, 1.0f, 0.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y, 0.0f).tex(1.0f, 1.0f).normal(n, -1.0f, 0.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y, 1.0f).tex(0.0f, 1.0f).normal(n, -1.0f, 0.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y + 1.0f, 1.0f).tex(0.0f, 0.0f).normal(n, -1.0f, 0.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y + 1.0f, 0.0f).tex(1.0f, 0.0f).normal(n, -1.0f, 0.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y, 0.0f).tex(1.0f, 1.0f).normal(n, 0.0f, -1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y, 1.0f).tex(0.0f, 1.0f).normal(n, 0.0f, -1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y, 1.0f).tex(0.0f, 0.0f).normal(n, 0.0f, -1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y, 0.0f).tex(1.0f, 0.0f).normal(n, 0.0f, -1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y + 1.0f, 1.0f).tex(1.0f, 1.0f).normal(n, 0.0f, 1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y + 1.0f, 0.0f).tex(0.0f, 1.0f).normal(n, 0.0f, 1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y + 1.0f, 0.0f).tex(0.0f, 0.0f).normal(n, 0.0f, 1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y + 1.0f, 1.0f).tex(1.0f, 0.0f).normal(n, 0.0f, 1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.finish();
    }

    public void load() {
        this.types = this.getRenderTypes();
    }

    public void putRenderTypes(RenderTypes<RenderMode> types) {
        if (this.types == null) {
            this.load();
        }
        types.putAll(this.types);
    }

    protected float getScale() {
        return 1.0f;
    }

    protected abstract void preRender();

    protected abstract ModelDefinition getDefinition();

    protected AnimationEngine.AnimationMode getAnimMode() {
        return AnimationEngine.AnimationMode.PLAYER;
    }

    protected Set<PlayerModelLayer> getArmorLayers() {
        return Collections.emptySet();
    }

    public DisplayItem getHeldItem(ItemSlot hand) {
        return DisplayItem.NONE;
    }

    protected boolean applyLighting() {
        return true;
    }

    @Override
    public boolean mouseClick(int x, int y, int btn) {
        if (btn == EditorGui.getRotateMouseButton() && this.bounds.isInBounds(x, y)) {
            this.mx = x;
            this.my = y;
            this.enableDrag = true;
            this.dragMode = this.gui.isShiftDown();
            return true;
        }
        if (this.bounds.isInBounds(x, y)) {
            ViewportCamera cam = this.getCamera();
            cam.position.x = 0.5f;
            cam.position.y = 1.0f;
            cam.position.z = 0.5f;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseRelease(int x, int y, int btn) {
        if (btn == EditorGui.getRotateMouseButton() && this.bounds.isInBounds(x, y)) {
            this.enableDrag = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDrag(int x, int y, int btn) {
        if (btn == EditorGui.getRotateMouseButton() && this.bounds.isInBounds(x, y) && this.enableDrag) {
            ViewportCamera cam = this.getCamera();
            if (this.dragMode) {
                float yaw = cam.look.getYaw();
                double px = 0.0;
                double pz = 0.0;
                int dx = x - this.mx;
                int dy = y - this.my;
                float move = -1.0f / cam.camDist;
                if (dx != 0) {
                    px += Math.sin((double)yaw - 1.5707963267948966) * -1.0 * (double)dx * (double)move;
                    pz += Math.cos((double)yaw - 1.5707963267948966) * (double)dx * (double)move;
                }
                if (dy != 0) {
                    px += Math.sin(yaw) * -1.0 * (double)dy * (double)move;
                    pz += Math.cos(yaw) * (double)dy * (double)move;
                }
                float f = 1.0f - cam.look.y;
                Vec3f by = new Vec3f((float)(px * (double)cam.look.y), 0.0f, (float)(pz * (double)cam.look.y));
                Vec3f by1 = by.mul((float)dy * 0.1f * f);
                cam.position.x = (float)((double)cam.position.x + (px + (double)by1.x));
                cam.position.y += -f * move * (float)dy;
                cam.position.z = (float)((double)cam.position.z + (pz + (double)by1.z));
            } else {
                float pitch = (float)Math.asin(cam.look.y);
                float yaw = cam.look.getYaw();
                if (Float.isNaN(pitch)) {
                    pitch = 0.0f;
                }
                if (Float.isNaN(yaw)) {
                    yaw = 0.0f;
                }
                yaw = (float)((double)yaw + Math.toRadians(x - this.mx));
                pitch = (float)((double)pitch - Math.toRadians(y - this.my));
                yaw = (float)MathHelper.clamp(yaw, -Math.PI, Math.PI);
                pitch = (float)MathHelper.clamp(pitch, -1.5707963267948966, 1.5707963267948966);
                cam.look.y = (float)Math.sin(pitch);
                double sin = Math.sin(yaw);
                double cos = Math.cos(yaw);
                cam.look.x = (float)cos;
                cam.look.z = (float)sin;
            }
            this.mx = x;
            this.my = y;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseWheel(int x, int y, int dir) {
        if (this.bounds.isInBounds(x, y)) {
            this.zoom(dir);
            return true;
        }
        return false;
    }

    private void zoom(int dir) {
        ViewportCamera cam = this.getCamera();
        cam.camDist += (float)dir * (cam.camDist / 16.0f);
        if (cam.camDist < 32.0f) {
            cam.camDist = 32.0f;
        }
        if (cam.camDist > 4096.0f) {
            cam.camDist = 4096.0f;
        }
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        if (!event.isConsumed() && this.bounds.isInBounds(this.mouseCursorPos)) {
            if (event.matches("+")) {
                this.zoom(1);
            } else if (event.matches("-")) {
                this.zoom(-1);
            } else if (event.matches("r")) {
                ViewportCamera cam = this.getCamera();
                cam.camDist = 64.0f;
                cam.position = new Vec3f(0.5f, 1.0f, 0.5f);
                cam.look = new Vec3f(0.25f, 0.5f, 0.25f);
            }
        }
    }

    static {
        for (SkinType t : SkinType.VANILLA_TYPES) {
            models.put(t, new VanillaPlayerModel(t));
        }
    }
}

