/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.panel;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ButtonIcon;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.InputPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.gui.util.HorizontalLayout;
import com.tom.cpl.gui.util.TabbedPanelManager;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.PlatformFeature;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.gui.panel.ListPanel;
import com.tom.cpm.shared.gui.panel.SafetyHeaderPanel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SettingsPanel
extends Panel {
    private final Frame frm;
    private TabbedPanelManager tabs;
    private TabbedPanelManager safety;
    private HorizontalLayout topPanel;
    private HorizontalLayout safetyPanel;
    private ConfigEntry.ModConfigFile.ConfigEntryTemp ce;
    private Button buttonPosMode;
    private Runnable save;

    public SettingsPanel(Frame frm, SettingsPanel panel, int width, int height, Runnable save) {
        this(frm, null, width, height, panel == null ? ModConfig.getCommonConfig().createTemp() : panel.ce, save);
        this.setBackgroundColor(this.gui.getColors().popup_background & 0x80FFFFFF);
    }

    public SettingsPanel(Frame frm, PopupPanel popup, int width, int height, Runnable save) {
        this(frm, popup, width, height, ModConfig.getCommonConfig().createTemp(), save);
    }

    private SettingsPanel(Frame frm, PopupPanel popup, int width, int height, ConfigEntry.ModConfigFile.ConfigEntryTemp ce, Runnable save) {
        super(frm.getGui());
        this.frm = frm;
        this.save = save;
        this.setBounds(new Box(0, 0, width, height));
        this.ce = ce;
        this.tabs = new TabbedPanelManager(this.gui);
        this.tabs.setBounds(new Box(0, 20, width, height - 50));
        this.addElement(this.tabs);
        Button saveBtn = new Button(this.gui, this.gui.i18nFormat("button.cpm.saveCfg", new Object[0]), this::saveConfig);
        this.addElement(saveBtn);
        saveBtn.setBounds(new Box(5, height - 25, 80, 20));
        Panel topPanel = new Panel(this.gui);
        topPanel.setBounds(new Box(0, 0, width, 20));
        topPanel.setBackgroundColor(this.gui.getColors().menu_bar_background);
        this.addElement(topPanel);
        this.topPanel = new HorizontalLayout(topPanel);
        Panel general = new Panel(this.gui);
        this.addTab("general", general, 5);
        Checkbox chxbxTSBtn = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.config.titleScreenButton", new Object[0]));
        chxbxTSBtn.setSelected(ce.getSetBoolean("titleScreenButton", true));
        chxbxTSBtn.setAction(() -> {
            boolean b = !ce.getBoolean("titleScreenButton", true);
            chxbxTSBtn.setSelected(b);
            ce.setBoolean("titleScreenButton", b);
        });
        chxbxTSBtn.setBounds(new Box(5, 0, 200, 20));
        chxbxTSBtn.setTooltip(new Tooltip(frm, this.gui.i18nFormat("tooltip.cpm.config.titleScreenButton", new Object[0])));
        general.addElement(chxbxTSBtn);
        Panel editor = new Panel(this.gui);
        this.addTab("editor", editor, 5);
        FlowLayout editorLayout = new FlowLayout(editor, 5, 1);
        Button buttonRMB = new Button(this.gui, this.gui.i18nFormat("button.cpm.config.rotateButton", this.getRotateBtn()), null);
        buttonRMB.setAction(() -> {
            ce.setInt("editorRotateMouseButton", ce.getSetInt("editorRotateMouseButton", 2) == 2 ? 1 : 2);
            buttonRMB.setText(this.gui.i18nFormat("button.cpm.config.rotateButton", this.getRotateBtn()));
        });
        buttonRMB.setBounds(new Box(5, 0, 200, 20));
        editor.addElement(buttonRMB);
        if (this.gui.getMaxScale() != -1) {
            Button guiScale = new Button(this.gui, this.gui.i18nFormat("button.cpm.config.scale", this.getScale()), null);
            guiScale.setAction(() -> {
                int scale = ce.getInt("editorScale", -1) + 1;
                if (scale >= this.gui.getMaxScale()) {
                    scale = -1;
                }
                ce.setInt("editorScale", scale);
                if (popup != null) {
                    try {
                        EditorGui.rescaleGui = false;
                        popup.close();
                        this.gui.setScale(scale);
                        guiScale.setText(this.gui.i18nFormat("button.cpm.config.scale", this.getScale()));
                        frm.openPopup(popup);
                    }
                    finally {
                        EditorGui.rescaleGui = true;
                    }
                }
            });
            guiScale.setBounds(new Box(5, 0, 200, 20));
            editor.addElement(guiScale);
        }
        this.buttonPosMode = new Button(this.gui, "", null);
        this.buttonPosMode.setAction(() -> {
            ce.setBoolean("editorPosMode", !ce.getSetBoolean("editorPosMode", false));
            this.updatePosModeBtn();
        });
        this.buttonPosMode.setBounds(new Box(5, 0, 200, 20));
        this.updatePosModeBtn();
        editorLayout.reflow();
        Panel safetyTabPanel = new Panel(this.gui);
        this.addTab("safety", safetyTabPanel, 0);
        Panel safetyPanel = new Panel(this.gui);
        safetyPanel.setBounds(new Box(0, 0, width, 20));
        safetyPanel.setBackgroundColor(this.gui.getColors().menu_bar_background);
        safetyTabPanel.addElement(safetyPanel);
        this.safetyPanel = new HorizontalLayout(safetyPanel);
        this.safety = new TabbedPanelManager(this.gui);
        this.safety.setBounds(new Box(0, 20, width, height - 40));
        safetyTabPanel.addElement(this.safety);
        ConfigEntry spfs = ce.getEntry("safetyProfiles");
        SafetyHeaderPanel globalSafety = new SafetyHeaderPanel(frm, ce.getEntry("globalSettings"), width, this.gui.i18nFormat("label.cpm.globalSafetyS", new Object[0]), SettingsPanel.createMap("safetyBtn", spfs), PlayerSpecificConfigKey.KeyGroup.GLOBAL, ce);
        ScrollPanel scpG = new ScrollPanel(this.gui);
        scpG.setDisplay(globalSafety);
        this.addSafetyTab("global", scpG, 5);
        Panel serverList = new Panel(this.gui);
        this.addSafetyTab("server", serverList, 5);
        String server = MinecraftClientAccess.get().getConnectedServer();
        this.buildListPanel(serverList, ce.getEntry("serverSettings"), server != null ? new Srv(server) : null, (k, v) -> new Srv((String)k, v.getString("name", SettingsPanel.hideIp(k))), k -> ((Srv)k).ip, e -> new Tooltip(frm, this.gui.isShiftDown() && this.gui.isAltDown() ? this.gui.i18nFormat("tooltip.cpm.serverInfo", ((Srv)e).ip) : this.gui.i18nFormat("tooltip.cpm.displServerInfo", new Object[0])), SettingsPanel.createMap("nameBoxInit", true, "safetyBtn", spfs), e -> PlayerSpecificConfigKey.KeyGroup.GLOBAL, true);
        SafetyHeaderPanel friends = new SafetyHeaderPanel(frm, ce.getEntry("friendSettings"), width, this.gui.i18nFormat("label.cpm.friendSafetyS", new Object[0]), Collections.emptyMap(), PlayerSpecificConfigKey.KeyGroup.FRIEND, ce);
        ScrollPanel scpF = new ScrollPanel(this.gui);
        scpF.setDisplay(friends);
        this.addSafetyTab("friends", scpF, 5);
        Panel player = new Panel(this.gui);
        this.addSafetyTab("player", player, 5);
        this.buildListPanel(player, ce.getEntry("playerSettings"), null, (k, v) -> new Pl((String)k, v.getString("name", this.gui.i18nFormat("label.cpm.unknown", new Object[0]))), k -> ((Pl)k).uuid, e -> new Tooltip(frm, this.gui.i18nFormat("tooltip.cpm.playerInfo", ((Pl)e).name, ((Pl)e).uuid)), Collections.emptyMap(), Pl::getKeyGroup, false);
        String v2 = this.gui.i18nFormat("label.cpm.runtimeVersion", PlatformFeature.getVersion());
        this.addElement(new Label(this.gui, v2).setBounds(new Box(width - this.gui.textWidth(v2) - 3, height - 11, 0, 0)));
    }

    private void saveConfig() {
        this.ce.saveConfig();
        MinecraftClientAccess.get().getDefinitionLoader().clearCache();
        this.save.run();
    }

    public void addTab(String name, Panel panel, int topPadding) {
        panel.setBounds(new Box(0, topPadding, this.bounds.w, this.bounds.h - 50));
        this.topPanel.add(this.tabs.createTab(this.gui.i18nFormat("tab.cpm.settings." + name, new Object[0]), panel));
    }

    public void addSafetyTab(String name, Panel panel, int topPadding) {
        panel.setBounds(new Box(0, topPadding, this.bounds.w, this.bounds.h - 70));
        this.safetyPanel.add(this.safety.createTab(this.gui.i18nFormat("tab.cpm.settings.safety." + name, new Object[0]), panel));
    }

    private String getScale() {
        int scale = this.ce.getInt("editorScale", -1);
        return scale == -1 ? this.gui.i18nFormat("button.cpm.config.scale.vanilla", new Object[0]) : (scale == 0 ? this.gui.i18nFormat("button.cpm.config.scale.auto", new Object[0]) : Integer.toString(scale));
    }

    private String getRotateBtn() {
        return this.gui.i18nFormat("button.cpm.config.rotateButton." + this.ce.getInt("editorRotateMouseButton", 2), new Object[0]);
    }

    private void updatePosModeBtn() {
        String mode = this.ce.getBoolean("editorPosMode", false) ? "absolute" : "relative";
        this.buttonPosMode.setText(this.gui.i18nFormat("button.cpm.config.posMode", this.gui.i18nFormat("button.cpm.config.posMode." + mode, new Object[0])));
        this.buttonPosMode.setTooltip(new Tooltip(this.frm, this.gui.i18nFormat("tooltip.cpm.config.posMode." + mode, new Object[0])));
    }

    private <E> void buildListPanel(Panel panel, ConfigEntry ce, E current, BiFunction<String, ConfigEntry, E> func, Function<E, String> getKey, Function<E, Tooltip> tooltip, Map<String, Object> fieldsIn, Function<E, PlayerSpecificConfigKey.KeyGroup> getKg, boolean enableAdd) {
        int w = panel.getBounds().w;
        int lw = w / 4;
        int spw = w - lw - 10;
        ScrollPanel scpS = new ScrollPanel(this.gui);
        scpS.setBounds(new Box(lw + 10, 5, spw, panel.getBounds().h - 10));
        scpS.setVisible(false);
        List entries = ce.keySet().stream().map(k -> func.apply((String)k, ce.getEntry((String)k))).collect(Collectors.toList());
        if (current != null && !ce.hasEntry(getKey.apply(current))) {
            entries.add(current);
        }
        ListPanel playerList = new ListPanel(this.gui, entries, w, panel.getBounds().h - 30);
        playerList.setGetTooltip(tooltip);
        Consumer<Object> selEvt = s -> {
            if (s != null) {
                playerList.setWidth(lw);
                HashMap<String, Object> f = new HashMap<String, Object>(fieldsIn);
                if (fieldsIn.containsKey("nameBoxInit")) {
                    f.put("nameBox", s.toString());
                }
                scpS.setDisplay(new SafetyHeaderPanel(this.frm, ce.getEntry((String)getKey.apply(s)), spw, this.gui.i18nFormat("label.cpm.sSettingsFor", s.toString()), f, (PlayerSpecificConfigKey.KeyGroup)((Object)((Object)getKg.apply(s))), this.ce));
            } else {
                playerList.setWidth(w);
            }
            scpS.setVisible(s != null);
        };
        playerList.setSelect(selEvt);
        playerList.setBounds(new Box(0, 0, w, panel.getBounds().h - 30));
        playerList.setWidth(w);
        if (current != null) {
            playerList.setSelected(current);
            selEvt.accept(current);
        }
        ButtonIcon newBtn = new ButtonIcon(this.gui, "editor", 0, 16, () -> this.frm.openPopup(new InputPopup(this.frm, this.gui.i18nFormat("label.cpm.enterServerIP", new Object[0]), key -> {
            if (!ce.keySet().contains(key)) {
                ConfigEntry ne = ce.getEntry((String)key);
                Object newE = func.apply((String)key, ne);
                entries.add(newE);
                playerList.setSelected(newE);
                selEvt.accept(newE);
                playerList.refreshList();
            }
        }, null)));
        newBtn.setEnabled(enableAdd);
        newBtn.setBounds(new Box(5, panel.getBounds().h - 25, 18, 18));
        ButtonIcon delBtn = new ButtonIcon(this.gui, "editor", 14, 16, () -> {
            Object elem = playerList.getSelected();
            if (elem != null) {
                this.frm.openPopup(new ConfirmPopup(this.frm, this.gui.i18nFormat("label.cpm.confirmDel", new Object[0]), () -> {
                    entries.remove(elem);
                    ce.clearValue((String)getKey.apply(elem));
                    scpS.setVisible(false);
                    playerList.setWidth(w);
                    playerList.refreshList();
                }, null));
            }
        });
        delBtn.setBounds(new Box(30, panel.getBounds().h - 25, 18, 18));
        panel.addElement(playerList);
        panel.addElement(newBtn);
        panel.addElement(delBtn);
        panel.addElement(scpS);
    }

    private static Map<String, Object> createMap(Object ... dataIn) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (int i = 0; i < dataIn.length; i += 2) {
            String key = (String)dataIn[i];
            Object v = dataIn[i + 1];
            data.put(key, v);
        }
        return data;
    }

    public static String hideIp(String ip) {
        ip = ip.replaceAll("[0-9]", "*");
        int cnt = 0;
        StringBuilder bb = new StringBuilder();
        for (int i = 0; i < ip.length(); ++i) {
            char c = ip.charAt(i);
            if (c == '.' || c == ':') {
                cnt = -1;
            }
            if (cnt++ > 1) {
                c = '*';
            }
            bb.append(c);
        }
        ip = bb.toString();
        return ip;
    }

    public boolean isChanged() {
        return this.ce.isDirty();
    }

    private class Pl {
        private String uuid;
        private String name;

        public Pl(String uuid, String name) {
            this.uuid = uuid;
            this.name = name;
        }

        public PlayerSpecificConfigKey.KeyGroup getKeyGroup() {
            return SettingsPanel.this.ce.getEntry("friendList").keySet().contains(this.uuid) ? PlayerSpecificConfigKey.KeyGroup.FRIEND : PlayerSpecificConfigKey.KeyGroup.GLOBAL;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class Srv {
        private String ip;
        private String name;

        public Srv(String ip, String name) {
            this.ip = ip;
            this.name = name;
        }

        public Srv(String ip) {
            this.ip = ip;
            this.name = SettingsPanel.hideIp(ip);
        }

        public String toString() {
            return this.name;
        }
    }
}

